/*
 * Decompiled with CFR 0.152.
 */
package wallettemplate;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import com.google.protobuf.ByteString;
import java.time.Duration;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import org.bitcoinj.crypto.KeyCrypterScrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongycastle.crypto.params.KeyParameter;
import wallettemplate.Main;
import wallettemplate.utils.GuiUtils;
import wallettemplate.utils.KeyDerivationTasks;

public class WalletPasswordController {
    private static final Logger log = LoggerFactory.getLogger(WalletPasswordController.class);
    @FXML
    HBox buttonsBox;
    @FXML
    PasswordField pass1;
    @FXML
    ImageView padlockImage;
    @FXML
    ProgressIndicator progressMeter;
    @FXML
    GridPane widgetGrid;
    @FXML
    Label explanationLabel;
    public Main.OverlayUI overlayUI;
    private SimpleObjectProperty<KeyParameter> aesKey = new SimpleObjectProperty();
    public static final String TAG = WalletPasswordController.class.getName() + ".target-time";

    public void initialize() {
        this.progressMeter.setOpacity(0.0);
        Platform.runLater(() -> ((PasswordField)this.pass1).requestFocus());
    }

    @FXML
    void confirmClicked(ActionEvent event) {
        String password = this.pass1.getText();
        if (password.isEmpty() || password.length() < 4) {
            GuiUtils.informationalAlert("Bad password", "The password you entered is empty or too short.", new Object[0]);
            return;
        }
        KeyCrypterScrypt keyCrypter = (KeyCrypterScrypt)Main.bitcoin.wallet().getKeyCrypter();
        Preconditions.checkNotNull((Object)keyCrypter);
        KeyDerivationTasks tasks = new KeyDerivationTasks(keyCrypter, password, WalletPasswordController.getTargetTime()){

            @Override
            protected void onFinish(KeyParameter aesKey, int timeTakenMsec) {
                GuiUtils.checkGuiThread();
                if (Main.bitcoin.wallet().checkAESKey(aesKey)) {
                    WalletPasswordController.this.aesKey.set((Object)aesKey);
                } else {
                    log.warn("User entered incorrect password");
                    GuiUtils.fadeOut((Node)WalletPasswordController.this.progressMeter);
                    GuiUtils.fadeIn((Node)WalletPasswordController.this.widgetGrid);
                    GuiUtils.fadeIn((Node)WalletPasswordController.this.explanationLabel);
                    GuiUtils.fadeIn((Node)WalletPasswordController.this.buttonsBox);
                    GuiUtils.informationalAlert("Wrong password", "Please try entering your password again, carefully checking for typos or spelling errors.", new Object[0]);
                }
            }
        };
        this.progressMeter.progressProperty().bind((ObservableValue)tasks.progress);
        tasks.start();
        GuiUtils.fadeIn((Node)this.progressMeter);
        GuiUtils.fadeOut((Node)this.widgetGrid);
        GuiUtils.fadeOut((Node)this.explanationLabel);
        GuiUtils.fadeOut((Node)this.buttonsBox);
    }

    public void cancelClicked(ActionEvent event) {
        this.overlayUI.done();
    }

    public ReadOnlyObjectProperty<KeyParameter> aesKeyProperty() {
        return this.aesKey;
    }

    public static void setTargetTime(Duration targetTime) {
        ByteString bytes = ByteString.copyFrom((byte[])Longs.toByteArray((long)targetTime.toMillis()));
        Main.bitcoin.wallet().setTag(TAG, bytes);
    }

    public static Duration getTargetTime() throws IllegalArgumentException {
        return Duration.ofMillis(Longs.fromByteArray((byte[])Main.bitcoin.wallet().getTag(TAG).toByteArray()));
    }
}

