/*
 * Decompiled with CFR 0.152.
 */
package wallettemplate.controls;

import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.util.Duration;
import javax.annotation.Nullable;
import wallettemplate.utils.GuiUtils;
import wallettemplate.utils.easing.EasingMode;
import wallettemplate.utils.easing.ElasticInterpolator;

public class NotificationBarPane
extends BorderPane {
    public static final Duration ANIM_IN_DURATION = GuiUtils.UI_ANIMATION_TIME.multiply(2.0);
    public static final Duration ANIM_OUT_DURATION = GuiUtils.UI_ANIMATION_TIME;
    private HBox bar;
    private Label label;
    private double barHeight;
    private ProgressBar progressBar = new ProgressBar();
    public final ObservableList<Item> items;
    private Timeline timeline;

    public NotificationBarPane(Node content) {
        super(content);
        this.label = new Label("infobar!");
        this.bar = new HBox(new Node[]{this.label});
        this.bar.setMinHeight(0.0);
        this.bar.getStyleClass().add((Object)"info-bar");
        this.bar.setFillHeight(true);
        this.setBottom((Node)this.bar);
        this.sceneProperty().addListener(o -> {
            if (this.getParent() == null) {
                return;
            }
            this.getParent().applyCss();
            this.getParent().layout();
            this.barHeight = this.bar.getHeight();
            this.bar.setPrefHeight(0.0);
        });
        this.items = FXCollections.observableArrayList();
        this.items.addListener(change -> {
            this.config();
            this.showOrHide();
        });
    }

    private void config() {
        if (this.items.isEmpty()) {
            return;
        }
        Item item = (Item)this.items.get(0);
        this.bar.getChildren().clear();
        this.label.textProperty().bind((ObservableValue)item.label);
        this.label.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow((Node)this.label, (Priority)Priority.ALWAYS);
        this.bar.getChildren().add((Object)this.label);
        if (item.progress != null) {
            this.progressBar.setMinWidth(200.0);
            this.progressBar.progressProperty().bind((ObservableValue)item.progress);
            this.bar.getChildren().add((Object)this.progressBar);
        }
    }

    private void showOrHide() {
        if (this.items.isEmpty()) {
            this.animateOut();
        } else {
            this.animateIn();
        }
    }

    public boolean isShowing() {
        return this.bar.getPrefHeight() > 0.0;
    }

    private void animateIn() {
        this.animate(this.barHeight);
    }

    private void animateOut() {
        this.animate(0.0);
    }

    protected void animate(Number target) {
        Duration duration;
        Interpolator interpolator;
        if (this.timeline != null) {
            this.timeline.stop();
            this.timeline = null;
        }
        if (target.intValue() > 0) {
            interpolator = new ElasticInterpolator(EasingMode.EASE_OUT, 1.0, 2.0);
            duration = ANIM_IN_DURATION;
        } else {
            interpolator = Interpolator.EASE_OUT;
            duration = ANIM_OUT_DURATION;
        }
        KeyFrame kf = new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)this.bar.prefHeightProperty(), (Object)target, interpolator)});
        this.timeline = new Timeline(new KeyFrame[]{kf});
        this.timeline.setOnFinished(x -> {
            this.timeline = null;
        });
        this.timeline.play();
    }

    public Item pushItem(String string, @Nullable ObservableDoubleValue progress) {
        Item i = new Item(string, progress);
        this.items.add((Object)i);
        return i;
    }

    public class Item {
        public final SimpleStringProperty label;
        @Nullable
        public final ObservableDoubleValue progress;

        public Item(@Nullable String label, ObservableDoubleValue progress) {
            this.label = new SimpleStringProperty(label);
            this.progress = progress;
        }

        public void cancel() {
            NotificationBarPane.this.items.remove((Object)this);
        }
    }
}

