/*
 * Decompiled with CFR 0.152.
 */
package wallettemplate.utils;

import java.util.Date;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.bitcoinj.core.AbstractWalletEventListener;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.DownloadProgressTracker;
import org.bitcoinj.core.Wallet;
import org.bitcoinj.core.WalletEventListener;

public class BitcoinUIModel {
    private SimpleObjectProperty<Address> address = new SimpleObjectProperty();
    private SimpleObjectProperty<Coin> balance = new SimpleObjectProperty((Object)Coin.ZERO);
    private SimpleDoubleProperty syncProgress = new SimpleDoubleProperty(-1.0);
    private ProgressBarUpdater syncProgressUpdater = new ProgressBarUpdater();

    public BitcoinUIModel() {
    }

    public BitcoinUIModel(Wallet wallet) {
        this.setWallet(wallet);
    }

    public void setWallet(Wallet wallet) {
        wallet.addEventListener((WalletEventListener)new AbstractWalletEventListener(){

            public void onWalletChanged(Wallet wallet) {
                super.onWalletChanged(wallet);
                BitcoinUIModel.this.update(wallet);
            }
        }, Platform::runLater);
        this.update(wallet);
    }

    private void update(Wallet wallet) {
        this.balance.set((Object)wallet.getBalance());
        this.address.set((Object)wallet.currentReceiveAddress());
    }

    public DownloadProgressTracker getDownloadProgressTracker() {
        return this.syncProgressUpdater;
    }

    public ReadOnlyDoubleProperty syncProgressProperty() {
        return this.syncProgress;
    }

    public ReadOnlyObjectProperty<Address> addressProperty() {
        return this.address;
    }

    public ReadOnlyObjectProperty<Coin> balanceProperty() {
        return this.balance;
    }

    private class ProgressBarUpdater
    extends DownloadProgressTracker {
        private ProgressBarUpdater() {
        }

        protected void progress(double pct, int blocksLeft, Date date) {
            super.progress(pct, blocksLeft, date);
            Platform.runLater(() -> BitcoinUIModel.this.syncProgress.set(pct / 100.0));
        }

        protected void doneDownload() {
            super.doneDownload();
            Platform.runLater(() -> BitcoinUIModel.this.syncProgress.set(1.0));
        }
    }
}

