/*
 * Decompiled with CFR 0.152.
 */
package wallettemplate.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.net.URL;
import java.util.function.BiConsumer;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ScaleTransition;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.value.WritableValue;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.effect.Effect;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.layout.Pane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.util.Duration;
import wallettemplate.MainController;
import wallettemplate.utils.AlertWindowController;

public class GuiUtils {
    public static final int UI_ANIMATION_TIME_MSEC = 600;
    public static final Duration UI_ANIMATION_TIME = Duration.millis((double)600.0);

    public static void runAlert(BiConsumer<Stage, AlertWindowController> setup) {
        try {
            Stage dialogStage = new Stage();
            dialogStage.initModality(Modality.APPLICATION_MODAL);
            FXMLLoader loader = new FXMLLoader(GuiUtils.class.getResource("alert.fxml"));
            Pane pane = (Pane)loader.load();
            AlertWindowController controller = (AlertWindowController)loader.getController();
            setup.accept(dialogStage, controller);
            dialogStage.setScene(new Scene((Parent)pane));
            dialogStage.showAndWait();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void crashAlert(Throwable t) {
        t.printStackTrace();
        Throwable rootCause = Throwables.getRootCause((Throwable)t);
        Runnable r = () -> {
            GuiUtils.runAlert((stage, controller) -> controller.crashAlert((Stage)stage, rootCause.toString()));
            Platform.exit();
        };
        if (Platform.isFxApplicationThread()) {
            r.run();
        } else {
            Platform.runLater((Runnable)r);
        }
    }

    public static void handleCrashesOnThisThread() {
        Thread.currentThread().setUncaughtExceptionHandler((thread, exception) -> GuiUtils.crashAlert(Throwables.getRootCause((Throwable)exception)));
    }

    public static void informationalAlert(String message, String details, Object ... args) {
        String formattedDetails = String.format(details, args);
        Runnable r = () -> GuiUtils.runAlert((stage, controller) -> controller.informational((Stage)stage, message, formattedDetails));
        if (Platform.isFxApplicationThread()) {
            r.run();
        } else {
            Platform.runLater((Runnable)r);
        }
    }

    public static Animation fadeIn(Node ui) {
        return GuiUtils.fadeIn(ui, 0);
    }

    public static Animation fadeIn(Node ui, int delayMillis) {
        ui.setCache(true);
        FadeTransition ft = new FadeTransition(Duration.millis((double)600.0), ui);
        ft.setFromValue(0.0);
        ft.setToValue(1.0);
        ft.setOnFinished(ev -> ui.setCache(false));
        ft.setDelay(Duration.millis((double)delayMillis));
        ft.play();
        return ft;
    }

    public static Animation fadeOut(Node ui) {
        FadeTransition ft = new FadeTransition(Duration.millis((double)600.0), ui);
        ft.setFromValue(ui.getOpacity());
        ft.setToValue(0.0);
        ft.play();
        return ft;
    }

    public static Animation fadeOutAndRemove(Pane parentPane, Node ... nodes) {
        Animation animation = GuiUtils.fadeOut(nodes[0]);
        animation.setOnFinished(actionEvent -> parentPane.getChildren().removeAll((Object[])nodes));
        return animation;
    }

    public static Animation fadeOutAndRemove(Duration duration, Pane parentPane, Node ... nodes) {
        nodes[0].setCache(true);
        FadeTransition ft = new FadeTransition(duration, nodes[0]);
        ft.setFromValue(nodes[0].getOpacity());
        ft.setToValue(0.0);
        ft.setOnFinished(actionEvent -> parentPane.getChildren().removeAll((Object[])nodes));
        ft.play();
        return ft;
    }

    public static void blurOut(Node node) {
        GaussianBlur blur = new GaussianBlur(0.0);
        node.setEffect((Effect)blur);
        Timeline timeline = new Timeline();
        KeyValue kv = new KeyValue((WritableValue)blur.radiusProperty(), (Object)10.0);
        KeyFrame kf = new KeyFrame(Duration.millis((double)600.0), new KeyValue[]{kv});
        timeline.getKeyFrames().add((Object)kf);
        timeline.play();
    }

    public static void blurIn(Node node) {
        GaussianBlur blur = (GaussianBlur)node.getEffect();
        Timeline timeline = new Timeline();
        KeyValue kv = new KeyValue((WritableValue)blur.radiusProperty(), (Object)0.0);
        KeyFrame kf = new KeyFrame(Duration.millis((double)600.0), new KeyValue[]{kv});
        timeline.getKeyFrames().add((Object)kf);
        timeline.setOnFinished(actionEvent -> node.setEffect(null));
        timeline.play();
    }

    public static ScaleTransition zoomIn(Node node) {
        return GuiUtils.zoomIn(node, 0);
    }

    public static ScaleTransition zoomIn(Node node, int delayMillis) {
        return GuiUtils.scaleFromTo(node, 0.95, 1.0, delayMillis);
    }

    public static ScaleTransition explodeOut(Node node) {
        return GuiUtils.scaleFromTo(node, 1.0, 1.05, 0);
    }

    private static ScaleTransition scaleFromTo(Node node, double from, double to, int delayMillis) {
        ScaleTransition scale = new ScaleTransition(Duration.millis((double)300.0), node);
        scale.setFromX(from);
        scale.setFromY(from);
        scale.setToX(to);
        scale.setToY(to);
        scale.setDelay(Duration.millis((double)delayMillis));
        scale.play();
        return scale;
    }

    public static URL getResource(String name) {
        return MainController.class.getResource(name);
    }

    public static void checkGuiThread() {
        Preconditions.checkState((boolean)Platform.isFxApplicationThread());
    }

    private static /* synthetic */ URL lambda$getResource$11(String string) throws Throwable {
        return new URL("file:///your/path/here/src/main/wallettemplate/" + string);
    }
}

