/*
 * Decompiled with CFR 0.152.
 */
package wallettemplate.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WTUtils {
    private static final Logger log = LoggerFactory.getLogger(WTUtils.class);

    public static <T> T unchecked(UncheckedRun<T> run) {
        try {
            return run.run();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static void uncheck(UncheckedRunnable run) {
        try {
            run.run();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static void ignoreAndLog(UncheckedRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable t) {
            log.error("Ignoring error", t);
        }
    }

    public static <T> T ignoredAndLogged(UncheckedRun<T> runnable) {
        try {
            return runnable.run();
        }
        catch (Throwable t) {
            log.error("Ignoring error", t);
            return null;
        }
    }

    public static boolean didThrow(UncheckedRun run) {
        try {
            run.run();
            return false;
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    public static boolean didThrow(UncheckedRunnable run) {
        try {
            run.run();
            return false;
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    public static interface UncheckedRunnable {
        public void run() throws Throwable;
    }

    public static interface UncheckedRun<T> {
        public T run() throws Throwable;
    }
}

