/*
 * Decompiled with CFR 0.152.
 */
package wallettemplate.utils;

import com.google.common.util.concurrent.Uninterruptibles;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.concurrent.Task;
import javax.annotation.Nullable;
import org.bitcoinj.crypto.KeyCrypterScrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongycastle.crypto.params.KeyParameter;
import wallettemplate.utils.GuiUtils;

public class KeyDerivationTasks {
    private static final Logger log = LoggerFactory.getLogger(KeyDerivationTasks.class);
    public final Task<KeyParameter> keyDerivationTask;
    public final ReadOnlyDoubleProperty progress;
    private final Task<Void> progressTask;
    private volatile int timeTakenMsec = -1;

    public KeyDerivationTasks(final KeyCrypterScrypt scrypt, final String password, final @Nullable Duration targetTime) {
        this.keyDerivationTask = new Task<KeyParameter>(){

            protected KeyParameter call() throws Exception {
                long start = System.currentTimeMillis();
                try {
                    log.info("Started key derivation");
                    KeyParameter result = scrypt.deriveKey((CharSequence)password);
                    KeyDerivationTasks.this.timeTakenMsec = (int)(System.currentTimeMillis() - start);
                    log.info("Key derivation done in {}ms", (Object)KeyDerivationTasks.this.timeTakenMsec);
                    return result;
                }
                catch (Throwable e) {
                    log.error("Exception during key derivation", e);
                    throw e;
                }
            }
        };
        this.progressTask = new Task<Void>(){
            private KeyParameter aesKey;

            protected Void call() throws Exception {
                if (targetTime != null) {
                    long curTime;
                    long startTime = System.currentTimeMillis();
                    long targetTimeMillis = targetTime.toMillis();
                    while ((curTime = System.currentTimeMillis()) < startTime + targetTimeMillis) {
                        double progress = (double)(curTime - startTime) / (double)targetTimeMillis;
                        this.updateProgress(progress, 1.0);
                        Uninterruptibles.sleepUninterruptibly((long)20L, (TimeUnit)TimeUnit.MILLISECONDS);
                    }
                    this.updateProgress(1.0, 1.0);
                } else {
                    this.updateProgress(-1L, -1L);
                }
                this.aesKey = (KeyParameter)KeyDerivationTasks.this.keyDerivationTask.get();
                return null;
            }

            protected void succeeded() {
                GuiUtils.checkGuiThread();
                KeyDerivationTasks.this.onFinish(this.aesKey, KeyDerivationTasks.this.timeTakenMsec);
            }
        };
        this.progress = this.progressTask.progressProperty();
    }

    public void start() {
        new Thread((Runnable)this.keyDerivationTask, "Key derivation").start();
        new Thread((Runnable)this.progressTask, "Progress ticker").start();
    }

    protected void onFinish(KeyParameter aesKey, int timeTakenMsec) {
    }
}

