/*
 * Decompiled with CFR 0.152.
 */
package wallettemplate;

import com.google.protobuf.ByteString;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.layout.GridPane;
import org.bitcoinj.crypto.KeyCrypter;
import org.bitcoinj.crypto.KeyCrypterScrypt;
import org.bitcoinj.wallet.Protos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongycastle.crypto.params.KeyParameter;
import wallettemplate.Main;
import wallettemplate.WalletPasswordController;
import wallettemplate.utils.GuiUtils;
import wallettemplate.utils.KeyDerivationTasks;

public class WalletSetPasswordController {
    private static final Logger log = LoggerFactory.getLogger(WalletSetPasswordController.class);
    public PasswordField pass1;
    public PasswordField pass2;
    public ProgressIndicator progressMeter;
    public GridPane widgetGrid;
    public Button closeButton;
    public Label explanationLabel;
    public Main.OverlayUI overlayUI;
    public static final Protos.ScryptParameters SCRYPT_PARAMETERS = Protos.ScryptParameters.newBuilder().setP(6).setR(8).setN(32768L).setSalt(ByteString.copyFrom((byte[])KeyCrypterScrypt.randomSalt())).build();
    public static Duration estimatedKeyDerivationTime = null;

    public void initialize() {
        this.progressMeter.setOpacity(0.0);
    }

    public static CompletableFuture<Duration> estimateKeyDerivationTimeMsec() {
        CompletableFuture<Duration> future = new CompletableFuture<Duration>();
        new Thread(() -> {
            log.info("Doing background test key derivation");
            KeyCrypterScrypt scrypt = new KeyCrypterScrypt(SCRYPT_PARAMETERS);
            long start = System.currentTimeMillis();
            scrypt.deriveKey((CharSequence)"test password");
            long msec = System.currentTimeMillis() - start;
            log.info("Background test key derivation took {}msec", (Object)msec);
            Platform.runLater(() -> {
                estimatedKeyDerivationTime = Duration.ofMillis(msec);
                future.complete(estimatedKeyDerivationTime);
            });
        }).start();
        return future;
    }

    @FXML
    public void setPasswordClicked(ActionEvent event) {
        if (!this.pass1.getText().equals(this.pass2.getText())) {
            GuiUtils.informationalAlert("Passwords do not match", "Try re-typing your chosen passwords.", new Object[0]);
            return;
        }
        String password = this.pass1.getText();
        if (password.length() < 4) {
            GuiUtils.informationalAlert("Password too short", "You need to pick a password at least five characters or longer.", new Object[0]);
            return;
        }
        GuiUtils.fadeIn((Node)this.progressMeter);
        GuiUtils.fadeOut((Node)this.widgetGrid);
        GuiUtils.fadeOut((Node)this.explanationLabel);
        GuiUtils.fadeOut((Node)this.closeButton);
        final KeyCrypterScrypt scrypt = new KeyCrypterScrypt(SCRYPT_PARAMETERS);
        KeyDerivationTasks tasks = new KeyDerivationTasks(scrypt, password, estimatedKeyDerivationTime){

            @Override
            protected final void onFinish(KeyParameter aesKey, int timeTakenMsec) {
                WalletPasswordController.setTargetTime(Duration.ofMillis(timeTakenMsec));
                log.info("Key derived, now encrypting");
                Main.bitcoin.wallet().encrypt((KeyCrypter)scrypt, aesKey);
                log.info("Encryption done");
                GuiUtils.informationalAlert("Wallet encrypted", "You can remove the password at any time from the settings screen.", new Object[0]);
                WalletSetPasswordController.this.overlayUI.done();
            }
        };
        this.progressMeter.progressProperty().bind((ObservableValue)tasks.progress);
        tasks.start();
    }

    public void closeClicked(ActionEvent event) {
        this.overlayUI.done();
    }
}

