/*
 * Decompiled with CFR 0.152.
 */
package wallettemplate;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.util.concurrent.Service;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextInputControl;
import javax.annotation.Nullable;
import org.bitcoinj.core.Utils;
import org.bitcoinj.crypto.KeyCrypter;
import org.bitcoinj.crypto.MnemonicCode;
import org.bitcoinj.wallet.DeterministicSeed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongycastle.crypto.params.KeyParameter;
import wallettemplate.Main;
import wallettemplate.WalletPasswordController;
import wallettemplate.utils.GuiUtils;
import wallettemplate.utils.TextFieldValidator;
import wallettemplate.utils.WTUtils;

public class WalletSettingsController {
    private static final Logger log = LoggerFactory.getLogger(WalletSettingsController.class);
    @FXML
    Button passwordButton;
    @FXML
    DatePicker datePicker;
    @FXML
    TextArea wordsArea;
    @FXML
    Button restoreButton;
    public Main.OverlayUI overlayUI;
    private KeyParameter aesKey;

    public void initialize(@Nullable KeyParameter aesKey) {
        DeterministicSeed seed = Main.bitcoin.wallet().getKeyChainSeed();
        if (aesKey == null) {
            if (seed.isEncrypted()) {
                log.info("Wallet is encrypted, requesting password first.");
                Platform.runLater(() -> this.askForPasswordAndRetry());
                return;
            }
        } else {
            this.aesKey = aesKey;
            seed = seed.decrypt((KeyCrypter)Preconditions.checkNotNull((Object)Main.bitcoin.wallet().getKeyCrypter()), "", aesKey);
            this.passwordButton.setText("Remove password");
        }
        Instant creationTime = Instant.ofEpochSecond(seed.getCreationTimeSeconds());
        LocalDate origDate = creationTime.atZone(ZoneId.systemDefault()).toLocalDate();
        this.datePicker.setValue((Object)origDate);
        List mnemonicCode = seed.getMnemonicCode();
        Preconditions.checkNotNull((Object)mnemonicCode);
        String origWords = Utils.join((Iterable)mnemonicCode);
        this.wordsArea.setText(origWords);
        MnemonicCode codec = WTUtils.unchecked(MnemonicCode::new);
        TextFieldValidator validator = new TextFieldValidator((TextInputControl)this.wordsArea, text -> !WTUtils.didThrow(() -> codec.check(Splitter.on((char)' ').splitToList((CharSequence)text))));
        this.wordsArea.textProperty().addListener(o -> {
            if (origDate.equals(this.datePicker.getValue())) {
                this.datePicker.setValue(null);
            }
        });
        BooleanBinding datePickerIsInvalid = Bindings.or((ObservableBooleanValue)this.datePicker.valueProperty().isNull(), (ObservableBooleanValue)Bindings.createBooleanBinding(() -> ((LocalDate)this.datePicker.getValue()).isAfter(LocalDate.now()), (Observable[])new Observable[]{this.datePicker.valueProperty()}));
        this.restoreButton.disableProperty().bind((ObservableValue)Bindings.or((ObservableBooleanValue)Bindings.or((ObservableBooleanValue)Bindings.not((ObservableBooleanValue)validator.valid), (ObservableBooleanValue)Bindings.equal((String)origWords, (ObservableStringValue)this.wordsArea.textProperty())), (ObservableBooleanValue)datePickerIsInvalid));
        datePickerIsInvalid.addListener((dp, old, cur) -> {
            if (cur.booleanValue()) {
                this.datePicker.getStyleClass().add((Object)"validation_error");
            } else {
                this.datePicker.getStyleClass().remove((Object)"validation_error");
            }
        });
    }

    private void askForPasswordAndRetry() {
        Main.OverlayUI pwd = Main.instance.overlayUI("wallet_password.fxml");
        ((WalletPasswordController)pwd.controller).aesKeyProperty().addListener((observable, old, cur) -> {
            GuiUtils.checkGuiThread();
            Main.OverlayUI screen = Main.instance.overlayUI("wallet_settings.fxml");
            ((WalletSettingsController)screen.controller).initialize((KeyParameter)cur);
        });
    }

    public void closeClicked(ActionEvent event) {
        this.overlayUI.done();
    }

    public void restoreClicked(ActionEvent event) {
        if (Main.bitcoin.wallet().getBalance().value > 0L) {
            GuiUtils.informationalAlert("Wallet is not empty", "You must empty this wallet out before attempting to restore an older one, as mixing wallets together can lead to invalidated backups.", new Object[0]);
            return;
        }
        if (this.aesKey != null) {
            GuiUtils.informationalAlert("Wallet is encrypted", "After restore, the wallet will no longer be encrypted and you must set a new password.", new Object[0]);
        }
        log.info("Attempting wallet restore using seed '{}' from date {}", (Object)this.wordsArea.getText(), this.datePicker.getValue());
        GuiUtils.informationalAlert("Wallet restore in progress", "Your wallet will now be resynced from the Bitcoin network. This can take a long time for old wallets.", new Object[0]);
        this.overlayUI.done();
        Main.instance.controller.restoreFromSeedAnimation();
        long birthday = ((LocalDate)this.datePicker.getValue()).atStartOfDay().toEpochSecond(ZoneOffset.UTC);
        final DeterministicSeed seed = new DeterministicSeed(Splitter.on((char)' ').splitToList((CharSequence)this.wordsArea.getText()), null, "", birthday);
        Main.bitcoin.addListener(new Service.Listener(){

            public void terminated(Service.State from) {
                Main.instance.setupWalletKit(seed);
                Main.bitcoin.startAsync();
            }
        }, Platform::runLater);
        Main.bitcoin.stopAsync();
    }

    public void passwordButtonClicked(ActionEvent event) {
        if (this.aesKey == null) {
            Main.instance.overlayUI("wallet_set_password.fxml");
        } else {
            Main.bitcoin.wallet().decrypt(this.aesKey);
            GuiUtils.informationalAlert("Wallet decrypted", "A password will no longer be required to send money or edit settings.", new Object[0]);
            this.passwordButton.setText("Set password");
            this.aesKey = null;
        }
    }
}

