/*
 * Decompiled with CFR 0.152.
 */
package wallettemplate.controls;

import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.AddressFormatException;
import org.bitcoinj.core.NetworkParameters;
import wallettemplate.utils.TextFieldValidator;

public class BitcoinAddressValidator {
    private NetworkParameters params;
    private Node[] nodes;

    public BitcoinAddressValidator(NetworkParameters params, TextField field, Node ... nodes) {
        this.params = params;
        this.nodes = nodes;
        new TextFieldValidator((TextInputControl)field, text -> text.isEmpty() || this.testAddr((String)text));
        field.textProperty().addListener((observableValue, prev, current) -> this.toggleButtons((String)current));
        this.toggleButtons(field.getText());
    }

    private void toggleButtons(String current) {
        boolean valid = this.testAddr(current);
        for (Node n : this.nodes) {
            n.setDisable(!valid);
        }
    }

    private boolean testAddr(String text) {
        try {
            Address.fromBase58((NetworkParameters)this.params, (String)text);
            return true;
        }
        catch (AddressFormatException e) {
            return false;
        }
    }
}

