/*
 * Decompiled with CFR 0.152.
 */
package wallettemplate.utils;

import java.util.function.Predicate;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.Scene;
import javafx.scene.control.TextInputControl;

public class TextFieldValidator {
    public final BooleanProperty valid = new SimpleBooleanProperty(false);

    public TextFieldValidator(TextInputControl control, Predicate<String> validator) {
        this.valid.set(validator.test(control.getText()));
        TextFieldValidator.apply(control, this.valid.get());
        control.textProperty().addListener((observableValue, prev, current) -> {
            boolean nowValid = validator.test((String)current);
            if (nowValid == this.valid.get()) {
                return;
            }
            this.valid.set(nowValid);
        });
        this.valid.addListener(o -> TextFieldValidator.apply(control, this.valid.get()));
    }

    private static void apply(TextInputControl textField, boolean nowValid) {
        if (nowValid) {
            textField.getStyleClass().remove((Object)"validation_error");
        } else {
            textField.getStyleClass().add((Object)"validation_error");
        }
    }

    public static void configureScene(Scene scene) {
        String file = TextFieldValidator.class.getResource("text-validation.css").toString();
        scene.getStylesheets().add((Object)file);
    }
}

