/*
 * MIT License
 *
 * Copyright (c) 2018-2019 Yoann CAPLAIN
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package org.blackdread.camerabinding.jna;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;

import java.util.Arrays;
import java.util.List;

/**
 * <i>native declaration : sdk-header\EDSDKTypes.h</i><br>
 * This file was autogenerated by <a href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few opensource projects.</a>.<br>
 * For help, please visit <a href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> , <a href="http://rococoa.dev.java.net/">Rococoa</a>, or <a href="http://jna.dev.java.net/">JNA</a>.
 */
public class EdsDirectoryItemInfo extends Structure {
	/** C type : EdsUInt64
     * The file size. For folders, the file size is indicated as 0.
     */
	public long size;
	/** C type : EdsBool
     * If a folder: True
     * If not a folder: False
     */
	public int isFolder;
	/** C type : EdsUInt32
     * A non-zero integer. The same group ID is assigned to files that belong to the same group, such as RAW+JPEG images or RAW+AVI images
     */
	public NativeLong groupID;
	/** C type : EdsUInt32
     * An option when a direct transfer request is received (a kEdsObjectEvent_DirItemRequestTransferDT event).
     * kEdsTransferOptionToDesktop is set when [Wallpaper] in the direct transfer is executed by means of camera operations.
     * Prohibit it under other timing conditions.
     */
	public NativeLong option;
	/** C type : EdsChar[256]
     * Returns the directory name or file name if successful.
     * Example: "_MG_0060.JPG"
     */
	public byte[] szFileName = new byte[256];
	/** C type : EdsUInt32
     * Returns the directory item type.
     * Note:This type is defined in EdsImageType.
     * */
	public NativeLong format;
	/** C type : EdsUInt32 */
	public NativeLong dateTime;
	public EdsDirectoryItemInfo() {
		super();
	}
    @Override
	protected List<String> getFieldOrder() {
		return Arrays.asList("size", "isFolder", "groupID", "option", "szFileName", "format", "dateTime");
	}
	/**
	 * @param size C type : EdsUInt64<br>
	 * @param isFolder C type : EdsBool<br>
	 * @param groupID C type : EdsUInt32<br>
	 * @param option C type : EdsUInt32<br>
	 * @param szFileName C type : EdsChar[256]<br>
	 * @param format C type : EdsUInt32<br>
	 * @param dateTime C type : EdsUInt32
	 */
	public EdsDirectoryItemInfo(long size, int isFolder, NativeLong groupID, NativeLong option, byte szFileName[], NativeLong format, NativeLong dateTime) {
		super();
		this.size = size;
		this.isFolder = isFolder;
		this.groupID = groupID;
		this.option = option;
		if ((szFileName.length != this.szFileName.length))
			throw new IllegalArgumentException("Wrong array size !");
		this.szFileName = szFileName;
		this.format = format;
		this.dateTime = dateTime;
	}
	public EdsDirectoryItemInfo(Pointer peer) {
		super(peer);
	}
	public static class ByReference extends EdsDirectoryItemInfo implements Structure.ByReference {

	}
	public static class ByValue extends EdsDirectoryItemInfo implements Structure.ByValue {

	}
}
