/*
 * MIT License
 *
 * Copyright (c) 2018-2019 Yoann CAPLAIN
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package org.blackdread.camerabinding.jna;

import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import org.blackdread.camerabinding.jna.EdsdkLibrary.EdsGetStreamLength;
import org.blackdread.camerabinding.jna.EdsdkLibrary.EdsReadStream;
import org.blackdread.camerabinding.jna.EdsdkLibrary.EdsSeekStream;
import org.blackdread.camerabinding.jna.EdsdkLibrary.EdsTellStream;
import org.blackdread.camerabinding.jna.EdsdkLibrary.EdsWriteStream;

import java.util.Arrays;
import java.util.List;

/**
 * <i>native declaration : sdk-header\EDSDKTypes.h</i><br>
 * This file was autogenerated by <a href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few opensource projects.</a>.<br>
 * For help, please visit <a href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> , <a href="http://rococoa.dev.java.net/">Rococoa</a>, or <a href="http://jna.dev.java.net/">JNA</a>.
 */
public class EdsIStream extends Structure {
	/** C type : void* */
	public Pointer context;
	/** C type : EdsReadStream* */
	public EdsReadStream read;
	/** C type : EdsWriteStream* */
	public EdsWriteStream write;
	/** C type : EdsSeekStream* */
	public EdsSeekStream seek;
	/** C type : EdsTellStream* */
	public EdsTellStream tell;
	/** C type : EdsGetStreamLength* */
	public EdsGetStreamLength getLength;
	public EdsIStream() {
		super();
	}
    @Override
	protected List<String> getFieldOrder() {
		return Arrays.asList("context", "read", "write", "seek", "tell", "getLength");
	}
	/**
	 * @param context C type : void*<br>
	 * @param read C type : EdsReadStream*<br>
	 * @param write C type : EdsWriteStream*<br>
	 * @param seek C type : EdsSeekStream*<br>
	 * @param tell C type : EdsTellStream*<br>
	 * @param getLength C type : EdsGetStreamLength*
	 */
	public EdsIStream(Pointer context, EdsReadStream read, EdsWriteStream write, EdsSeekStream seek, EdsTellStream tell, EdsGetStreamLength getLength) {
		super();
		this.context = context;
		this.read = read;
		this.write = write;
		this.seek = seek;
		this.tell = tell;
		this.getLength = getLength;
	}
	public EdsIStream(Pointer peer) {
		super(peer);
	}
	public static class ByReference extends EdsIStream implements Structure.ByReference {
		
	}
	public static class ByValue extends EdsIStream implements Structure.ByValue {
		
	}
}
