/*
 * MIT License
 *
 * Copyright (c) 2018-2019 Yoann CAPLAIN
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package org.blackdread.camerabinding.jna;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.ptr.ByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.NativeLongByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.ptr.ShortByReference;
import com.sun.jna.win32.StdCallLibrary;
import org.blackdread.camerabinding.annotation.ImplicitRetain;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;

/**
 * JNA Wrapper for library <b>Edsdk</b><br>
 * This file was autogenerated by <a href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few opensource projects.</a>.<br>
 * For help, please visit <a href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> , <a href="http://rococoa.dev.java.net/">Rococoa</a>, or <a href="http://jna.dev.java.net/">JNA</a>.
 */
public interface EdsdkLibrary extends StdCallLibrary {
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i><br>
     * enum values
     */
    public static interface EdsDataType {
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:136</i>
         */
        public static final int kEdsDataType_Unknown = 0;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:137</i>
         */
        public static final int kEdsDataType_Bool = 1;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:138</i>
         */
        public static final int kEdsDataType_String = 2;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:139</i>
         */
        public static final int kEdsDataType_Int8 = 3;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:140</i>
         */
        public static final int kEdsDataType_UInt8 = 6;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:141</i>
         */
        public static final int kEdsDataType_Int16 = 4;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:142</i>
         */
        public static final int kEdsDataType_UInt16 = 7;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:143</i>
         */
        public static final int kEdsDataType_Int32 = 8;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:144</i>
         */
        public static final int kEdsDataType_UInt32 = 9;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:145</i>
         */
        public static final int kEdsDataType_Int64 = 10;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:146</i>
         */
        public static final int kEdsDataType_UInt64 = 11;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:147</i>
         */
        public static final int kEdsDataType_Float = 12;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:148</i>
         */
        public static final int kEdsDataType_Double = 13;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:149</i>
         */
        public static final int kEdsDataType_ByteBlock = 14;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:150</i>
         */
        public static final int kEdsDataType_Rational = 20;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:151</i>
         */
        public static final int kEdsDataType_Point = 21;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:152</i>
         */
        public static final int kEdsDataType_Rect = 22;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:153</i>
         */
        public static final int kEdsDataType_Time = 23;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:155</i>
         */
        public static final int kEdsDataType_Bool_Array = 30;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:156</i>
         */
        public static final int kEdsDataType_Int8_Array = 31;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:157</i>
         */
        public static final int kEdsDataType_Int16_Array = 32;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:158</i>
         */
        public static final int kEdsDataType_Int32_Array = 33;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:159</i>
         */
        public static final int kEdsDataType_UInt8_Array = 34;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:160</i>
         */
        public static final int kEdsDataType_UInt16_Array = 35;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:161</i>
         */
        public static final int kEdsDataType_UInt32_Array = 36;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:162</i>
         */
        public static final int kEdsDataType_Rational_Array = 37;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:164</i>
         */
        public static final int kEdsDataType_FocusInfo = 101;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:165</i>
         */
        public static final int kEdsDataType_PictureStyleDesc = 102;
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i><br>
     * enum values
     */
    public static interface EdsEvfAf {
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:333</i>
         */
        public static final int kEdsCameraCommand_EvfAf_OFF = 0;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:334</i>
         */
        public static final int kEdsCameraCommand_EvfAf_ON = 1;
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i><br>
     * enum values
     */
    public static interface EdsShutterButton {
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:339</i>
         */
        public static final int kEdsCameraCommand_ShutterButton_OFF = 0x00000000;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:340</i>
         */
        public static final int kEdsCameraCommand_ShutterButton_Halfway = 0x00000001;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:341</i>
         */
        public static final int kEdsCameraCommand_ShutterButton_Completely = 0x00000003;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:342</i>
         */
        public static final int kEdsCameraCommand_ShutterButton_Halfway_NonAF = 0x00010001;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:343</i>
         */
        public static final int kEdsCameraCommand_ShutterButton_Completely_NonAF = 0x00010003;
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i><br>
     * enum values
     */
    public static interface EdsEvfDriveLens {
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:542</i>
         */
        public static final int kEdsEvfDriveLens_Near1 = 0x00000001;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:543</i>
         */
        public static final int kEdsEvfDriveLens_Near2 = 0x00000002;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:544</i>
         */
        public static final int kEdsEvfDriveLens_Near3 = 0x00000003;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:545</i>
         */
        public static final int kEdsEvfDriveLens_Far1 = 0x00008001;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:546</i>
         */
        public static final int kEdsEvfDriveLens_Far2 = 0x00008002;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:547</i>
         */
        public static final int kEdsEvfDriveLens_Far3 = 0x00008003;
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i><br>
     * enum values
     */
    public static interface EdsEvfDepthOfFieldPreview {
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:556</i>
         */
        public static final int kEdsEvfDepthOfFieldPreview_OFF = 0x00000000;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:557</i>
         */
        public static final int kEdsEvfDepthOfFieldPreview_ON = 0x00000001;
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i><br>
     * enum values
     */
    public static interface EdsSeekOrigin {
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:566</i>
         */
        public static final int kEdsSeek_Cur = 0;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:567</i>
         */
        public static final int kEdsSeek_Begin = 1;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:568</i>
         */
        public static final int kEdsSeek_End = 2;
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i><br>
     * enum values
     */
    public static interface EdsAccess {
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:577</i>
         */
        public static final int kEdsAccess_Read = 0;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:578</i>
         */
        public static final int kEdsAccess_Write = 1;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:579</i>
         */
        public static final int kEdsAccess_ReadWrite = 2;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:580</i>
         */
        public static final int kEdsAccess_Error = -1;
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i><br>
     * enum values
     */
    public static interface EdsFileCreateDisposition {
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:589</i>
         */
        public static final int kEdsFileCreateDisposition_CreateNew = 0;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:590</i>
         */
        public static final int kEdsFileCreateDisposition_CreateAlways = 1;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:591</i>
         */
        public static final int kEdsFileCreateDisposition_OpenExisting = 2;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:592</i>
         */
        public static final int kEdsFileCreateDisposition_OpenAlways = 3;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:593</i>
         */
        public static final int kEdsFileCreateDisposition_TruncateExsisting = 4;
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i><br>
     * enum values
     */
    public static interface EdsImageType {
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:604</i>
         */
        public static final int kEdsImageType_Unknown = 0x00000000;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:605</i>
         */
        public static final int kEdsImageType_Jpeg = 0x00000001;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:606</i>
         */
        public static final int kEdsImageType_CRW = 0x00000002;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:607</i>
         */
        public static final int kEdsImageType_RAW = 0x00000004;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:608</i>
         */
        public static final int kEdsImageType_CR2 = 0x00000006;
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i><br>
     * enum values
     */
    public static interface EdsImageSize {
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:617</i>
         */
        public static final int kEdsImageSize_Large = 0;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:618</i>
         */
        public static final int kEdsImageSize_Middle = 1;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:619</i>
         */
        public static final int kEdsImageSize_Small = 2;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:620</i>
         */
        public static final int kEdsImageSize_Middle1 = 5;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:621</i>
         */
        public static final int kEdsImageSize_Middle2 = 6;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:622</i>
         */
        public static final int kEdsImageSize_Small1 = 14;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:623</i>
         */
        public static final int kEdsImageSize_Small2 = 15;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:624</i>
         */
        public static final int kEdsImageSize_Small3 = 16;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:625</i>
         */
        public static final int kEdsImageSize_Unknown = -1;
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i><br>
     * enum values
     */
    public static interface EdsCompressQuality {
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:634</i>
         */
        public static final int kEdsCompressQuality_Normal = 2;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:635</i>
         */
        public static final int kEdsCompressQuality_Fine = 3;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:636</i>
         */
        public static final int kEdsCompressQuality_Lossless = 4;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:637</i>
         */
        public static final int kEdsCompressQuality_SuperFine = 5;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:638</i>
         */
        public static final int kEdsCompressQuality_Unknown = -1;
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i><br>
     * enum values
     */
    public static interface EdsImageQuality {
        /**
         * Jpeg Large<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:649</i>
         */
        public static final int EdsImageQuality_LJ = 0x0010ff0f;
        /**
         * Jpeg Middle1<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:650</i>
         */
        public static final int EdsImageQuality_M1J = 0x0510ff0f;
        /**
         * Jpeg Middle2<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:651</i>
         */
        public static final int EdsImageQuality_M2J = 0x0610ff0f;
        /**
         * Jpeg Small<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:652</i>
         */
        public static final int EdsImageQuality_SJ = 0x0210ff0f;
        /**
         * Jpeg Large Fine<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:653</i>
         */
        public static final int EdsImageQuality_LJF = 0x0013ff0f;
        /**
         * Jpeg Large Normal<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:654</i>
         */
        public static final int EdsImageQuality_LJN = 0x0012ff0f;
        /**
         * Jpeg Middle Fine<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:655</i>
         */
        public static final int EdsImageQuality_MJF = 0x0113ff0f;
        /**
         * Jpeg Middle Normal<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:656</i>
         */
        public static final int EdsImageQuality_MJN = 0x0112ff0f;
        /**
         * Jpeg Small Fine<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:657</i>
         */
        public static final int EdsImageQuality_SJF = 0x0213ff0f;
        /**
         * Jpeg Small Normal<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:658</i>
         */
        public static final int EdsImageQuality_SJN = 0x0212ff0f;
        /**
         * Jpeg Small1 Fine<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:659</i>
         */
        public static final int EdsImageQuality_S1JF = 0x0E13ff0f;
        /**
         * Jpeg Small1 Normal<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:660</i>
         */
        public static final int EdsImageQuality_S1JN = 0x0E12ff0f;
        /**
         * Jpeg Small2<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:661</i>
         */
        public static final int EdsImageQuality_S2JF = 0x0F13ff0f;
        /**
         * Jpeg Small3<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:662</i>
         */
        public static final int EdsImageQuality_S3JF = 0x1013ff0f;
        /**
         * RAW<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:665</i>
         */
        public static final int EdsImageQuality_LR = 0x0064ff0f;
        /**
         * RAW + Jpeg Large Fine<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:666</i>
         */
        public static final int EdsImageQuality_LRLJF = 0x00640013;
        /**
         * RAW + Jpeg Large Normal<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:667</i>
         */
        public static final int EdsImageQuality_LRLJN = 0x00640012;
        /**
         * RAW + Jpeg Middle Fine<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:668</i>
         */
        public static final int EdsImageQuality_LRMJF = 0x00640113;
        /**
         * RAW + Jpeg Middle Normal<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:669</i>
         */
        public static final int EdsImageQuality_LRMJN = 0x00640112;
        /**
         * RAW + Jpeg Small Fine<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:670</i>
         */
        public static final int EdsImageQuality_LRSJF = 0x00640213;
        /**
         * RAW + Jpeg Small Normal<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:671</i>
         */
        public static final int EdsImageQuality_LRSJN = 0x00640212;
        /**
         * RAW + Jpeg Small1 Fine<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:672</i>
         */
        public static final int EdsImageQuality_LRS1JF = 0x00640E13;
        /**
         * RAW + Jpeg Small1 Normal<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:673</i>
         */
        public static final int EdsImageQuality_LRS1JN = 0x00640E12;
        /**
         * RAW + Jpeg Small2<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:674</i>
         */
        public static final int EdsImageQuality_LRS2JF = 0x00640F13;
        /**
         * RAW + Jpeg Small3<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:675</i>
         */
        public static final int EdsImageQuality_LRS3JF = 0x00641013;
        /**
         * RAW + Jpeg Large<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:677</i>
         */
        public static final int EdsImageQuality_LRLJ = 0x00640010;
        /**
         * RAW + Jpeg Middle1<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:678</i>
         */
        public static final int EdsImageQuality_LRM1J = 0x00640510;
        /**
         * RAW + Jpeg Middle2<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:679</i>
         */
        public static final int EdsImageQuality_LRM2J = 0x00640610;
        /**
         * RAW + Jpeg Small<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:680</i>
         */
        public static final int EdsImageQuality_LRSJ = 0x00640210;
        /**
         * MRAW(SRAW1)<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:683</i>
         */
        public static final int EdsImageQuality_MR = 0x0164ff0f;
        /**
         * MRAW(SRAW1) + Jpeg Large Fine<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:684</i>
         */
        public static final int EdsImageQuality_MRLJF = 0x01640013;
        /**
         * MRAW(SRAW1) + Jpeg Large Normal<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:685</i>
         */
        public static final int EdsImageQuality_MRLJN = 0x01640012;
        /**
         * MRAW(SRAW1) + Jpeg Middle Fine<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:686</i>
         */
        public static final int EdsImageQuality_MRMJF = 0x01640113;
        /**
         * MRAW(SRAW1) + Jpeg Middle Normal<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:687</i>
         */
        public static final int EdsImageQuality_MRMJN = 0x01640112;
        /**
         * MRAW(SRAW1) + Jpeg Small Fine<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:688</i>
         */
        public static final int EdsImageQuality_MRSJF = 0x01640213;
        /**
         * MRAW(SRAW1) + Jpeg Small Normal<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:689</i>
         */
        public static final int EdsImageQuality_MRSJN = 0x01640212;
        /**
         * MRAW(SRAW1) + Jpeg Small1 Fine<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:690</i>
         */
        public static final int EdsImageQuality_MRS1JF = 0x01640E13;
        /**
         * MRAW(SRAW1) + Jpeg Small1 Normal<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:691</i>
         */
        public static final int EdsImageQuality_MRS1JN = 0x01640E12;
        /**
         * MRAW(SRAW1) + Jpeg Small2<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:692</i>
         */
        public static final int EdsImageQuality_MRS2JF = 0x01640F13;
        /**
         * MRAW(SRAW1) + Jpeg Small3<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:693</i>
         */
        public static final int EdsImageQuality_MRS3JF = 0x01641013;
        /**
         * MRAW(SRAW1) + Jpeg Large<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:695</i>
         */
        public static final int EdsImageQuality_MRLJ = 0x01640010;
        /**
         * MRAW(SRAW1) + Jpeg Middle1<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:696</i>
         */
        public static final int EdsImageQuality_MRM1J = 0x01640510;
        /**
         * MRAW(SRAW1) + Jpeg Middle2<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:697</i>
         */
        public static final int EdsImageQuality_MRM2J = 0x01640610;
        /**
         * MRAW(SRAW1) + Jpeg Small<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:698</i>
         */
        public static final int EdsImageQuality_MRSJ = 0x01640210;
        /**
         * SRAW(SRAW2)<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:701</i>
         */
        public static final int EdsImageQuality_SR = 0x0264ff0f;
        /**
         * SRAW(SRAW2) + Jpeg Large Fine<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:702</i>
         */
        public static final int EdsImageQuality_SRLJF = 0x02640013;
        /**
         * SRAW(SRAW2) + Jpeg Large Normal<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:703</i>
         */
        public static final int EdsImageQuality_SRLJN = 0x02640012;
        /**
         * SRAW(SRAW2) + Jpeg Middle Fine<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:704</i>
         */
        public static final int EdsImageQuality_SRMJF = 0x02640113;
        /**
         * SRAW(SRAW2) + Jpeg Middle Normal<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:705</i>
         */
        public static final int EdsImageQuality_SRMJN = 0x02640112;
        /**
         * SRAW(SRAW2) + Jpeg Small Fine<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:706</i>
         */
        public static final int EdsImageQuality_SRSJF = 0x02640213;
        /**
         * SRAW(SRAW2) + Jpeg Small Normal<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:707</i>
         */
        public static final int EdsImageQuality_SRSJN = 0x02640212;
        /**
         * SRAW(SRAW2) + Jpeg Small1 Fine<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:708</i>
         */
        public static final int EdsImageQuality_SRS1JF = 0x02640E13;
        /**
         * SRAW(SRAW2) + Jpeg Small1 Normal<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:709</i>
         */
        public static final int EdsImageQuality_SRS1JN = 0x02640E12;
        /**
         * SRAW(SRAW2) + Jpeg Small2<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:710</i>
         */
        public static final int EdsImageQuality_SRS2JF = 0x02640F13;
        /**
         * SRAW(SRAW2) + Jpeg Small3<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:711</i>
         */
        public static final int EdsImageQuality_SRS3JF = 0x02641013;
        /**
         * SRAW(SRAW2) + Jpeg Large<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:713</i>
         */
        public static final int EdsImageQuality_SRLJ = 0x02640010;
        /**
         * SRAW(SRAW2) + Jpeg Middle1<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:714</i>
         */
        public static final int EdsImageQuality_SRM1J = 0x02640510;
        /**
         * SRAW(SRAW2) + Jpeg Middle2<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:715</i>
         */
        public static final int EdsImageQuality_SRM2J = 0x02640610;
        /**
         * SRAW(SRAW2) + Jpeg Small<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:716</i>
         */
        public static final int EdsImageQuality_SRSJ = 0x02640210;
        /**
         * CRAW<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:719</i>
         */
        public static final int EdsImageQuality_CR = 0x0063ff0f;
        /**
         * CRAW + Jpeg Large Fine<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:720</i>
         */
        public static final int EdsImageQuality_CRLJF = 0x00630013;
        /**
         * CRAW + Jpeg Middle Fine<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:721</i>
         */
        public static final int EdsImageQuality_CRMJF = 0x00630113;
        /**
         * CRAW + Jpeg Middle1 Fine<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:722</i>
         */
        public static final int EdsImageQuality_CRM1JF = 0x00630513;
        /**
         * CRAW + Jpeg Middle2 Fine<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:723</i>
         */
        public static final int EdsImageQuality_CRM2JF = 0x00630613;
        /**
         * CRAW + Jpeg Small Fine<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:724</i>
         */
        public static final int EdsImageQuality_CRSJF = 0x00630213;
        /**
         * CRAW + Jpeg Small1 Fine<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:725</i>
         */
        public static final int EdsImageQuality_CRS1JF = 0x00630E13;
        /**
         * CRAW + Jpeg Small2 Fine<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:726</i>
         */
        public static final int EdsImageQuality_CRS2JF = 0x00630F13;
        /**
         * CRAW + Jpeg Small3 Fine<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:727</i>
         */
        public static final int EdsImageQuality_CRS3JF = 0x00631013;
        /**
         * CRAW + Jpeg Large Normal<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:728</i>
         */
        public static final int EdsImageQuality_CRLJN = 0x00630012;
        /**
         * CRAW + Jpeg Middle Normal<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:729</i>
         */
        public static final int EdsImageQuality_CRMJN = 0x00630112;
        /**
         * CRAW + Jpeg Middle1 Normal<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:730</i>
         */
        public static final int EdsImageQuality_CRM1JN = 0x00630512;
        /**
         * CRAW + Jpeg Middle2 Normal<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:731</i>
         */
        public static final int EdsImageQuality_CRM2JN = 0x00630612;
        /**
         * CRAW + Jpeg Small Normal<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:732</i>
         */
        public static final int EdsImageQuality_CRSJN = 0x00630212;
        /**
         * CRAW + Jpeg Small1 Normal<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:733</i>
         */
        public static final int EdsImageQuality_CRS1JN = 0x00630E12;
        /**
         * CRAW + Jpeg Large<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:735</i>
         */
        public static final int EdsImageQuality_CRLJ = 0x00630010;
        /**
         * CRAW + Jpeg Middle1<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:736</i>
         */
        public static final int EdsImageQuality_CRM1J = 0x00630510;
        /**
         * CRAW + Jpeg Middle2<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:737</i>
         */
        public static final int EdsImageQuality_CRM2J = 0x00630610;
        /**
         * CRAW + Jpeg Small<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:738</i>
         */
        public static final int EdsImageQuality_CRSJ = 0x00630210;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:740</i>
         */
        public static final int EdsImageQuality_Unknown = -1;
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i><br>
     * enum values
     */
    public static interface EdsImageQualityForLegacy {
        /**
         * Jpeg Large<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:745</i>
         */
        public static final int kEdsImageQualityForLegacy_LJ = 0x001f000f;
        /**
         * Jpeg Middle1<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:746</i>
         */
        public static final int kEdsImageQualityForLegacy_M1J = 0x051f000f;
        /**
         * Jpeg Middle2<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:747</i>
         */
        public static final int kEdsImageQualityForLegacy_M2J = 0x061f000f;
        /**
         * Jpeg Small<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:748</i>
         */
        public static final int kEdsImageQualityForLegacy_SJ = 0x021f000f;
        /**
         * Jpeg Large Fine<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:749</i>
         */
        public static final int kEdsImageQualityForLegacy_LJF = 0x00130000;
        /**
         * Jpeg Large Normal<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:750</i>
         */
        public static final int kEdsImageQualityForLegacy_LJN = 0x00120000;
        /**
         * Jpeg Middle Fine<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:751</i>
         */
        public static final int kEdsImageQualityForLegacy_MJF = 0x01130000;
        /**
         * Jpeg Middle Normal<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:752</i>
         */
        public static final int kEdsImageQualityForLegacy_MJN = 0x01120000;
        /**
         * Jpeg Small Fine<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:753</i>
         */
        public static final int kEdsImageQualityForLegacy_SJF = 0x02130000;
        /**
         * Jpeg Small Normal<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:754</i>
         */
        public static final int kEdsImageQualityForLegacy_SJN = 0x02120000;
        /**
         * RAW<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:756</i>
         */
        public static final int kEdsImageQualityForLegacy_LR = 0x00240000;
        /**
         * RAW + Jpeg Large Fine<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:757</i>
         */
        public static final int kEdsImageQualityForLegacy_LRLJF = 0x00240013;
        /**
         * RAW + Jpeg Large Normal<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:758</i>
         */
        public static final int kEdsImageQualityForLegacy_LRLJN = 0x00240012;
        /**
         * RAW + Jpeg Middle Fine<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:759</i>
         */
        public static final int kEdsImageQualityForLegacy_LRMJF = 0x00240113;
        /**
         * RAW + Jpeg Middle Normal<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:760</i>
         */
        public static final int kEdsImageQualityForLegacy_LRMJN = 0x00240112;
        /**
         * RAW + Jpeg Small Fine<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:761</i>
         */
        public static final int kEdsImageQualityForLegacy_LRSJF = 0x00240213;
        /**
         * RAW + Jpeg Small Normal<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:762</i>
         */
        public static final int kEdsImageQualityForLegacy_LRSJN = 0x00240212;
        /**
         * RAW<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:764</i>
         */
        public static final int kEdsImageQualityForLegacy_LR2 = 0x002f000f;
        /**
         * RAW + Jpeg Large<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:765</i>
         */
        public static final int kEdsImageQualityForLegacy_LR2LJ = 0x002f001f;
        /**
         * RAW + Jpeg Middle1<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:766</i>
         */
        public static final int kEdsImageQualityForLegacy_LR2M1J = 0x002f051f;
        /**
         * RAW + Jpeg Middle2<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:767</i>
         */
        public static final int kEdsImageQualityForLegacy_LR2M2J = 0x002f061f;
        /**
         * RAW + Jpeg Small<br>
         * <i>native declaration : sdk-header\EDSDKTypes.h:768</i>
         */
        public static final int kEdsImageQualityForLegacy_LR2SJ = 0x002f021f;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:770</i>
         */
        public static final int kEdsImageQualityForLegacy_Unknown = -1;
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i><br>
     * enum values
     */
    public static interface EdsImageSource {
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:779</i>
         */
        public static final int kEdsImageSrc_FullView = 0;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:780</i>
         */
        public static final int kEdsImageSrc_Thumbnail = 1;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:781</i>
         */
        public static final int kEdsImageSrc_Preview = 2;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:782</i>
         */
        public static final int kEdsImageSrc_RAWThumbnail = 3;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:783</i>
         */
        public static final int kEdsImageSrc_RAWFullView = 4;
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i><br>
     * enum values
     */
    public static interface EdsTargetImageType {
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:793</i>
         */
        public static final int kEdsTargetImageType_Unknown = 0x00000000;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:794</i>
         */
        public static final int kEdsTargetImageType_Jpeg = 0x00000001;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:795</i>
         */
        public static final int kEdsTargetImageType_TIFF = 0x00000007;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:796</i>
         */
        public static final int kEdsTargetImageType_TIFF16 = 0x00000008;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:797</i>
         */
        public static final int kEdsTargetImageType_RGB = 0x00000009;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:798</i>
         */
        public static final int kEdsTargetImageType_RGB16 = 0x0000000A;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:799</i>
         */
        public static final int kEdsTargetImageType_DIB = 0x0000000B;
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i><br>
     * enum values
     */
    public static interface EdsProgressOption {
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:808</i>
         */
        public static final int kEdsProgressOption_NoReport = 0;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:809</i>
         */
        public static final int kEdsProgressOption_Done = 1;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:810</i>
         */
        public static final int kEdsProgressOption_Periodically = 2;
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i><br>
     * enum values
     */
    public static interface EdsFileAttributes {
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:820</i>
         */
        public static final int kEdsFileAttribute_Normal = 0x00000000;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:821</i>
         */
        public static final int kEdsFileAttribute_ReadOnly = 0x00000001;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:822</i>
         */
        public static final int kEdsFileAttribute_Hidden = 0x00000002;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:823</i>
         */
        public static final int kEdsFileAttribute_System = 0x00000004;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:824</i>
         */
        public static final int kEdsFileAttribute_Archive = 0x00000020;
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i><br>
     * enum values
     */
    public static interface EdsBatteryLevel2 {
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:834</i>
         */
        public static final int kEdsBatteryLevel2_Empty = 0;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:835</i>
         */
        public static final int kEdsBatteryLevel2_Low = 9;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:836</i>
         */
        public static final int kEdsBatteryLevel2_Half = 49;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:837</i>
         */
        public static final int kEdsBatteryLevel2_Normal = 80;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:838</i>
         */
        public static final int kEdsBatteryLevel2_Hi = 69;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:839</i>
         */
        public static final int kEdsBatteryLevel2_Quarter = 19;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:840</i>
         */
        public static final int kEdsBatteryLevel2_Error = 0;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:841</i>
         */
        public static final int kEdsBatteryLevel2_BCLevel = 0;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:842</i>
         */
        public static final int kEdsBatteryLevel2_AC = -1;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:843</i>
         */
        public static final int kEdsBatteryLevel2_Unknown = 0xFFFFFFFE;
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i><br>
     * enum values
     */
    public static interface EdsSaveTo {
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:851</i>
         */
        public static final int kEdsSaveTo_Camera = 1;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:852</i>
         */
        public static final int kEdsSaveTo_Host = 2;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:853</i>
         */
        public static final int kEdsSaveTo_Both = (int) EdsSaveTo.kEdsSaveTo_Camera | (int) EdsSaveTo.kEdsSaveTo_Host;
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i><br>
     * enum values
     */
    public static interface EdsStorageType {
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:862</i>
         */
        public static final int kEdsStorageType_Non = 0;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:863</i>
         */
        public static final int kEdsStorageType_CF = 1;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:864</i>
         */
        public static final int kEdsStorageType_SD = 2;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:865</i>
         */
        public static final int kEdsStorageType_HD = 4;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:866</i>
         */
        public static final int kEdsStorageType_CFast = 5;
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i><br>
     * enum values
     */
    public static interface EdsWhiteBalance {
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:875</i>
         */
        public static final int kEdsWhiteBalance_Auto = 0;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:876</i>
         */
        public static final int kEdsWhiteBalance_Daylight = 1;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:877</i>
         */
        public static final int kEdsWhiteBalance_Cloudy = 2;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:878</i>
         */
        public static final int kEdsWhiteBalance_Tangsten = 3;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:879</i>
         */
        public static final int kEdsWhiteBalance_Fluorescent = 4;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:880</i>
         */
        public static final int kEdsWhiteBalance_Strobe = 5;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:881</i>
         */
        public static final int kEdsWhiteBalance_WhitePaper = 6;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:882</i>
         */
        public static final int kEdsWhiteBalance_Shade = 8;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:883</i>
         */
        public static final int kEdsWhiteBalance_ColorTemp = 9;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:884</i>
         */
        public static final int kEdsWhiteBalance_PCSet1 = 10;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:885</i>
         */
        public static final int kEdsWhiteBalance_PCSet2 = 11;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:886</i>
         */
        public static final int kEdsWhiteBalance_PCSet3 = 12;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:887</i>
         */
        public static final int kEdsWhiteBalance_WhitePaper2 = 15;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:888</i>
         */
        public static final int kEdsWhiteBalance_WhitePaper3 = 16;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:889</i>
         */
        public static final int kEdsWhiteBalance_WhitePaper4 = 18;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:890</i>
         */
        public static final int kEdsWhiteBalance_WhitePaper5 = 19;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:891</i>
         */
        public static final int kEdsWhiteBalance_PCSet4 = 20;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:892</i>
         */
        public static final int kEdsWhiteBalance_PCSet5 = 21;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:893</i>
         */
        public static final int kEdsWhiteBalance_AwbWhite = 23;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:894</i>
         */
        public static final int kEdsWhiteBalance_Click = -1;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:895</i>
         */
        public static final int kEdsWhiteBalance_Pasted = -2;
        /**
         * @deprecated  got it from my camera... do not use. Put it here for now to let tests pass
         */
        public static final int kEdsWhiteBalance_UnknownSelf = 32768;
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i><br>
     * enum values
     */
    public static interface EdsPhotoEffect {
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:904</i>
         */
        public static final int kEdsPhotoEffect_Off = 0;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:905</i>
         */
        public static final int kEdsPhotoEffect_Monochrome = 5;
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i><br>
     * enum values
     */
    public static interface EdsColorMatrix {
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:914</i>
         */
        public static final int kEdsColorMatrix_Custom = 0;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:915</i>
         */
        public static final int kEdsColorMatrix_1 = 1;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:916</i>
         */
        public static final int kEdsColorMatrix_2 = 2;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:917</i>
         */
        public static final int kEdsColorMatrix_3 = 3;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:918</i>
         */
        public static final int kEdsColorMatrix_4 = 4;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:919</i>
         */
        public static final int kEdsColorMatrix_5 = 5;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:920</i>
         */
        public static final int kEdsColorMatrix_6 = 6;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:921</i>
         */
        public static final int kEdsColorMatrix_7 = 7;
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i><br>
     * enum values
     */
    public static interface EdsFilterEffect {
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:930</i>
         */
        public static final int kEdsFilterEffect_None = 0;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:931</i>
         */
        public static final int kEdsFilterEffect_Yellow = 1;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:932</i>
         */
        public static final int kEdsFilterEffect_Orange = 2;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:933</i>
         */
        public static final int kEdsFilterEffect_Red = 3;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:934</i>
         */
        public static final int kEdsFilterEffect_Green = 4;
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i><br>
     * enum values
     */
    public static interface EdsTonigEffect {
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:943</i>
         */
        public static final int kEdsTonigEffect_None = 0;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:944</i>
         */
        public static final int kEdsTonigEffect_Sepia = 1;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:945</i>
         */
        public static final int kEdsTonigEffect_Blue = 2;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:946</i>
         */
        public static final int kEdsTonigEffect_Purple = 3;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:947</i>
         */
        public static final int kEdsTonigEffect_Green = 4;
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i><br>
     * enum values
     */
    public static interface EdsColorSpace {
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:956</i>
         */
        public static final int kEdsColorSpace_sRGB = 1;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:957</i>
         */
        public static final int kEdsColorSpace_AdobeRGB = 2;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:958</i>
         */
        public static final int kEdsColorSpace_Unknown = -1;
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i><br>
     * enum values
     */
    public static interface EdsPictureStyle {
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:967</i>
         */
        public static final int kEdsPictureStyle_Standard = 0x0081;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:968</i>
         */
        public static final int kEdsPictureStyle_Portrait = 0x0082;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:969</i>
         */
        public static final int kEdsPictureStyle_Landscape = 0x0083;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:970</i>
         */
        public static final int kEdsPictureStyle_Neutral = 0x0084;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:971</i>
         */
        public static final int kEdsPictureStyle_Faithful = 0x0085;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:972</i>
         */
        public static final int kEdsPictureStyle_Monochrome = 0x0086;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:973</i>
         */
        public static final int kEdsPictureStyle_Auto = 0x0087;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:974</i>
         */
        public static final int kEdsPictureStyle_FineDetail = 0x0088;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:975</i>
         */
        public static final int kEdsPictureStyle_User1 = 0x0021;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:976</i>
         */
        public static final int kEdsPictureStyle_User2 = 0x0022;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:977</i>
         */
        public static final int kEdsPictureStyle_User3 = 0x0023;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:978</i>
         */
        public static final int kEdsPictureStyle_PC1 = 0x0041;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:979</i>
         */
        public static final int kEdsPictureStyle_PC2 = 0x0042;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:980</i>
         */
        public static final int kEdsPictureStyle_PC3 = 0x0043;
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i><br>
     * enum values
     */
    public static interface EdsTransferOption {
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:989</i>
         */
        public static final int kEdsTransferOption_ByDirectTransfer = 1;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:990</i>
         */
        public static final int kEdsTransferOption_ByRelease = 2;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:991</i>
         */
        public static final int kEdsTransferOption_ToDesktop = 0x00000100;
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i><br>
     * enum values
     */
    public static interface EdsAEMode {
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1000</i>
         */
        public static final int kEdsAEMode_Program = 0;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1001</i>
         */
        public static final int kEdsAEMode_Tv = 1;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1002</i>
         */
        public static final int kEdsAEMode_Av = 2;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1003</i>
         */
        public static final int kEdsAEMode_Manual = 3;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1004</i>
         */
        public static final int kEdsAEMode_Bulb = 4;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1005</i>
         */
        public static final int kEdsAEMode_A_DEP = 5;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1006</i>
         */
        public static final int kEdsAEMode_DEP = 6;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1007</i>
         */
        public static final int kEdsAEMode_Custom = 7;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1008</i>
         */
        public static final int kEdsAEMode_Lock = 8;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1009</i>
         */
        public static final int kEdsAEMode_Green = 9;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1010</i>
         */
        public static final int kEdsAEMode_NightPortrait = 10;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1011</i>
         */
        public static final int kEdsAEMode_Sports = 11;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1012</i>
         */
        public static final int kEdsAEMode_Portrait = 12;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1013</i>
         */
        public static final int kEdsAEMode_Landscape = 13;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1014</i>
         */
        public static final int kEdsAEMode_Closeup = 14;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1015</i>
         */
        public static final int kEdsAEMode_FlashOff = 15;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1016</i>
         */
        public static final int kEdsAEMode_CreativeAuto = 19;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1017</i>
         */
        public static final int kEdsAEMode_Movie = 20;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1018</i>
         */
        public static final int kEdsAEMode_PhotoInMovie = 21;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1019</i>
         */
        public static final int kEdsAEMode_SceneIntelligentAuto = 22;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1020</i>
         */
        public static final int kEdsAEMode_SCN = 25;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1021</i>
         */
        public static final int kEdsAEMode_NightScenes = 23;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1022</i>
         */
        public static final int kEdsAEMode_BacklitScenes = 24;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1023</i>
         */
        public static final int kEdsAEMode_Children = 26;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1024</i>
         */
        public static final int kEdsAEMode_Food = 27;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1025</i>
         */
        public static final int kEdsAEMode_CandlelightPortraits = 28;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1026</i>
         */
        public static final int kEdsAEMode_CreativeFilter = 29;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1027</i>
         */
        public static final int kEdsAEMode_RoughMonoChrome = 30;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1028</i>
         */
        public static final int kEdsAEMode_SoftFocus = 31;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1029</i>
         */
        public static final int kEdsAEMode_ToyCamera = 32;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1030</i>
         */
        public static final int kEdsAEMode_Fisheye = 33;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1031</i>
         */
        public static final int kEdsAEMode_WaterColor = 34;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1032</i>
         */
        public static final int kEdsAEMode_Miniature = 35;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1033</i>
         */
        public static final int kEdsAEMode_Hdr_Standard = 36;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1034</i>
         */
        public static final int kEdsAEMode_Hdr_Vivid = 37;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1035</i>
         */
        public static final int kEdsAEMode_Hdr_Bold = 38;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1036</i>
         */
        public static final int kEdsAEMode_Hdr_Embossed = 39;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1037</i>
         */
        public static final int kEdsAEMode_Movie_Fantasy = 40;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1038</i>
         */
        public static final int kEdsAEMode_Movie_Old = 41;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1039</i>
         */
        public static final int kEdsAEMode_Movie_Memory = 42;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1040</i>
         */
        public static final int kEdsAEMode_Movie_DirectMono = 43;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1041</i>
         */
        public static final int kEdsAEMode_Movie_Mini = 44;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1042</i>
         */
        public static final int kEdsAEMode_PanningAssist = 45;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1043</i>
         */
        public static final int kEdsAEMode_GroupPhoto = 46;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1044</i>
         */
        public static final int kEdsAEMode_Myself = 50;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1045</i>
         */
        public static final int kEdsAEMode_SmoothSkin = 52;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1046</i>
         */
        public static final int kEdsAEMode_Flexible = 55;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1047</i>
         */
        public static final int kEdsAEMode_Unknown = -1;
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i><br>
     * enum values
     */
    public static interface EdsBracket {
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1056</i>
         */
        public static final int kEdsBracket_AEB = 0x01;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1057</i>
         */
        public static final int kEdsBracket_ISOB = 0x02;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1058</i>
         */
        public static final int kEdsBracket_WBB = 0x04;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1059</i>
         */
        public static final int kEdsBracket_FEB = 0x08;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1060</i>
         */
        public static final int kEdsBracket_Unknown = -1;
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i><br>
     * enum values
     */
    public static interface EdsEvfOutputDevice {
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1069</i>
         */
        public static final int kEdsEvfOutputDevice_TFT = 1;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1070</i>
         */
        public static final int kEdsEvfOutputDevice_PC = 2;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1071</i>
         */
        public static final int kEdsEvfOutputDevice_MOBILE = 4;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1072</i>
         */
        public static final int kEdsEvfOutputDevice_MOBILE2 = 8;
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i><br>
     * enum values
     */
    public static interface EdsEvfZoom {
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1080</i>
         */
        public static final int kEdsEvfZoom_Fit = 1;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1081</i>
         */
        public static final int kEdsEvfZoom_x5 = 5;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1082</i>
         */
        public static final int kEdsEvfZoom_x10 = 10;
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i><br>
     * enum values
     */
    public static interface EdsEvfAFMode {
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1090</i>
         */
        public static final int Evf_AFMode_Quick = 0;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1091</i>
         */
        public static final int Evf_AFMode_Live = 1;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1092</i>
         */
        public static final int Evf_AFMode_LiveFace = 2;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1093</i>
         */
        public static final int Evf_AFMode_LiveMulti = 3;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1094</i>
         */
        public static final int Evf_AFMode_LiveZone = 4;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1095</i>
         */
        public static final int Evf_AFMode_LiveSingleExpandCross = 5;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1096</i>
         */
        public static final int Evf_AFMode_LiveSingleExpandSurround = 6;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1097</i>
         */
        public static final int Evf_AFMode_LiveZoneLargeH = 7;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1098</i>
         */
        public static final int Evf_AFMode_LiveZoneLargeV = 8;
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i><br>
     * enum values
     */
    public static interface EdsStroboMode {
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1100</i>
         */
        public static final int kEdsStroboModeInternal = 0;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1101</i>
         */
        public static final int kEdsStroboModeExternalETTL = 1;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1102</i>
         */
        public static final int kEdsStroboModeExternalATTL = 2;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1103</i>
         */
        public static final int kEdsStroboModeExternalTTL = 3;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1104</i>
         */
        public static final int kEdsStroboModeExternalAuto = 4;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1105</i>
         */
        public static final int kEdsStroboModeExternalManual = 5;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1106</i>
         */
        public static final int kEdsStroboModeManual = 6;
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i><br>
     * enum values
     */
    public static interface EdsETTL2Mode {
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1114</i>
         */
        public static final int kEdsETTL2ModeEvaluative = 0;
        /**
         * <i>native declaration : sdk-header\EDSDKTypes.h:1115</i>
         */
        public static final int kEdsETTL2ModeAverage = 1;
    }

    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ISSPECIFIC_MASK = 0x80000000;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_COMPONENTID_MASK = 0x7F000000;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_RESERVED_MASK = 0x00FF0000;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERRORID_MASK = 0x0000FFFF;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_CMP_ID_CLIENT_COMPONENTID = 0x01000000;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_CMP_ID_LLSDK_COMPONENTID = 0x02000000;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_CMP_ID_HLSDK_COMPONENTID = 0x03000000;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_OK = 0x00000000;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_UNIMPLEMENTED = 0x00000001;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_INTERNAL_ERROR = 0x00000002;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_MEM_ALLOC_FAILED = 0x00000003;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_MEM_FREE_FAILED = 0x00000004;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_OPERATION_CANCELLED = 0x00000005;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_INCOMPATIBLE_VERSION = 0x00000006;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_NOT_SUPPORTED = 0x00000007;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_UNEXPECTED_EXCEPTION = 0x00000008;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_PROTECTION_VIOLATION = 0x00000009;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_MISSING_SUBCOMPONENT = 0x0000000A;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_SELECTION_UNAVAILABLE = 0x0000000B;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_FILE_IO_ERROR = 0x00000020;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_FILE_TOO_MANY_OPEN = 0x00000021;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_FILE_NOT_FOUND = 0x00000022;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_FILE_OPEN_ERROR = 0x00000023;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_FILE_CLOSE_ERROR = 0x00000024;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_FILE_SEEK_ERROR = 0x00000025;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_FILE_TELL_ERROR = 0x00000026;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_FILE_READ_ERROR = 0x00000027;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_FILE_WRITE_ERROR = 0x00000028;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_FILE_PERMISSION_ERROR = 0x00000029;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_FILE_DISK_FULL_ERROR = 0x0000002A;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_FILE_ALREADY_EXISTS = 0x0000002B;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_FILE_FORMAT_UNRECOGNIZED = 0x0000002C;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_FILE_DATA_CORRUPT = 0x0000002D;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_FILE_NAMING_NA = 0x0000002E;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_DIR_NOT_FOUND = 0x00000040;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_DIR_IO_ERROR = 0x00000041;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_DIR_ENTRY_NOT_FOUND = 0x00000042;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_DIR_ENTRY_EXISTS = 0x00000043;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_DIR_NOT_EMPTY = 0x00000044;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_PROPERTIES_UNAVAILABLE = 0x00000050;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_PROPERTIES_MISMATCH = 0x00000051;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_PROPERTIES_NOT_LOADED = 0x00000053;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_INVALID_PARAMETER = 0x00000060;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_INVALID_HANDLE = 0x00000061;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_INVALID_POINTER = 0x00000062;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_INVALID_INDEX = 0x00000063;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_INVALID_LENGTH = 0x00000064;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_INVALID_FN_POINTER = 0x00000065;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_INVALID_SORT_FN = 0x00000066;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_DEVICE_NOT_FOUND = 0x00000080;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_DEVICE_BUSY = 0x00000081;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_DEVICE_INVALID = 0x00000082;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_DEVICE_EMERGENCY = 0x00000083;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_DEVICE_MEMORY_FULL = 0x00000084;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_DEVICE_INTERNAL_ERROR = 0x00000085;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_DEVICE_INVALID_PARAMETER = 0x00000086;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_DEVICE_NO_DISK = 0x00000087;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_DEVICE_DISK_ERROR = 0x00000088;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_DEVICE_CF_GATE_CHANGED = 0x00000089;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_DEVICE_DIAL_CHANGED = 0x0000008A;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_DEVICE_NOT_INSTALLED = 0x0000008B;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_DEVICE_STAY_AWAKE = 0x0000008C;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_DEVICE_NOT_RELEASED = 0x0000008D;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_STREAM_IO_ERROR = 0x000000A0;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_STREAM_NOT_OPEN = 0x000000A1;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_STREAM_ALREADY_OPEN = 0x000000A2;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_STREAM_OPEN_ERROR = 0x000000A3;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_STREAM_CLOSE_ERROR = 0x000000A4;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_STREAM_SEEK_ERROR = 0x000000A5;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_STREAM_TELL_ERROR = 0x000000A6;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_STREAM_READ_ERROR = 0x000000A7;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_STREAM_WRITE_ERROR = 0x000000A8;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_STREAM_PERMISSION_ERROR = 0x000000A9;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_STREAM_COULDNT_BEGIN_THREAD = 0x000000AA;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_STREAM_BAD_OPTIONS = 0x000000AB;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_STREAM_END_OF_STREAM = 0x000000AC;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_COMM_PORT_IS_IN_USE = 0x000000C0;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_COMM_DISCONNECTED = 0x000000C1;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_COMM_DEVICE_INCOMPATIBLE = 0x000000C2;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_COMM_BUFFER_FULL = 0x000000C3;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_COMM_USB_BUS_ERR = 0x000000C4;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_USB_DEVICE_LOCK_ERROR = 0x000000D0;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_USB_DEVICE_UNLOCK_ERROR = 0x000000D1;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_STI_UNKNOWN_ERROR = 0x000000E0;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_STI_INTERNAL_ERROR = 0x000000E1;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_STI_DEVICE_CREATE_ERROR = 0x000000E2;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_STI_DEVICE_RELEASE_ERROR = 0x000000E3;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_DEVICE_NOT_LAUNCHED = 0x000000E4;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_ENUM_NA = 0x000000F0;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_INVALID_FN_CALL = 0x000000F1;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_HANDLE_NOT_FOUND = 0x000000F2;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_INVALID_ID = 0x000000F3;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_WAIT_TIMEOUT_ERROR = 0x000000F4;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_SESSION_NOT_OPEN = 0x00002003;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_INVALID_TRANSACTIONID = 0x00002004;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_INCOMPLETE_TRANSFER = 0x00002007;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_INVALID_STRAGEID = 0x00002008;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_DEVICEPROP_NOT_SUPPORTED = 0x0000200A;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_INVALID_OBJECTFORMATCODE = 0x0000200B;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_SELF_TEST_FAILED = 0x00002011;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_PARTIAL_DELETION = 0x00002012;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_SPECIFICATION_BY_FORMAT_UNSUPPORTED = 0x00002014;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_NO_VALID_OBJECTINFO = 0x00002015;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_INVALID_CODE_FORMAT = 0x00002016;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_UNKNOWN_VENDOR_CODE = 0x00002017;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_CAPTURE_ALREADY_TERMINATED = 0x00002018;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_PTP_DEVICE_BUSY = 0x00002019;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_INVALID_PARENTOBJECT = 0x0000201A;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_INVALID_DEVICEPROP_FORMAT = 0x0000201B;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_INVALID_DEVICEPROP_VALUE = 0x0000201C;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_SESSION_ALREADY_OPEN = 0x0000201E;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_TRANSACTION_CANCELLED = 0x0000201F;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_SPECIFICATION_OF_DESTINATION_UNSUPPORTED = 0x00002020;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_NOT_CAMERA_SUPPORT_SDK_VERSION = 0x00002021;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_UNKNOWN_COMMAND = 0x0000A001;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_OPERATION_REFUSED = 0x0000A005;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_LENS_COVER_CLOSE = 0x0000A006;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_LOW_BATTERY = 0x0000A101;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_OBJECT_NOTREADY = 0x0000A102;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_CANNOT_MAKE_OBJECT = 0x0000A104;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_MEMORYSTATUS_NOTREADY = 0x0000A106;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_TAKE_PICTURE_AF_NG = 0x00008D01;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_TAKE_PICTURE_RESERVED = 0x00008D02;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_TAKE_PICTURE_MIRROR_UP_NG = 0x00008D03;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_TAKE_PICTURE_SENSOR_CLEANING_NG = 0x00008D04;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_TAKE_PICTURE_SILENCE_NG = 0x00008D05;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_TAKE_PICTURE_NO_CARD_NG = 0x00008D06;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_TAKE_PICTURE_CARD_NG = 0x00008D07;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_TAKE_PICTURE_CARD_PROTECT_NG = 0x00008D08;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_TAKE_PICTURE_MOVIE_CROP_NG = 0x00008D09;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_TAKE_PICTURE_STROBO_CHARGE_NG = 0x00008D0A;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_TAKE_PICTURE_NO_LENS_NG = 0x00008D0B;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_TAKE_PICTURE_SPECIAL_MOVIE_MODE_NG = 0x00008D0C;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_TAKE_PICTURE_LV_REL_PROHIBIT_MODE_NG = 0x00008D0D;
    /**
     * <i>native declaration : sdk-header\EDSDKErrors.h</i>
     */
    public static final int EDS_ERR_LAST_GENERIC_ERROR_PLUS_ONE = 0x000000F5;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int EDS_MAX_NAME = 256;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int EDS_TRANSFER_BLOCK_SIZE = 512;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int NULL = 0;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int FALSE = 0;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int TRUE = 1;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_Unknown = 0x0000ffff;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_ProductName = 0x00000002;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_OwnerName = 0x00000004;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_MakerName = 0x00000005;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_DateTime = 0x00000006;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_FirmwareVersion = 0x00000007;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_BatteryLevel = 0x00000008;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_CFn = 0x00000009;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_SaveTo = 0x0000000b;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_CurrentStorage = 0x0000000c;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_CurrentFolder = 0x0000000d;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_MyMenu = 0x0000000e;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_BatteryQuality = 0x00000010;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_BodyIDEx = 0x00000015;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_HDDirectoryStructure = 0x00000020;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_ImageQuality = 0x00000100;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_JpegQuality = 0x00000101;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_Orientation = 0x00000102;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_ICCProfile = 0x00000103;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_FocusInfo = 0x00000104;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_DigitalExposure = 0x00000105;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_WhiteBalance = 0x00000106;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_ColorTemperature = 0x00000107;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_WhiteBalanceShift = 0x00000108;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_Contrast = 0x00000109;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_ColorSaturation = 0x0000010a;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_ColorTone = 0x0000010b;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_Sharpness = 0x0000010c;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_ColorSpace = 0x0000010d;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_ToneCurve = 0x0000010e;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_PhotoEffect = 0x0000010f;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_FilterEffect = 0x00000110;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_ToningEffect = 0x00000111;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_ParameterSet = 0x00000112;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_ColorMatrix = 0x00000113;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_PictureStyle = 0x00000114;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_PictureStyleDesc = 0x00000115;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_PictureStyleCaption = 0x00000200;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_Linear = 0x00000300;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_ClickWBPoint = 0x00000301;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_WBCoeffs = 0x00000302;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_GPSVersionID = 0x00000800;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_GPSLatitudeRef = 0x00000801;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_GPSLatitude = 0x00000802;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_GPSLongitudeRef = 0x00000803;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_GPSLongitude = 0x00000804;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_GPSAltitudeRef = 0x00000805;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_GPSAltitude = 0x00000806;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_GPSTimeStamp = 0x00000807;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_GPSSatellites = 0x00000808;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_GPSStatus = 0x00000809;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_GPSMapDatum = 0x00000812;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_GPSDateStamp = 0x0000081D;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_AtCapture_Flag = 0x80000000;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_AEMode = 0x00000400;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_DriveMode = 0x00000401;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_ISOSpeed = 0x00000402;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_MeteringMode = 0x00000403;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_AFMode = 0x00000404;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_Av = 0x00000405;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_Tv = 0x00000406;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_ExposureCompensation = 0x00000407;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_FlashCompensation = 0x00000408;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_FocalLength = 0x00000409;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_AvailableShots = 0x0000040a;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_Bracket = 0x0000040b;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_WhiteBalanceBracket = 0x0000040c;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_LensName = 0x0000040d;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_AEBracket = 0x0000040e;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_FEBracket = 0x0000040f;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_ISOBracket = 0x00000410;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_NoiseReduction = 0x00000411;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_FlashOn = 0x00000412;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_RedEye = 0x00000413;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_FlashMode = 0x00000414;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_LensStatus = 0x00000416;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_Artist = 0x00000418;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_Copyright = 0x00000419;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_DepthOfField = 0x0000041b;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_EFCompensation = 0x0000041e;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_AEModeSelect = 0x00000436;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_Evf_OutputDevice = 0x00000500;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_Evf_Mode = 0x00000501;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_Evf_WhiteBalance = 0x00000502;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_Evf_ColorTemperature = 0x00000503;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_Evf_DepthOfFieldPreview = 0x00000504;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_Evf_Zoom = 0x00000507;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_Evf_ZoomPosition = 0x00000508;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_Evf_FocusAid = 0x00000509;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_Evf_Histogram = 0x0000050A;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_Evf_ImagePosition = 0x0000050B;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_Evf_HistogramStatus = 0x0000050C;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_Evf_AFMode = 0x0000050E;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_Record = 0x00000510;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_Evf_HistogramY = 0x00000515;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_Evf_HistogramR = 0x00000516;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_Evf_HistogramG = 0x00000517;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_Evf_HistogramB = 0x00000518;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_Evf_CoordinateSystem = 0x00000540;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_Evf_ZoomRect = 0x00000541;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropID_Evf_ImageClipRect = 0x00000545;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsCameraCommand_TakePicture = 0x00000000;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsCameraCommand_ExtendShutDownTimer = 0x00000001;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsCameraCommand_BulbStart = 0x00000002;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsCameraCommand_BulbEnd = 0x00000003;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsCameraCommand_DoEvfAf = 0x00000102;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsCameraCommand_DriveLensEvf = 0x00000103;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsCameraCommand_DoClickWBEvf = 0x00000104;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsCameraCommand_PressShutterButton = 0x00000004;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsCameraStatusCommand_UILock = 0x00000000;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsCameraStatusCommand_UIUnLock = 0x00000001;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsCameraStatusCommand_EnterDirectTransfer = 0x00000002;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsCameraStatusCommand_ExitDirectTransfer = 0x00000003;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropertyEvent_All = 0x00000100;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropertyEvent_PropertyChanged = 0x00000101;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsPropertyEvent_PropertyDescChanged = 0x00000102;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsObjectEvent_All = 0x00000200;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsObjectEvent_VolumeInfoChanged = 0x00000201;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsObjectEvent_VolumeUpdateItems = 0x00000202;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsObjectEvent_FolderUpdateItems = 0x00000203;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsObjectEvent_DirItemCreated = 0x00000204;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsObjectEvent_DirItemRemoved = 0x00000205;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsObjectEvent_DirItemInfoChanged = 0x00000206;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsObjectEvent_DirItemContentChanged = 0x00000207;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsObjectEvent_DirItemRequestTransfer = 0x00000208;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsObjectEvent_DirItemRequestTransferDT = 0x00000209;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsObjectEvent_DirItemCancelTransferDT = 0x0000020a;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsObjectEvent_VolumeAdded = 0x0000020c;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsObjectEvent_VolumeRemoved = 0x0000020d;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsStateEvent_All = 0x00000300;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsStateEvent_Shutdown = 0x00000301;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsStateEvent_JobStatusChanged = 0x00000302;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsStateEvent_WillSoonShutDown = 0x00000303;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsStateEvent_ShutDownTimerUpdate = 0x00000304;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsStateEvent_CaptureError = 0x00000305;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsStateEvent_InternalError = 0x00000306;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsStateEvent_AfResult = 0x00000309;
    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public static final int kEdsStateEvent_BulbExposureTime = 0x00000310;
    /**
     * <i>native declaration : sdk-header\EDSDK.h</i>
     */
    public static final int oldif = 0;

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public interface EdsProgressCallback extends StdCallCallback {

        NativeLong apply(NativeLong inPercent, Pointer inContext, IntByReference outCancel);

        // will remove as it requires to do "new EdsVoid(new Memory(size expected))", instead we simply have with Pointer "new Memory(size expected)"
//        @Deprecated
//        NativeLong apply(NativeLong inPercent, EdsVoid inContext, IntByReference outCancel);
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public interface EdsCameraAddedHandler extends StdCallCallback {
        NativeLong apply(Pointer inContext);

        // will remove as it requires to do "new EdsVoid(new Memory(size expected))", instead we simply have with Pointer "new Memory(size expected)"
//        @Deprecated
//        NativeLong apply(EdsVoid inContext);
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public interface EdsPropertyEventHandler extends StdCallCallback {
        NativeLong apply(NativeLong inEvent, NativeLong inPropertyID, NativeLong inParam, Pointer inContext);

        // will remove as it requires to do "new EdsVoid(new Memory(size expected))", instead we simply have with Pointer "new Memory(size expected)"
//        @Deprecated
//        NativeLong apply(NativeLong inEvent, NativeLong inPropertyID, NativeLong inParam, EdsVoid inContext);
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public interface EdsObjectEventHandler extends StdCallCallback {
        NativeLong apply(NativeLong inEvent, EdsBaseRef inRef, Pointer inContext);

        // will remove as it requires to do "new EdsVoid(new Memory(size expected))", instead we simply have with Pointer "new Memory(size expected)"
//        @Deprecated
//        NativeLong apply(NativeLong inEvent, EdsBaseRef inRef, EdsVoid inContext);
//        NativeLong apply(NativeLong inEvent, Pointer inRef, EdsVoid inContext);
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h</i>
     */
    public interface EdsStateEventHandler extends StdCallCallback {
        NativeLong apply(NativeLong inEvent, NativeLong inEventData, Pointer inContext);

        // will remove as it requires to do "new EdsVoid(new Memory(size expected))", instead we simply have with Pointer "new Memory(size expected)"
//        @Deprecated
//        NativeLong apply(NativeLong inEvent, NativeLong inEventData, EdsVoid inContext);
    }

    /**
     * ----------------------------------------------------------------------------<br>
     * <i>native declaration : sdk-header\EDSDKTypes.h:1368</i>
     */
    public interface EdsReadStream extends StdCallCallback {
        NativeLong apply(Pointer inContext, NativeLong inReadSize, Pointer outBuffer, NativeLongByReference outReadSize);

        // will remove as it requires to do "new EdsVoid(new Memory(size expected))", instead we simply have with Pointer "new Memory(size expected)"
//        @Deprecated
//        NativeLong apply(Pointer inContext, NativeLong inReadSize, EdsVoid outBuffer, NativeLongByReference outReadSize);
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h:1369</i>
     */
    public interface EdsWriteStream extends StdCallCallback {
        NativeLong apply(Pointer inContext, NativeLong inWriteSize, Pointer inBuffer, NativeLongByReference outWrittenSize);

        // will remove as it requires to do "new EdsVoid(new Memory(size expected))", instead we simply have with Pointer "new Memory(size expected)"
//        @Deprecated
//        NativeLong apply(Pointer inContext, NativeLong inWriteSize, EdsVoid inBuffer, NativeLongByReference outWrittenSize);
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h:1370</i>
     */
    public interface EdsSeekStream extends StdCallCallback {
        NativeLong apply(Pointer inContext, NativeLong inSeekOffset, int inSeekOrigin);
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h:1371</i>
     */
    public interface EdsTellStream extends StdCallCallback {
        NativeLong apply(Pointer inContext, NativeLongByReference outPosition);
    }

    /**
     * <i>native declaration : sdk-header\EDSDKTypes.h:1372</i>
     */
    public interface EdsGetStreamLength extends StdCallCallback {
        NativeLong apply(Pointer inContext, NativeLongByReference outLength);
    }

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsInitializeSDK<br>
     * //<br>
     * //  Description:<br>
     * //      Initializes the libraries. <br>
     * //      When using the EDSDK libraries, you must call this API once  <br>
     * //          before using EDSDK APIs.<br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    None<br>
     * //      Out:    None<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsInitializeSDK()</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:63</i>
     *
     * @return any of the sdk errors
     */
    NativeLong EdsInitializeSDK();

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsTerminateSDK<br>
     * //<br>
     * //  Description:<br>
     * //      Terminates use of the libraries. <br>
     * //      This function muse be called when ending the SDK.<br>
     * //      Calling this function releases all resources allocated by the libraries.<br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    None<br>
     * //      Out:    None<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsTerminateSDK()</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:80</i>
     *
     * @return any of the sdk errors
     */
    NativeLong EdsTerminateSDK();

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsRetain<br>
     * //<br>
     * //  Description:<br>
     * //      Increments the reference counter of existing objects.<br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inRef - The reference for the item.<br>
     * //      Out:    None<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsUInt32 EdsRetain(EdsBaseRef)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:105</i>
     *
     * @param inRef the reference for the item
     * @return any of the sdk errors
     */
    NativeLong EdsRetain(EdsBaseRef inRef);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsRelease<br>
     * //<br>
     * //  Description:<br>
     * //      Decrements the reference counter to an object. <br>
     * //      When the reference counter reaches 0, the object is released.<br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inRef - The reference of the item.<br>
     * //      Out:    None<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsUInt32 EdsRelease(EdsBaseRef)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:121</i>
     *
     * @param inRef the reference of the item
     * @return any of the sdk errors
     */
    NativeLong EdsRelease(EdsBaseRef inRef);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsGetChildCount<br>
     * //<br>
     * //  Description:<br>
     * //      Gets the number of child objects of the designated object.<br>
     * //      Example: Number of files in a directory<br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inRef - The reference of the list.<br>
     * //      Out:    outCount - Number of elements in this list.<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsGetChildCount(EdsBaseRef, EdsUInt32*)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:147</i>
     *
     * @param inRef    the reference of the list
     * @param outCount number of elements in this list
     * @return any of the sdk errors
     */
    NativeLong EdsGetChildCount(EdsBaseRef inRef, NativeLongByReference outCount);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsGetChildAtIndex<br>
     * //<br>
     * //  Description:<br>
     * //       Gets an indexed child object of the designated object. <br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inRef - The reference of the item.<br>
     * //              inIndex -  The index that is passed in, is zero based.<br>
     * //      Out:    outRef - The pointer which receives reference of the <br>
     * //                           specified index .<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsGetChildAtIndex(EdsBaseRef, EdsInt32, EdsBaseRef*)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:166</i>
     *
     * @param inRef   the reference of the item
     * @param inIndex the index that is passed in, is zero based
     * @param outRef  the pointer which receives reference of the specified index
     * @return any of the sdk errors
     */
    NativeLong EdsGetChildAtIndex(EdsBaseRef inRef, NativeLong inIndex, @ImplicitRetain EdsBaseRef.ByReference outRef);
//    NativeLong EdsGetChildAtIndex(EdsBaseRef inRef, NativeLong inIndex, PointerByReference outRef);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsGetParent<br>
     * //<br>
     * //  Description:<br>
     * //      Gets the parent object of the designated object.<br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inRef        - The reference of the item.<br>
     * //      Out:    outParentRef - The pointer which receives reference.<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsGetParent(EdsBaseRef, EdsBaseRef*)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:184</i>
     *
     * @param inRef        the reference of the item
     * @param outParentRef the pointer which receives reference
     * @return any of the sdk errors
     */
    NativeLong EdsGetParent(EdsBaseRef inRef, @ImplicitRetain EdsBaseRef.ByReference outParentRef);
//    NativeLong EdsGetParent(EdsBaseRef inRef, PointerByReference outParentRef);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsGetPropertySize<br>
     * //<br>
     * //  Description:<br>
     * //      Gets the byte size and data type of a designated property <br>
     * //          from a camera object or image object.<br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inRef - The reference of the item.<br>
     * //              inPropertyID - The ProprtyID<br>
     * //              inParam - Additional information of property.<br>
     * //                   We use this parameter in order to specify an index<br>
     * //                   in case there are two or more values over the same ID.<br>
     * //      Out:    outDataType - Pointer to the buffer that is to receive the property<br>
     * //                        type data.<br>
     * //              outSize - Pointer to the buffer that is to receive the property<br>
     * //                        size.<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsGetPropertySize(EdsBaseRef, EdsPropertyID, EdsInt32, EdsDataType*, EdsUInt32*)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:218</i><br>
     *
     * @param inRef        the reference of the item
     * @param inPropertyID the ProprtyID
     * @param inParam      additional information of property
     * @param outDataType  pointer to the buffer that is to receive the property type data
     * @param outSize      pointer to the buffer that is to receive the property size
     * @return any of the sdk errors
     * @deprecated use the safer methods {@link #EdsGetPropertySize(EdsdkLibrary.EdsBaseRef, NativeLong, NativeLong, IntBuffer, NativeLongByReference)} and {@link #EdsGetPropertySize(EdsBaseRef, NativeLong, NativeLong, IntByReference, NativeLongByReference)} instead
     */
    @Deprecated
    NativeLong EdsGetPropertySize(EdsBaseRef inRef, NativeLong inPropertyID, NativeLong inParam, IntByReference outDataType, NativeLongByReference outSize);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsGetPropertySize<br>
     * //<br>
     * //  Description:<br>
     * //      Gets the byte size and data type of a designated property <br>
     * //          from a camera object or image object.<br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inRef - The reference of the item.<br>
     * //              inPropertyID - The ProprtyID<br>
     * //              inParam - Additional information of property.<br>
     * //                   We use this parameter in order to specify an index<br>
     * //                   in case there are two or more values over the same ID.<br>
     * //      Out:    outDataType - Pointer to the buffer that is to receive the property<br>
     * //                        type data.<br>
     * //              outSize - Pointer to the buffer that is to receive the property<br>
     * //                        size.<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsGetPropertySize(EdsBaseRef, EdsPropertyID, EdsInt32, EdsDataType*, EdsUInt32*)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:218</i>
     *
     * @param inRef        the reference of the item
     * @param inPropertyID the ProprtyID
     * @param inParam      additional information of property
     * @param outDataType  pointer to the buffer that is to receive the property type data
     * @param outSize      pointer to the buffer that is to receive the property size
     * @return any of the sdk errors
     */
    NativeLong EdsGetPropertySize(EdsBaseRef inRef, NativeLong inPropertyID, NativeLong inParam, IntBuffer outDataType, NativeLongByReference outSize);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsGetPropertyData<br>
     * //<br>
     * //  Description:<br>
     * //      Gets property information from the object designated in inRef.<br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inRef - The reference of the item.<br>
     * //              inPropertyID - The ProprtyID<br>
     * //              inParam - Additional information of property.<br>
     * //                   We use this parameter in order to specify an index<br>
     * //                   in case there are two or more values over the same ID.<br>
     * //              inPropertySize - The number of bytes of the prepared buffer<br>
     * //                  for receive property-value.<br>
     * //       Out:   outPropertyData - The buffer pointer to receive property-value.<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsGetPropertyData(EdsBaseRef, EdsPropertyID, EdsInt32, EdsUInt32, EdsVoid*)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:244</i>
     *
     * @param inRef           The reference of the item
     * @param inPropertyID    The ProprtyID
     * @param inParam         Additional information of property
     * @param inPropertySize  The number of bytes of the prepared buffer for receive property-value
     * @param outPropertyData The buffer pointer to receive property-value
     * @return any of the sdk errors
     */
    NativeLong EdsGetPropertyData(EdsBaseRef inRef, NativeLong inPropertyID, NativeLong inParam, NativeLong inPropertySize, Pointer outPropertyData);

    // will remove as it requires to do "new EdsVoid(new Memory(size expected))", instead we simply have with Pointer "new Memory(size expected)"
    @Deprecated
    NativeLong EdsGetPropertyData(EdsBaseRef inRef, NativeLong inPropertyID, NativeLong inParam, NativeLong inPropertySize, EdsVoid outPropertyData);


    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsSetPropertyData<br>
     * //<br>
     * //  Description:<br>
     * //      Sets property data for the object designated in inRef. <br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inRef - The reference of the item.<br>
     * //              inPropertyID - The ProprtyID<br>
     * //              inParam - Additional information of property.<br>
     * //              inPropertySize - The number of bytes of the prepared buffer<br>
     * //                  for set property-value.<br>
     * //              inPropertyData - The buffer pointer to set property-value.<br>
     * //      Out:    None<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsSetPropertyData(EdsBaseRef, EdsPropertyID, EdsInt32, EdsUInt32, const EdsVoid*)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:269</i>
     *
     * @param inRef          The reference of the item
     * @param inPropertyID   The ProprtyID
     * @param inParam        Additional information of property
     * @param inPropertySize The number of bytes of the prepared buffer for set property-value
     * @param inPropertyData The buffer pointer to set property-value
     * @return any of the sdk errors
     */
    NativeLong EdsSetPropertyData(EdsBaseRef inRef, NativeLong inPropertyID, NativeLong inParam, NativeLong inPropertySize, Pointer inPropertyData);

    // will remove as it requires to do "new EdsVoid(new Memory(size expected))", instead we simply have with Pointer "new Memory(size expected)"
    @Deprecated
    NativeLong EdsSetPropertyData(EdsBaseRef inRef, NativeLong inPropertyID, NativeLong inParam, NativeLong inPropertySize, EdsVoid inPropertyData);

    /**
     * -----------------------------------------------------------------------------<br>
     * //  <br>
     * //  Function:   EdsGetPropertyDesc<br>
     * //<br>
     * //  Description:<br>
     * //      Gets a list of property data that can be set for the object <br>
     * //          designated in inRef, as well as maximum and minimum values. <br>
     * //      This API is intended for only some shooting-related properties.<br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inRef - The reference of the camera.<br>
     * //              inPropertyID - The Property ID.<br>
     * //       Out:   outPropertyDesc - Array of the value which can be set up.<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsGetPropertyDesc(EdsBaseRef, EdsPropertyID, EdsPropertyDesc*)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:292</i>
     *
     * @param inRef           The reference of the camera
     * @param inPropertyID    The Property ID
     * @param outPropertyDesc Array of the value which can be set up
     * @return any of the sdk errors
     */
    NativeLong EdsGetPropertyDesc(EdsBaseRef inRef, NativeLong inPropertyID, EdsPropertyDesc outPropertyDesc);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsGetCameraList<br>
     * //<br>
     * //  Description:<br>
     * //      Gets camera list objects.<br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    None<br>
     * //      Out:    outCameraListRef - Pointer to the camera-list.<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsGetCameraList(EdsCameraListRef*)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:319</i>
     *
     * @param outCameraListRef Pointer to the camera-list
     * @return any of the sdk errors
     */
    NativeLong EdsGetCameraList(@ImplicitRetain EdsCameraListRef.ByReference outCameraListRef);
//    NativeLong EdsGetCameraList(PointerByReference outCameraListRef);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsGetDeviceInfo<br>
     * //<br>
     * //  Description:<br>
     * //      Gets device information, such as the device name.  <br>
     * //      Because device information of remote cameras is stored <br>
     * //          on the host computer, you can use this API <br>
     * //          before the camera object initiates communication<br>
     * //          (that is, before a session is opened). <br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inCameraRef - The reference of the camera.<br>
     * //      Out:    outDeviceInfo - Information as device of camera.<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsGetDeviceInfo(EdsCameraRef, EdsDeviceInfo*)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:348</i>
     *
     * @param inCameraRef   The reference of the camera
     * @param outDeviceInfo Information as device of camera
     * @return any of the sdk errors
     */
    NativeLong EdsGetDeviceInfo(EdsCameraRef inCameraRef, EdsDeviceInfo outDeviceInfo);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsOpenSession<br>
     * //<br>
     * //  Description:<br>
     * //      Establishes a logical connection with a remote camera. <br>
     * //      Use this API after getting the camera's EdsCamera object.<br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inCameraRef - The reference of the camera <br>
     * //      Out:    None<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsOpenSession(EdsCameraRef)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:366</i>
     *
     * @param inCameraRef The reference of the camera
     * @return any of the sdk errors
     */
    NativeLong EdsOpenSession(EdsCameraRef inCameraRef);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsCloseSession<br>
     * //<br>
     * //  Description:<br>
     * //       Closes a logical connection with a remote camera.<br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inCameraRef - The reference of the camera <br>
     * //      Out:    None<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsCloseSession(EdsCameraRef)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:382</i>
     *
     * @param inCameraRef The reference of the camera
     * @return any of the sdk errors
     */
    NativeLong EdsCloseSession(EdsCameraRef inCameraRef);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsSendCommand<br>
     * //<br>
     * //  Description:<br>
     * //       Sends a command such as "Shoot" to a remote camera. <br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inCameraRef - The reference of the camera which will receive the <br>
     * //                      command.<br>
     * //              inCommand - Specifies the command to be sent.<br>
     * //              inParam -     Specifies additional command-specific information.<br>
     * //      Out:    None<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsSendCommand(EdsCameraRef, EdsCameraCommand, EdsInt32)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:401</i>
     *
     * @param inCameraRef The reference of the camera which will receive the command
     * @param inCommand   Specifies the command to be sent
     * @param inParam     Specifies additional command-specific information
     * @return any of the sdk errors
     */
    NativeLong EdsSendCommand(EdsCameraRef inCameraRef, NativeLong inCommand, NativeLong inParam);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsSendStatusCommand<br>
     * //<br>
     * //  Description:<br>
     * //       Sets the remote camera state or mode.<br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inCameraRef - The reference of the camera which will receive the <br>
     * //                      command.<br>
     * //              inStatusCommand - Specifies the command to be sent.<br>
     * //              inParam -     Specifies additional command-specific information.<br>
     * //      Out:    None<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsSendStatusCommand(EdsCameraRef, EdsCameraStatusCommand, EdsInt32)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:422</i>
     *
     * @param inCameraRef     The reference of the camera which will receive the command
     * @param inStatusCommand Specifies the command to be sent
     * @param inParam         Specifies additional command-specific information
     * @return any of the sdk errors
     */
    NativeLong EdsSendStatusCommand(EdsCameraRef inCameraRef, NativeLong inStatusCommand, NativeLong inParam);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsSetCapacity<br>
     * //<br>
     * //  Description:<br>
     * //      Sets the remaining HDD capacity on the host computer<br>
     * //          (excluding the portion from image transfer),<br>
     * //          as calculated by subtracting the portion from the previous time. <br>
     * //      Set a reset flag initially and designate the cluster length <br>
     * //          and number of free clusters.<br>
     * //      Some type 2 protocol standard cameras can display the number of shots <br>
     * //          left on the camera based on the available disk capacity <br>
     * //          of the host computer. <br>
     * //      For these cameras, after the storage destination is set to the computer, <br>
     * //          use this API to notify the camera of the available disk capacity <br>
     * //          of the host computer.<br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inCameraRef - The reference of the camera which will receive the <br>
     * //                      command.<br>
     * //              inCapacity -  The remaining capacity of a transmission place.<br>
     * //      Out:    None<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsSetCapacity(EdsCameraRef, EdsCapacity)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:453</i>
     *
     * @param inCameraRef The reference of the camera which will receive the command
     * @param inCapacity  The remaining capacity of a transmission place
     * @return any of the sdk errors
     */
    NativeLong EdsSetCapacity(EdsCameraRef inCameraRef, EdsCapacity.ByValue inCapacity);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsGetVolumeInfo<br>
     * //<br>
     * //  Description:<br>
     * //      Gets volume information for a memory card in the camera.<br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inVolumeRef - The reference of the volume.<br>
     * //      Out:    outVolumeInfo - information of  the volume.<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsGetVolumeInfo(EdsVolumeRef, EdsVolumeInfo*)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:479</i>
     *
     * @param inVolumeRef   The reference of the volume
     * @param outVolumeInfo information of  the volume
     * @return any of the sdk errors
     */
    NativeLong EdsGetVolumeInfo(EdsVolumeRef inVolumeRef, EdsVolumeInfo outVolumeInfo);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsFormatVolume<br>
     * //<br>
     * //  Description:<br>
     * //       Formats volumes of memory cards in a camera. <br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inVolumeRef - The reference of volume .<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsFormatVolume(EdsVolumeRef)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:495</i>
     *
     * @param inVolumeRef The reference of volume
     * @return any of the sdk errors
     */
    NativeLong EdsFormatVolume(EdsVolumeRef inVolumeRef);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsGetDirectoryItemInfo<br>
     * //<br>
     * //  Description:<br>
     * //      Gets information about the directory or file objects <br>
     * //          on the memory card (volume) in a remote camera.<br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inDirItemRef - The reference of the directory item.<br>
     * //      Out:    outDirItemInfo - information of the directory item.<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsGetDirectoryItemInfo(EdsDirectoryItemRef, EdsDirectoryItemInfo*)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:521</i>
     *
     * @param inDirItemRef   The reference of the directory item
     * @param outDirItemInfo information of the directory item
     * @return any of the sdk errors
     */
    NativeLong EdsGetDirectoryItemInfo(EdsDirectoryItemRef inDirItemRef, EdsDirectoryItemInfo outDirItemInfo);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsDeleteDirectoryItem<br>
     * //<br>
     * //  Description:<br>
     * //      Deletes a camera folder or file.<br>
     * //      If folders with subdirectories are designated, all files are deleted <br>
     * //          except protected files. <br>
     * //      EdsDirectoryItem objects deleted by means of this API are implicitly <br>
     * //          released by the EDSDK. Thus, there is no need to release them <br>
     * //          by means of EdsRelease.<br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inDirItemRef - The reference of the directory item.<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsDeleteDirectoryItem(EdsDirectoryItemRef)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:543</i>
     *
     * @param inDirItemRef The reference of the directory item
     * @return any of the sdk errors
     */
    NativeLong EdsDeleteDirectoryItem(EdsDirectoryItemRef inDirItemRef);

    /**
     * TODO no need NativeLong for inReadSize (EdsUInt64)
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsDownload<br>
     * //<br>
     * //  Description:<br>
     * //       Downloads a file on a remote camera <br>
     * //          (in the camera memory or on a memory card) to the host computer. <br>
     * //      The downloaded file is sent directly to a file stream created in advance. <br>
     * //      When dividing the file being retrieved, call this API repeatedly. <br>
     * //      Also in this case, make the data block size a multiple of 512 (bytes), <br>
     * //          excluding the final block.<br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inDirItemRef - The reference of the directory item.<br>
     * //              inReadSize   - <br>
     * //<br>
     * //      Out:    outStream    - The reference of the stream.<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsDownload(EdsDirectoryItemRef, EdsUInt64, EdsStreamRef)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:566</i>
     *
     * @param inDirItemRef The reference of the directory item
     * @param inReadSize   Size to read
     * @param outStream    The reference of the stream
     * @return any of the sdk errors
     */
    NativeLong EdsDownload(EdsDirectoryItemRef inDirItemRef, long inReadSize, EdsStreamRef outStream);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsDownloadCancel<br>
     * //<br>
     * //  Description:<br>
     * //       Must be executed when downloading of a directory item is canceled. <br>
     * //      Calling this API makes the camera cancel file transmission.<br>
     * //      It also releases resources. <br>
     * //      This operation need not be executed when using EdsDownloadThumbnail. <br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inDirItemRef - The reference of the directory item.<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsDownloadCancel(EdsDirectoryItemRef)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:586</i>
     *
     * @param inDirItemRef The reference of the directory item
     * @return any of the sdk errors
     */
    NativeLong EdsDownloadCancel(EdsDirectoryItemRef inDirItemRef);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsDownloadComplete<br>
     * //<br>
     * //  Description:<br>
     * //       Must be called when downloading of directory items is complete. <br>
     * //          Executing this API makes the camera <br>
     * //              recognize that file transmission is complete. <br>
     * //          This operation need not be executed when using EdsDownloadThumbnail.<br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inDirItemRef - The reference of the directory item.<br>
     * //<br>
     * //      Out:    outStream    - None.<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsDownloadComplete(EdsDirectoryItemRef)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:606</i>
     *
     * @param inDirItemRef The reference of the directory item
     * @return any of the sdk errors
     */
    NativeLong EdsDownloadComplete(EdsDirectoryItemRef inDirItemRef);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsDownloadThumbnail<br>
     * //<br>
     * //  Description:<br>
     * //      Extracts and downloads thumbnail information from image files in a camera. <br>
     * //      Thumbnail information in the camera's image files is downloaded <br>
     * //          to the host computer. <br>
     * //      Downloaded thumbnails are sent directly to a file stream created in advance.<br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inDirItemRef - The reference of the directory item.<br>
     * //<br>
     * //      Out:    outStream - The reference of the stream.<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsDownloadThumbnail(EdsDirectoryItemRef, EdsStreamRef)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:626</i>
     *
     * @param inDirItemRef The reference of the directory item
     * @param outStream    The reference of the stream
     * @return any of the sdk errors
     */
    NativeLong EdsDownloadThumbnail(EdsDirectoryItemRef inDirItemRef, EdsStreamRef outStream);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsGetAttribute<br>
     * //<br>
     * //  Description:<br>
     * //      Gets attributes of files on a camera.<br>
     * //  <br>
     * //  Parameters:<br>
     * //       In:    inDirItemRef - The reference of the directory item.<br>
     * //      Out:    outFileAttribute  - Indicates the file attributes. <br>
     * //                  As for the file attributes, OR values of the value defined<br>
     * //                  by enum EdsFileAttributes can be retrieved. Thus, when <br>
     * //                  determining the file attributes, you must check <br>
     * //                  if an attribute flag is set for target attributes. <br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsGetAttribute(EdsDirectoryItemRef, EdsFileAttributes*)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:647</i><br>
     *
     * @param inDirItemRef     The reference of the directory item
     * @param outFileAttribute Indicates the file attributes
     * @return any of the sdk errors
     * @deprecated use the safer methods {@link #EdsGetAttribute(EdsdkLibrary.EdsDirectoryItemRef, IntBuffer)} and {@link #EdsGetAttribute(EdsDirectoryItemRef, IntByReference)} instead
     */
    @Deprecated
    NativeLong EdsGetAttribute(EdsDirectoryItemRef inDirItemRef, IntByReference outFileAttribute);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsGetAttribute<br>
     * //<br>
     * //  Description:<br>
     * //      Gets attributes of files on a camera.<br>
     * //  <br>
     * //  Parameters:<br>
     * //       In:    inDirItemRef - The reference of the directory item.<br>
     * //      Out:    outFileAttribute  - Indicates the file attributes. <br>
     * //                  As for the file attributes, OR values of the value defined<br>
     * //                  by enum EdsFileAttributes can be retrieved. Thus, when <br>
     * //                  determining the file attributes, you must check <br>
     * //                  if an attribute flag is set for target attributes. <br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsGetAttribute(EdsDirectoryItemRef, EdsFileAttributes*)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:647</i>
     *
     * @param inDirItemRef     The reference of the directory item
     * @param outFileAttribute Indicates the file attributes
     * @return any of the sdk errors
     */
    NativeLong EdsGetAttribute(EdsDirectoryItemRef inDirItemRef, IntBuffer outFileAttribute);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsSetAttribute<br>
     * //<br>
     * //  Description:<br>
     * //      Changes attributes of files on a camera.<br>
     * //  <br>
     * //  Parameters:<br>
     * //       In:    inDirItemRef - The reference of the directory item.<br>
     * //              inFileAttribute  - Indicates the file attributes. <br>
     * //                      As for the file attributes, OR values of the value <br>
     * //                      defined by enum EdsFileAttributes can be retrieved. <br>
     * //      Out:    None<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsSetAttribute(EdsDirectoryItemRef, EdsFileAttributes)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:667</i>
     *
     * @param inDirItemRef    The reference of the directory item
     * @param inFileAttribute Indicates the file attributes
     * @return any of the sdk errors
     */
    NativeLong EdsSetAttribute(EdsDirectoryItemRef inDirItemRef, int inFileAttribute);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsCreateFileStream<br>
     * //<br>
     * //  Description:<br>
     * //      Creates a new file on a host computer (or opens an existing file) <br>
     * //          and creates a file stream for access to the file. <br>
     * //      If a new file is designated before executing this API, <br>
     * //          the file is actually created following the timing of writing <br>
     * //          by means of EdsWrite or the like with respect to an open stream.<br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inFileName - Pointer to a null-terminated string that specifies<br>
     * //                           the file name.<br>
     * //              inCreateDisposition - Action to take on files that exist, <br>
     * //                                and which action to take when files do not exist.  <br>
     * //              inDesiredAccess - Access to the stream (reading, writing, or both).<br>
     * //      Out:    outStream - The reference of the stream.<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsCreateFileStream(const EdsChar*, EdsFileCreateDisposition, EdsAccess, EdsStreamRef*)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:702</i>
     *
     * @param inFileName          Pointer to a null-terminated string that specifies the file name
     * @param inCreateDisposition Action to take on files that exist and which action to take when files do not exist
     * @param inDesiredAccess     Access to the stream (reading, writing, or both)
     * @param outStream           The reference of the stream
     * @return any of the sdk errors
     */
    NativeLong EdsCreateFileStream(ByteBuffer inFileName, int inCreateDisposition, int inDesiredAccess, EdsStreamRef.ByReference outStream);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsCreateFileStream<br>
     * //<br>
     * //  Description:<br>
     * //      Creates a new file on a host computer (or opens an existing file) <br>
     * //          and creates a file stream for access to the file. <br>
     * //      If a new file is designated before executing this API, <br>
     * //          the file is actually created following the timing of writing <br>
     * //          by means of EdsWrite or the like with respect to an open stream.<br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inFileName - Pointer to a null-terminated string that specifies<br>
     * //                           the file name.<br>
     * //              inCreateDisposition - Action to take on files that exist, <br>
     * //                                and which action to take when files do not exist.  <br>
     * //              inDesiredAccess - Access to the stream (reading, writing, or both).<br>
     * //      Out:    outStream - The reference of the stream.<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsCreateFileStream(const EdsChar*, EdsFileCreateDisposition, EdsAccess, EdsStreamRef*)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:702</i>
     *
     * @param inFileName          Pointer to a null-terminated string that specifies the file name
     * @param inCreateDisposition Action to take on files that exist and which action to take when files do not exist
     * @param inDesiredAccess     Access to the stream (reading, writing, or both)
     * @param outStream           The reference of the stream
     * @return any of the sdk errors
     */
    NativeLong EdsCreateFileStream(byte inFileName[], int inCreateDisposition, int inDesiredAccess, EdsStreamRef.ByReference outStream);

    /**
     * TODO no need NativeLong for inBufferSize (EdsUInt64)
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsCreateMemoryStream<br>
     * //<br>
     * //  Description:<br>
     * //      Creates a stream in the memory of a host computer. <br>
     * //      In the case of writing in excess of the allocated buffer size, <br>
     * //          the memory is automatically extended.<br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inBufferSize - The number of bytes of the memory to allocate.<br>
     * //      Out:    outStream - The reference of the stream.<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsCreateMemoryStream(EdsUInt64, EdsStreamRef*)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:724</i>
     *
     * @param inBufferSize The number of bytes of the memory to allocate
     * @param outStream    The reference of the stream
     * @return any of the sdk errors
     */
    NativeLong EdsCreateMemoryStream(long inBufferSize, EdsStreamRef.ByReference outStream);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsCreateStreamEx<br>
     * //<br>
     * //  Description:<br>
     * //      An extended version of EdsCreateStreamFromFile. <br>
     * //      Use this function when working with Unicode file names.<br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inURL (for Macintosh) - Designate CFURLRef. <br>
     * //              inFileName (for Windows) - Designate the file name. <br>
     * //              inCreateDisposition - Action to take on files that exist, <br>
     * //                                and which action to take when files do not exist.  <br>
     * //              inDesiredAccess - Access to the stream (reading, writing, or both).<br>
     * //<br>
     * //      Out:    outStream - The reference of the stream.<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsCreateFileStreamEx(const WCHAR*, EdsFileCreateDisposition, EdsAccess, EdsStreamRef*)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:748</i>
     *
     * @param inFileName          Designate the file name
     * @param inCreateDisposition Action to take on files that exist and which action to take when files do not exist
     * @param inDesiredAccess     Access to the stream (reading, writing, or both)
     * @param outStream           The reference of the stream
     * @return any of the sdk errors
     */
    NativeLong EdsCreateFileStreamEx(short inFileName[], int inCreateDisposition, int inDesiredAccess, EdsStreamRef.ByReference outStream);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsCreateStreamEx<br>
     * //<br>
     * //  Description:<br>
     * //      An extended version of EdsCreateStreamFromFile. <br>
     * //      Use this function when working with Unicode file names.<br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inURL (for Macintosh) - Designate CFURLRef. <br>
     * //              inFileName (for Windows) - Designate the file name. <br>
     * //              inCreateDisposition - Action to take on files that exist, <br>
     * //                                and which action to take when files do not exist.  <br>
     * //              inDesiredAccess - Access to the stream (reading, writing, or both).<br>
     * //<br>
     * //      Out:    outStream - The reference of the stream.<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsCreateFileStreamEx(const WCHAR*, EdsFileCreateDisposition, EdsAccess, EdsStreamRef*)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:748</i>
     *
     * @param inFileName          Designate the file name
     * @param inCreateDisposition Action to take on files that exist and which action to take when files do not exist
     * @param inDesiredAccess     Access to the stream (reading, writing, or both)
     * @param outStream           The reference of the stream
     * @return any of the sdk errors
     * @deprecated use safer method {@link #EdsCreateFileStreamEx(short[], int, int, EdsStreamRef.ByReference)}
     */
    @Deprecated
    NativeLong EdsCreateFileStreamEx(ShortByReference inFileName, int inCreateDisposition, int inDesiredAccess, EdsStreamRef.ByReference outStream);

    /**
     * TODO no need NativeLong for inBufferSize (EdsUInt64)
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsCreateMemoryStreamFromPointer<br>
     * //<br>
     * //  Description:<br>
     * //      Creates a stream from the memory buffer you prepare. <br>
     * //      Unlike the buffer size of streams created by means of EdsCreateMemoryStream, <br>
     * //      the buffer size you prepare for streams created this way does not expand.<br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inUserBuffer - Pointer to the buffer you have prepared.<br>
     * //                    Streams created by means of this API lead to this buffer. <br>
     * //              inBufferSize - The number of bytes of the memory to allocate.<br>
     * //      Out:    outStream - The reference of the stream.<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsCreateMemoryStreamFromPointer(EdsVoid*, EdsUInt64, EdsStreamRef*)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:778</i>
     *
     * @param inUserBuffer Pointer to the buffer you have prepared. Streams created by means of this API lead to this buffer
     * @param inBufferSize The number of bytes of the memory to allocate
     * @param outStream    The reference of the stream
     * @return any of the sdk errors
     */
    NativeLong EdsCreateMemoryStreamFromPointer(Pointer inUserBuffer, long inBufferSize, EdsStreamRef.ByReference outStream);

    // will remove as it requires to do "new EdsVoid(new Memory(size expected))", instead we simply have with Pointer "new Memory(size expected)"
    @Deprecated
    NativeLong EdsCreateMemoryStreamFromPointer(EdsVoid inUserBuffer, long inBufferSize, EdsStreamRef.ByReference outStream);
//    NativeLong EdsCreateMemoryStreamFromPointer(EdsVoid inUserBuffer, long inBufferSize, PointerByReference outStream);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsGetPointer                   <br>
     * //<br>
     * //  Description:<br>
     * //      Gets the pointer to the start address of memory managed by the memory stream. <br>
     * //      As the EDSDK automatically resizes the buffer, the memory stream provides <br>
     * //          you with the same access methods as for the file stream. <br>
     * //      If access is attempted that is excessive with regard to the buffer size<br>
     * //          for the stream, data before the required buffer size is allocated <br>
     * //          is copied internally, and new writing occurs. <br>
     * //      Thus, the buffer pointer might be switched on an unknown timing. <br>
     * //      Caution in use is therefore advised. <br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inStream - Designate the memory stream for the pointer to retrieve. <br>
     * //      Out:    outPointer - If successful, returns the pointer to the buffer <br>
     * //                  written in the memory stream.<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsGetPointer(EdsStreamRef, EdsVoid**)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:805</i>
     *
     * @param inStream   Designate the memory stream for the pointer to retrieve
     * @param outPointer If successful, returns the pointer to the buffer written in the memory stream
     * @return any of the sdk errors
     */
    NativeLong EdsGetPointer(EdsStreamRef inStream, PointerByReference outPointer);

    /**
     * TODO no need NativeLong for inReadSize (EdsUInt64)
     * TODO no need NativeLongByReference for outWrittenSize (EdsUInt64*)
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsRead<br>
     * //<br>
     * //  Description:<br>
     * //      Reads data the size of inReadSize into the outBuffer buffer, <br>
     * //          starting at the current read or write position of the stream. <br>
     * //      The size of data actually read can be designated in outReadSize.<br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inStreamRef - The reference of the stream or image.<br>
     * //              inReadSize -  The number of bytes to read.<br>
     * //      Out:    outBuffer - Pointer to the user-supplied buffer that is to receive<br>
     * //                          the data read from the stream. <br>
     * //              outReadSize - The actually read number of bytes.<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsRead(EdsStreamRef, EdsUInt64, EdsVoid*, EdsUInt64*)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:828</i>
     *
     * @param inStreamRef The reference of the stream or image
     * @param inReadSize  The number of bytes to read
     * @param outBuffer   Pointer to the user-supplied buffer that is to receive the data read from the stream
     * @param outReadSize The actually read number of bytes
     * @return any of the sdk errors
     */
    NativeLong EdsRead(EdsStreamRef inStreamRef, long inReadSize, Pointer outBuffer, LongByReference outReadSize);

    // will remove as it requires to do "new EdsVoid(new Memory(size expected))", instead we simply have with Pointer "new Memory(size expected)"
    @Deprecated
    NativeLong EdsRead(EdsStreamRef inStreamRef, long inReadSize, EdsVoid outBuffer, LongByReference outReadSize);
//    NativeLong EdsRead(EdsStreamRef inStreamRef, long inReadSize, EdsVoid outBuffer, NativeLongByReference outReadSize);
//    NativeLong EdsRead(EdsStreamRef inStreamRef, long inReadSize, EdsVoid outBuffer, LongBuffer outReadSize);

    /**
     * TODO no need NativeLong for inWriteSize (EdsUInt64)
     * TODO no need NativeLongByReference for outWrittenSize (EdsUInt64*)
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsWrite<br>
     * //<br>
     * //  Description:<br>
     * //      Writes data of a designated buffer <br>
     * //          to the current read or write position of the stream. <br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inStreamRef  - The reference of the stream or image.<br>
     * //              inWriteSize - The number of bytes to write.<br>
     * //              inBuffer - A pointer to the user-supplied buffer that contains <br>
     * //                         the data to be written to the stream.<br>
     * //      Out:    outWrittenSize - The actually written-in number of bytes.<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsWrite(EdsStreamRef, EdsUInt64, const EdsVoid*, EdsUInt64*)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:852</i>
     *
     * @param inStreamRef    The reference of the stream or image
     * @param inWriteSize    The number of bytes to write
     * @param inBuffer       A pointer to the user-supplied buffer that contains the data to be written to the stream
     * @param outWrittenSize The actually written-in number of bytes
     * @return any of the sdk errors
     */
    NativeLong EdsWrite(EdsStreamRef inStreamRef, long inWriteSize, Pointer inBuffer, LongByReference outWrittenSize);

    // will remove as it requires to do "new EdsVoid(new Memory(size expected))", instead we simply have with Pointer "new Memory(size expected)"
    @Deprecated
    NativeLong EdsWrite(EdsStreamRef inStreamRef, long inWriteSize, EdsVoid inBuffer, LongByReference outWrittenSize);
//    NativeLong EdsWrite(EdsStreamRef inStreamRef, long inWriteSize, EdsVoid inBuffer, NativeLongByReference outWrittenSize);
//    NativeLong EdsWrite(EdsStreamRef inStreamRef, long inWriteSize, EdsVoid inBuffer, LongBuffer outWrittenSize);

    /**
     * TODO no need NativeLong for inSeekOffset (EdsInt64)
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsSeek<br>
     * //<br>
     * //  Description:<br>
     * //      Moves the read or write position of the stream<br>
     * (that is, the file position indicator).<br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inStreamRef  - The reference of the stream or image. <br>
     * //              inSeekOffset - Number of bytes to move the pointer. <br>
     * //              inSeekOrigin - Pointer movement mode. Must be one of the following <br>
     * //                             values.<br>
     * //                  kEdsSeek_Cur     Move the stream pointer inSeekOffset bytes <br>
     * //                                   from the current position in the stream. <br>
     * //                  kEdsSeek_Begin   Move the stream pointer inSeekOffset bytes<br>
     * //                                   forward from the beginning of the stream. <br>
     * //                  kEdsSeek_End     Move the stream pointer inSeekOffset bytes<br>
     * //                                   from the end of the stream. <br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsSeek(EdsStreamRef, EdsInt64, EdsSeekOrigin)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:881</i>
     *
     * @param inStreamRef  The reference of the stream or image
     * @param inSeekOffset Number of bytes to move the pointer
     * @param inSeekOrigin Pointer movement mode
     * @return any of the sdk errors
     */
    NativeLong EdsSeek(EdsStreamRef inStreamRef, long inSeekOffset, int inSeekOrigin);

    /**
     * TODO no need NativeLongByReference for outPosition (EdsUInt64*)
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsGetPosition<br>
     * //<br>
     * //  Description:<br>
     * //       Gets the current read or write position of the stream<br>
     * //          (that is, the file position indicator).<br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inStreamRef - The reference of the stream or image.<br>
     * //      Out:    outPosition - The current stream pointer.<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsGetPosition(EdsStreamRef, EdsUInt64*)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:901</i>
     *
     * @param inStreamRef The reference of the stream or image
     * @param outPosition The current stream pointer
     * @return any of the sdk errors
     */
    NativeLong EdsGetPosition(EdsStreamRef inStreamRef, LongByReference outPosition);
//    NativeLong EdsGetPosition(EdsStreamRef inStreamRef, NativeLongByReference outPosition);
//    NativeLong EdsGetPosition(EdsStreamRef inStreamRef, LongBuffer outPosition);

    /**
     * TODO no need NativeLongByReference for outLength (EdsUInt64*)
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsGetLength<br>
     * //<br>
     * //  Description:<br>
     * //      Gets the stream size.<br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inStreamRef - The reference of the stream or image.<br>
     * //      Out:    outLength - The length of the stream.<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsGetLength(EdsStreamRef, EdsUInt64*)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:919</i>
     *
     * @param inStreamRef The reference of the stream or image
     * @param outLength   The length of the stream
     * @return any of the sdk errors
     */
    NativeLong EdsGetLength(EdsStreamRef inStreamRef, LongByReference outLength);
//    NativeLong EdsGetLength(EdsStreamRef inStreamRef, NativeLongByReference outLength);
//    NativeLong EdsGetLength(EdsStreamRef inStreamRef, LongBuffer outLength);

    /**
     * TODO no need NativeLong for inWriteSize (EdsUInt64)
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsCopyData<br>
     * //<br>
     * //  Description:<br>
     * //      Copies data from the copy source stream to the copy destination stream. <br>
     * //      The read or write position of the data to copy is determined from <br>
     * //          the current file read or write position of the respective stream. <br>
     * //      After this API is executed, the read or write positions of the copy source <br>
     * //          and copy destination streams are moved an amount corresponding to <br>
     * //          inWriteSize in the positive direction. <br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inStreamRef - The reference of the stream or image.<br>
     * //              inWriteSize - The number of bytes to copy.<br>
     * //      Out:    outStreamRef - The reference of the stream or image.<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsCopyData(EdsStreamRef, EdsUInt64, EdsStreamRef)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:943</i>
     *
     * @param inStreamRef  The reference of the stream or image
     * @param inWriteSize  The number of bytes to copy
     * @param outStreamRef The reference of the stream or image
     * @return any of the sdk errors
     */
    NativeLong EdsCopyData(EdsStreamRef inStreamRef, long inWriteSize, EdsStreamRef outStreamRef);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsSetProgressCallback<br>
     * //<br>
     * //  Description:<br>
     * //      Register a progress callback function. <br>
     * //      An event is received as notification of progress during processing that <br>
     * //          takes a relatively long time, such as downloading files from a<br>
     * //          remote camera. <br>
     * //      If you register the callback function, the EDSDK calls the callback<br>
     * //          function during execution or on completion of the following APIs. <br>
     * //      This timing can be used in updating on-screen progress bars, for example.<br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inRef - The reference of the stream or image.<br>
     * //              inProgressCallback - Pointer to a progress callback function.<br>
     * //              inProgressOption - The option about progress is specified.<br>
     * //                              Must be one of the following values.<br>
     * //                         kEdsProgressOption_Done <br>
     * //                             When processing is completed,a callback function<br>
     * //                             is called only at once.<br>
     * //                         kEdsProgressOption_Periodically<br>
     * //                             A callback function is performed periodically.<br>
     * //              inContext - Application information, passed in the argument <br>
     * //                      when the callback function is called. Any information <br>
     * //                      required for your program may be added. <br>
     * //      Out:    None<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsSetProgressCallback(EdsBaseRef, EdsProgressCallback, EdsProgressOption, EdsVoid*)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:979</i>
     *
     * @param inRef              The reference of the stream or image
     * @param inProgressCallback Pointer to a progress callback function
     * @param inProgressOption   The option about progress is specified
     * @param inContext          Application information, passed in the argument when the callback function is called. Any information required for your program may be added
     * @return any of the sdk errors
     */
    NativeLong EdsSetProgressCallback(EdsBaseRef inRef, EdsProgressCallback inProgressCallback, int inProgressOption, Pointer inContext);

    // will remove as it requires to do "new EdsVoid(new Memory(size expected))", instead we simply have with Pointer "new Memory(size expected)"
    @Deprecated
    NativeLong EdsSetProgressCallback(EdsBaseRef inRef, EdsProgressCallback inProgressCallback, int inProgressOption, EdsVoid inContext);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsCreateImageRef<br>
     * //<br>
     * //  Description:<br>
     * //      Creates an image object from an image file. <br>
     * //      Without modification, stream objects cannot be worked with as images. <br>
     * //      Thus, when extracting images from image files, <br>
     * //          you must use this API to create image objects. <br>
     * //      The image object created this way can be used to get image information <br>
     * //          (such as the height and width, number of color components, and<br>
     * //           resolution), thumbnail image data, and the image data itself.<br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inStreamRef - The reference of the stream.<br>
     * //<br>
     * //       Out:    outImageRef - The reference of the image.<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsCreateImageRef(EdsStreamRef, EdsImageRef*)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:1015</i>
     *
     * @param inStreamRef The reference of the stream
     * @param outImageRef The reference of the image
     * @return any of the sdk errors
     */
    NativeLong EdsCreateImageRef(EdsStreamRef inStreamRef, EdsImageRef.ByReference outImageRef);
//    NativeLong EdsCreateImageRef(EdsStreamRef inStreamRef, PointerByReference outImageRef);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsGetImageInfo<br>
     * //<br>
     * //  Description:<br>
     * //      Gets image information from a designated image object. <br>
     * //      Here, image information means the image width and height, <br>
     * //          number of color components, resolution, and effective image area.<br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inStreamRef - Designate the object for which to get image information. <br>
     * //              inImageSource - Of the various image data items in the image file,<br>
     * //                  designate the type of image data representing the <br>
     * //                  information you want to get. Designate the image as<br>
     * //                  defined in Enum EdsImageSource. <br>
     * //<br>
     * //                      kEdsImageSrc_FullView<br>
     * //                                  The image itself (a full-sized image) <br>
     * //                      kEdsImageSrc_Thumbnail<br>
     * //                                  A thumbnail image <br>
     * //                      kEdsImageSrc_Preview<br>
     * //                                  A preview image<br>
     * //                      kEdsImageSrc_RAWThumbnail<br>
     * //                                  A RAW thumbnail image <br>
     * //                      kEdsImageSrc_RAWFullView<br>
     * //                                  A RAW full-sized image <br>
     * //       Out:    outImageInfo - Stores the image data information designated <br>
     * //                      in inImageSource. <br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsGetImageInfo(EdsImageRef, EdsImageSource, EdsImageInfo*)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:1050</i>
     *
     * @param inImageRef    Designate the object for which to get image information
     * @param inImageSource Designate the type of image data EdsImageSource
     * @param outImageInfo  Stores the image data information designated in inImageSource
     * @return any of the sdk errors
     */
    NativeLong EdsGetImageInfo(EdsImageRef inImageRef, int inImageSource, EdsImageInfo outImageInfo);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsGetImage                         <br>
     * //<br>
     * //  Description:<br>
     * //      Gets designated image data from an image file, in the form of a<br>
     * //          designated rectangle. <br>
     * //      Returns uncompressed results for JPEGs and processed results <br>
     * //          in the designated pixel order (RGB, Top-down BGR, and so on) for<br>
     * //           RAW images. <br>
     * //      Additionally, by designating the input/output rectangle, <br>
     * //          it is possible to get reduced, enlarged, or partial images. <br>
     * //      However, because images corresponding to the designated output rectangle <br>
     * //          are always returned by the SDK, the SDK does not take the aspect <br>
     * //          ratio into account. <br>
     * //      To maintain the aspect ratio, you must keep the aspect ratio in mind <br>
     * //          when designating the rectangle. <br>
     * //<br>
     * //  Parameters:<br>
     * //      In:     <br>
     * //              inImageRef - Designate the image object for which to get <br>
     * //                      the image data.<br>
     * //              inImageSource - Designate the type of image data to get from<br>
     * //                      the image file (thumbnail, preview, and so on). <br>
     * //                      Designate values as defined in Enum EdsImageSource. <br>
     * //              inImageType - Designate the output image type. Because<br>
     * //                      the output format of EdGetImage may only be RGB, only<br>
     * //                      kEdsTargetImageType_RGB or kEdsTargetImageType_RGB16<br>
     * //                      can be designated. <br>
     * //                      However, image types exceeding the resolution of <br>
     * //                      inImageSource cannot be designated. <br>
     * //              inSrcRect - Designate the coordinates and size of the rectangle<br>
     * //                      to be retrieved (processed) from the source image. <br>
     * //              inDstSize - Designate the rectangle size for output. <br>
     * //<br>
     * //      Out:    <br>
     * //              outStreamRef - Designate the memory or file stream for output of<br>
     * //                      the image.<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsGetImage(EdsImageRef, EdsImageSource, EdsTargetImageType, EdsRect, EdsSize, EdsStreamRef)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:1095</i>
     *
     * @param inImageRef    Designate the image object for which to get the image data
     * @param inImageSource Designate the type of image data to get from the image file (thumbnail, preview, and so on)
     * @param inImageType   Designate the output image type
     * @param inSrcRect     Designate the coordinates and size of the rectangle to be retrieved (processed) from the source image
     * @param inDstSize     Designate the rectangle size for output the image
     * @param outStreamRef  Designate the memory or file stream for output of
     * @return any of the sdk errors
     */
    NativeLong EdsGetImage(EdsImageRef inImageRef, int inImageSource, int inImageType, EdsRect.ByValue inSrcRect, EdsSize.ByValue inDstSize, EdsStreamRef outStreamRef);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsSaveImage            <br>
     * //<br>
     * //  Description:<br>
     * //      Saves as a designated image type after RAW processing. <br>
     * //      When saving with JPEG compression, <br>
     * //          the JPEG quality setting applies with respect to EdsOptionRef.<br>
     * //<br>
     * //  Parameters:<br>
     * //      In:    <br>
     * //          inImageRef - Designate the image object for which to produce the file. <br>
     * //          inImageType - Designate the image type to produce. Designate the <br>
     * //                  following image types.<br>
     * //<br>
     * //                  kEdsTargetImageType - Jpeg  JPEG<br>
     * //                  kEdsTargetImageType - TIFF  8-bit TIFF<br>
     * //                  kEdsTargetImageType - TIFF16    16-bit TIFF<br>
     * //          inSaveSetting - Designate saving options, such as JPEG image quality.<br>
     * //      Out:    <br>
     * //          outStreamRef - Specifies the output file stream. The memory stream <br>
     * //                  cannot be specified here.<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsSaveImage(EdsImageRef, EdsTargetImageType, EdsSaveImageSetting, EdsStreamRef)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:1128</i>
     *
     * @param inImageRef    Designate the image object for which to produce the file
     * @param inImageType   Designate the image type to produce
     * @param inSaveSetting Designate saving options, such as JPEG image quality
     * @param outStreamRef  Specifies the output file stream. The memory stream cannot be specified here
     * @return any of the sdk errors
     */
    NativeLong EdsSaveImage(EdsImageRef inImageRef, int inImageType, EdsSaveImageSetting.ByValue inSaveSetting, EdsStreamRef outStreamRef);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsCacheImage                       <br>
     * //<br>
     * //  Description:<br>
     * //      Switches a setting on and off for creation of an image cache in the SDK <br>
     * //          for a designated image object during extraction (processing) of<br>
     * //          the image data. <br>
     * //          Creating the cache increases the processing speed, starting from<br>
     * //          the second time.<br>
     * //<br>
     * //  Parameters:<br>
     * //      In:     inImageRef - The reference of the image.<br>
     * //              inUseCache - If cache image data or not<br>
     * //                          If set to FALSE, the cached image data will released.<br>
     * //      Out:    None<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsCacheImage(EdsImageRef, EdsBool)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:1154</i>
     *
     * @param inImageRef The reference of the image
     * @param inUseCache If cache image data or not. If set to FALSE, the cached image data will released
     * @return any of the sdk errors
     */
    NativeLong EdsCacheImage(EdsImageRef inImageRef, int inUseCache);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsReflectImageProperty         <br>
     * //  Description:<br>
     * //      Incorporates image object property changes <br>
     * //          (effected by means of EdsSetPropertyData) in the stream. <br>
     * //<br>
     * //  Parameters:<br>
     * //      In:     inImageRef - The reference of the image.<br>
     * //      Out:    None<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsReflectImageProperty(EdsImageRef)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:1171</i>
     *
     * @param inImageRef The reference of the image
     * @return any of the sdk errors
     */
    NativeLong EdsReflectImageProperty(EdsImageRef inImageRef);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsCreateEvfImageRef         <br>
     * //  Description:<br>
     * //       Creates an object used to get the live view image data set. <br>
     * //<br>
     * //  Parameters:<br>
     * //      In:     inStreamRef - The stream reference which opened to get EVF JPEG image.<br>
     * //      Out:    outEvfImageRef - The EVFData reference.<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsCreateEvfImageRef(EdsStreamRef, EdsEvfImageRef*)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:1187</i>
     *
     * @param inStreamRef    The stream reference which opened to get EVF JPEG image
     * @param outEvfImageRef The EVFData reference
     * @return any of the sdk errors
     */
    NativeLong EdsCreateEvfImageRef(EdsStreamRef inStreamRef, EdsEvfImageRef.ByReference outEvfImageRef);
//    NativeLong EdsCreateEvfImageRef(EdsStreamRef inStreamRef, PointerByReference outEvfImageRef);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsDownloadEvfImage         <br>
     * //  Description:<br>
     * //		Downloads the live view image data set for a camera currently in live view mode.<br>
     * //		Live view can be started by using the property ID:kEdsPropertyID_Evf_OutputDevice and<br>
     * //		data:EdsOutputDevice_PC to call EdsSetPropertyData.<br>
     * //		In addition to image data, information such as zoom, focus position, and histogram data<br>
     * //		is included in the image data set. Image data is saved in a stream maintained by EdsEvfImageRef.<br>
     * //		EdsGetPropertyData can be used to get information such as the zoom, focus position, etc.<br>
     * //		Although the information of the zoom and focus position can be obtained from EdsEvfImageRef,<br>
     * //		settings are applied to EdsCameraRef.<br>
     * //<br>
     * //  Parameters:<br>
     * //      In:     inCameraRef - The Camera reference.<br>
     * //      In:     inEvfImageRef - The EVFData reference.<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsDownloadEvfImage(EdsCameraRef, EdsEvfImageRef)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:1212</i>
     *
     * @param inCameraRef   The Camera reference
     * @param inEvfImageRef The EVFData reference
     * @return any of the sdk errors
     */
    NativeLong EdsDownloadEvfImage(EdsCameraRef inCameraRef, EdsEvfImageRef inEvfImageRef);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsSetCameraAddedHandler<br>
     * //<br>
     * //  Description:<br>
     * //      Registers a callback function for when a camera is detected.<br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inCameraAddedHandler - Pointer to a callback function<br>
     * //                          called when a camera is connected physically<br>
     * //              inContext - Specifies an application-defined value to be sent to<br>
     * //                          the callback function pointed to by CallBack parameter.<br>
     * //      Out:    None<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsSetCameraAddedHandler(EdsCameraAddedHandler, EdsVoid*)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:1242</i>
     *
     * @param inCameraAddedHandler Pointer to a callback function called when a camera is connected physically
     * @param inContext            Specifies an application-defined value to be sent to he callback function pointed to by CallBack parameter
     * @return any of the sdk errors
     */
    NativeLong EdsSetCameraAddedHandler(EdsCameraAddedHandler inCameraAddedHandler, Pointer inContext);

    // will remove as it requires to do "new EdsVoid(new Memory(size expected))", instead we simply have with Pointer "new Memory(size expected)"
    @Deprecated
    NativeLong EdsSetCameraAddedHandler(EdsCameraAddedHandler inCameraAddedHandler, EdsVoid inContext);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsSetPropertyEventHandler<br>
     * //              <br>
     * //  Description:<br>
     * //       Registers a callback function for receiving status <br>
     * //          change notification events for property states on a camera.<br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inCameraRef - Designate the camera object. <br>
     * //              inEvent - Designate one or all events to be supplemented.<br>
     * //              inPropertyEventHandler - Designate the pointer to the callback<br>
     * //                      function for receiving property-related camera events.<br>
     * //              inContext - Designate application information to be passed by <br>
     * //                      means of the callback function. Any data needed for<br>
     * //                      your application can be passed. <br>
     * //      Out:    None<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsSetPropertyEventHandler(EdsCameraRef, EdsPropertyEvent, EdsPropertyEventHandler, EdsVoid*)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:1267</i>
     *
     * @param inCameraRef            Designate the camera object
     * @param inEvnet                Designate one or all events to be supplemented
     * @param inPropertyEventHandler Designate the pointer to the callback function for receiving property-related camera events
     * @param inContext              Designate application information to be passed by means of the callback function. Any data needed for your application can be passed
     * @return any of the sdk errors
     */
    NativeLong EdsSetPropertyEventHandler(EdsCameraRef inCameraRef, NativeLong inEvnet, EdsPropertyEventHandler inPropertyEventHandler, Pointer inContext);

    // will remove as it requires to do "new EdsVoid(new Memory(size expected))", instead we simply have with Pointer "new Memory(size expected)"
    @Deprecated
    NativeLong EdsSetPropertyEventHandler(EdsCameraRef inCameraRef, NativeLong inEvnet, EdsPropertyEventHandler inPropertyEventHandler, EdsVoid inContext);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsSetObjectEventHandler<br>
     * //              <br>
     * //  Description:<br>
     * //       Registers a callback function for receiving status <br>
     * //          change notification events for objects on a remote camera. <br>
     * //      Here, object means volumes representing memory cards, files and directories, <br>
     * //          and shot images stored in memory, in particular. <br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inCameraRef - Designate the camera object. <br>
     * //              inEvent - Designate one or all events to be supplemented.<br>
     * //                  To designate all events, use kEdsObjectEvent_All. <br>
     * //              inObjectEventHandler - Designate the pointer to the callback function<br>
     * //                  for receiving object-related camera events.<br>
     * //              inContext - Passes inContext without modification,<br>
     * //                  as designated as an EdsSetObjectEventHandler argument. <br>
     * //      Out:    None<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsSetObjectEventHandler(EdsCameraRef, EdsObjectEvent, EdsObjectEventHandler, EdsVoid*)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:1296</i>
     *
     * @param inCameraRef          Designate the camera object
     * @param inEvnet              Designate one or all events to be supplemented. To designate all events, use kEdsObjectEvent_All
     * @param inObjectEventHandler Designate the pointer to the callback function for receiving object-related camera events
     * @param inContext            Passes inContext without modification, as designated as an EdsSetObjectEventHandler argument
     * @return any of the sdk errors
     */
    NativeLong EdsSetObjectEventHandler(EdsCameraRef inCameraRef, NativeLong inEvnet, EdsObjectEventHandler inObjectEventHandler, Pointer inContext);

    // will remove as it requires to do "new EdsVoid(new Memory(size expected))", instead we simply have with Pointer "new Memory(size expected)"
    @Deprecated
    NativeLong EdsSetObjectEventHandler(EdsCameraRef inCameraRef, NativeLong inEvnet, EdsObjectEventHandler inObjectEventHandler, EdsVoid inContext);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:  EdsSetCameraStateEventHandler<br>
     * //              <br>
     * //  Description:<br>
     * //      Registers a callback function for receiving status <br>
     * //          change notification events for property states on a camera.<br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    inCameraRef - Designate the camera object. <br>
     * //              inEvent - Designate one or all events to be supplemented.<br>
     * //                  To designate all events, use kEdsStateEvent_All. <br>
     * //              inStateEventHandler - Designate the pointer to the callback function<br>
     * //                  for receiving events related to camera object states.<br>
     * //              inContext - Designate application information to be passed<br>
     * //                  by means of the callback function. Any data needed for<br>
     * //                  your application can be passed. <br>
     * //      Out:    None<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsSetCameraStateEventHandler(EdsCameraRef, EdsStateEvent, EdsStateEventHandler, EdsVoid*)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:1324</i>
     *
     * @param inCameraRef         Designate the camera object
     * @param inEvnet             Designate one or all events to be supplemented. To designate all events, use kEdsStateEvent_All
     * @param inStateEventHandler Designate the pointer to the callback function for receiving events related to camera object states
     * @param inContext           Designate application information to be passed by means of the callback function. Any data needed for your application can be passed
     * @return any of the sdk errors
     */
    NativeLong EdsSetCameraStateEventHandler(EdsCameraRef inCameraRef, NativeLong inEvnet, EdsStateEventHandler inStateEventHandler, Pointer inContext);

    // will remove as it requires to do "new EdsVoid(new Memory(size expected))", instead we simply have with Pointer "new Memory(size expected)"
    @Deprecated
    NativeLong EdsSetCameraStateEventHandler(EdsCameraRef inCameraRef, NativeLong inEvnet, EdsStateEventHandler inStateEventHandler, EdsVoid inContext);

    /**
     * ----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsCreateStream(EdsIStream*, EdsStreamRef*)</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:1332</i>
     *
     * @param inStream     In stream
     * @param outStreamRef Out stream ref
     * @return any of the sdk errors
     */
    NativeLong EdsCreateStream(EdsIStream inStream, EdsStreamRef.ByReference outStreamRef);
//    NativeLong EdsCreateStream(EdsIStream inStream, PointerByReference outStreamRef);

    /**
     * -----------------------------------------------------------------------------<br>
     * //<br>
     * //  Function:   EdsGetEvent<br>
     * //<br>
     * //  Description:<br>
     * //      This function acquires an event. <br>
     * //      In console application, please call this function regularly to acquire<br>
     * //      the event from a camera.<br>
     * //<br>
     * //  Parameters:<br>
     * //       In:    None<br>
     * //      Out:    None<br>
     * //<br>
     * //  Returns:    Any of the sdk errors.<br>
     * -----------------------------------------------------------------------------<br>
     * Original signature : <code>__attribute__((dllimport)) EdsError EdsGetEvent()</code><br>
     * <i>native declaration : sdk-header\EDSDK.h:1349</i>
     *
     * @return any of the sdk errors
     */
    NativeLong EdsGetEvent();

    public abstract class EdsObjectByReference<T extends EdsBaseRef> extends ByReference {

        public EdsObjectByReference() {
            this(null);
        }

        public EdsObjectByReference(final T r) {
            super(Native.POINTER_SIZE);
            setValue(r);
        }

        public void setValue(final T r) {
            getPointer().setPointer(0, r != null ? r.getPointer() : null);
        }

        public abstract T getValue();
    }


    /**
     * will remove as it requires to do "new EdsVoid(new Memory(size expected))", instead we simply have with Pointer "new Memory(size expected)"
     */
    @Deprecated
    public static class EdsVoid extends PointerType {
        public EdsVoid(Pointer address) {
            super(address);
        }

        public EdsVoid() {
            super();
        }
    }

    public static class EdsBaseRef extends PointerType {

        public EdsBaseRef() {
            super();
        }

        public EdsBaseRef(Pointer address) {
            super(address);
        }

        public static class ByReference extends EdsObjectByReference<EdsBaseRef> {

            @Override
            public EdsBaseRef getValue() {
                final Pointer p = getPointer().getPointer(0);
                if (p == null) {
                    return null;
                }
                return new EdsBaseRef(p);
            }

        }
    }

    /**
     * This object represents an enumeration of the cameras remotely connected to the host PC by USB interface.
     * <br>
     * This object can be used to select the camera to be controlled from among the cameras currently connected with
     * EDSDK client application.
     * <br>
     * This object can also be used when getting an EdsCameraRef child object.
     */
    public static class EdsCameraListRef extends EdsBaseRef {

        public EdsCameraListRef() {
            super();
        }

        public EdsCameraListRef(Pointer address) {
            super(address);
        }

        public static class ByReference extends EdsBaseRef.ByReference {

            @Override
            public EdsCameraListRef getValue() {
                final Pointer p = getPointer().getPointer(0);
                if (p == null) {
                    return null;
                }
                return new EdsCameraListRef(p);
            }
        }
    }

    /**
     * This object represents a remotely connected camera.
     * <br>
     * This object is used to control the camera or to get an
     * EdsVolumeRef object when accessing the memory card, which is a child object of the camera.
     */
    public static class EdsCameraRef extends EdsBaseRef {

        public EdsCameraRef() {
            super();
        }

        public EdsCameraRef(final Pointer address) {
            super(address);
        }

        public static class ByReference extends EdsBaseRef.ByReference {

            @Override
            public EdsCameraRef getValue() {
                final Pointer p = getPointer().getPointer(0);
                if (p == null) {
                    return null;
                }
                return new EdsCameraRef(p);
            }
        }
    }

    /**
     * This object represents the memory card inside the camera.
     * <br>
     * If the camera model allows two memory cards to be installed at once,
     * the EdsVolumeRef object represents one memory card each.
     * <br>
     * This object is used to get an EdsDirectoryItemRef object, which is
     * a child object, when performing operations on a file or folder on the memory card.
     */
    public static class EdsVolumeRef extends EdsBaseRef {

        public EdsVolumeRef() {
            super();
        }

        public EdsVolumeRef(final Pointer address) {
            super(address);
        }

        public static class ByReference extends EdsBaseRef.ByReference {

            @Override
            public EdsVolumeRef getValue() {
                final Pointer p = getPointer().getPointer(0);
                if (p == null) {
                    return null;
                }
                return new EdsVolumeRef(p);
            }
        }
    }

    /**
     * This object represents a file or folder on the camera.
     * <br>
     * When files are downloaded from the camera, each file to
     * be downloaded is treated as one of these objects.
     */
    public static class EdsDirectoryItemRef extends EdsBaseRef {

        public EdsDirectoryItemRef() {
            super();
        }

        public EdsDirectoryItemRef(final Pointer address) {
            super(address);
        }

        public static class ByReference extends EdsBaseRef.ByReference {

            @Override
            public EdsDirectoryItemRef getValue() {
                final Pointer p = getPointer().getPointer(0);
                if (p == null) {
                    return null;
                }
                return new EdsDirectoryItemRef(p);
            }
        }
    }

    /**
     * This object represents the file I/O stream.
     * <br>
     * An open stream on the host PC can be specified as the download
     * destination when downloading files in the camera to the host PC.
     * <br>
     * Streams are also used when loading image files stored on the storage media of
     * the host PC into an EDSDK client application. Furthermore,
     * EdsStreamRef objects can also be created in memory.
     */
    public static class EdsStreamRef extends EdsBaseRef {

        public EdsStreamRef() {
            super();
        }

        public EdsStreamRef(final Pointer address) {
            super(address);
        }

        public static class ByReference extends EdsBaseRef.ByReference {

            @Override
            public EdsStreamRef getValue() {
                final Pointer p = getPointer().getPointer(0);
                if (p == null) {
                    return null;
                }
                return new EdsStreamRef(p);
            }
        }
    }

    /**
     * This object represents image data.
     * <br>
     * This data is obtained from image files.
     * <br>
     * This object is used to retrieve and control information included with an
     * image such as thumbnails and parameters.
     */
    public static class EdsImageRef extends EdsStreamRef {

        public EdsImageRef() {
            super();
        }

        public EdsImageRef(final Pointer address) {
            super(address);
        }

        public static class ByReference extends EdsBaseRef.ByReference {

            @Override
            public EdsImageRef getValue() {
                final Pointer p = getPointer().getPointer(0);
                if (p == null) {
                    return null;
                }
                return new EdsImageRef(p);
            }
        }
    }


    /**
     * This object represents PC live view image data.
     * <br>
     * When using a camera model that supports live view, live view image
     * data set can be downloaded from the camera.
     * <br>
     * Information such as zoom and histogram data is included with image data.
     */
    public static class EdsEvfImageRef extends EdsBaseRef {

        public EdsEvfImageRef() {
            super();
        }

        public EdsEvfImageRef(final Pointer address) {
            super(address);
        }

        public static class ByReference extends EdsBaseRef.ByReference {

            @Override
            public EdsEvfImageRef getValue() {
                final Pointer p = getPointer().getPointer(0);
                if (p == null) {
                    return null;
                }
                return new EdsEvfImageRef(p);
            }
        }
    }

}
