/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.specification.eoa.application.spring;

import org.bluestemsoftware.specification.eoa.component.application.rt.RoleReference;
import org.bluestemsoftware.specification.eoa.component.engine.rt.EngineRT;

/**
 * Models an 'abstract' role, i.e. the concrete version of which is modeled either as an
 * instance of {@link MyRole} or {@link PartnerRole}.
 * <p>
 * Note, for access to the 'middleware' api, <code>AbstractRole</code> can be cast to an
 * instance of {@link RoleReference}.
 */
public interface AbstractRole {

    /**
     * Returns 'bean type', i.e. the fully qualified name of class/interface
     * extended/implemented by 'spring' bean defined within engine configuration, i.e. engine
     * that implements parent application.
     * <p>
     * If referenced role is 'my' role, bean of indicated type encapsulates request handling
     * logic which may involve invocation of partner applications. If referenced role is
     * 'partner' role, bean of indicated type encapsulates response handling logic.
     * 
     * @return bean type, i.e. fully qualifed name of class/interface which MUST be loadable by
     *         {@link EngineRT#getApplicationClassLoader()} defined on engine which implements
     *         parent application.
     */
    public String getBeanType();

}
