/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.specification.eoa.application.spring;

import javax.xml.namespace.QName;

public interface MessageExchange {

    /**
     * Gets the 'natural' key which MAY be used to identify the exchange, i.e. if more than one
     * exchange is outstanding for the tuple partner, role and action, the id is not unique and
     * would have to be 'scoped' by user.
     * 
     * @return returns 'natural' key which MUST be the concatenation of partner (serialized as
     *         a string), role and action all of which are concatenated using the '%' char.
     */
    public String getID();

    /**
     * Gets name of 'partner' who received request, i.e. the initial message in the exchange.
     * 
     * @return partner name
     */
    public QName getPartner();

    /**
     * Returns name of role. Role is either an instance of <code>MyRole</code>, in which
     * case partner name identifies <code>MyApplication</code> or role is an instance of
     * <code>PartnerRole</code> in which case partner name identifies
     * <code>MyApplication</code>.
     * 
     * @return role name
     */
    public String getRole();

    /**
     * Uniquely identifies action within context of role, i.e. which defines the semantics of
     * the request.
     * 
     * @return
     */
    public String getAction();
    

}
