/*
 * Decompiled with CFR 0.152.
 */
package org.bluestemsoftware.specification.eoa.application.spring;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.bluestemsoftware.specification.eoa.application.spring.MessageExchange;
import org.bluestemsoftware.specification.eoa.application.spring.MyRole;
import org.bluestemsoftware.specification.eoa.component.RootComponent;
import org.bluestemsoftware.specification.eoa.component.engine.Engine;
import org.bluestemsoftware.specification.eoa.component.engine.rt.EndpointActionReference;
import org.bluestemsoftware.specification.eoa.component.engine.rt.EndpointOperationReference;
import org.bluestemsoftware.specification.eoa.component.engine.rt.EndpointReference;
import org.bluestemsoftware.specification.eoa.component.engine.rt.ServiceReference;
import org.bluestemsoftware.specification.eoa.component.intrface.Interface;
import org.bluestemsoftware.specification.eoa.component.intrface.InterfaceOperation;
import org.bluestemsoftware.specification.eoa.component.intrface.rt.ActionContext;
import org.bluestemsoftware.specification.eoa.component.intrface.rt.FaultContext;
import org.bluestemsoftware.specification.eoa.component.intrface.rt.MessageContext;
import org.bluestemsoftware.specification.eoa.component.intrface.rt.SystemFault;
import org.bluestemsoftware.specification.eoa.system.SystemContext;

public class MyOperation
implements MessageExchange,
Externalizable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String relatesTo;
    private Interface intrface;
    private EndpointOperationReference eor;
    private static final byte NULL = 0;
    private static final byte STRING = 1;

    public MyOperation() {
    }

    public MyOperation(EndpointOperationReference eor, String relatesTo) {
        if (eor == null) {
            throw new IllegalArgumentException("eor null");
        }
        if (relatesTo == null || relatesTo.equals("")) {
            throw new IllegalArgumentException("relatesTo null or empty string");
        }
        this.eor = eor;
        this.relatesTo = relatesTo;
        this.intrface = (Interface)eor.getEndpointOperation().getInterfaceOperation().getParent();
    }

    public QName getName() {
        return this.eor.getEndpointOperationName();
    }

    public InterfaceOperation getMetaData() {
        return this.intrface.getOperation(this.eor.getEndpointOperationName());
    }

    public MyRole getMyRole() {
        return (MyRole)this.eor.getParent().getParent();
    }

    public ActionContext createAction(String action) {
        return this.getResponseActionReference(action).createAction(this.relatesTo);
    }

    public MessageContext createResponseAction() {
        EndpointActionReference.ResponseActionReference ear = this.eor.getResponseAction();
        if (ear == null) {
            throw new IllegalArgumentException("Response action for operation " + this.eor.getEndpointOperationName() + " is undefined.");
        }
        return (MessageContext)ear.createAction(this.relatesTo);
    }

    public FaultContext createFaultAction(QName faultName) {
        EndpointActionReference.ResponseActionReference ear = this.eor.getFaultAction(faultName);
        if (ear == null) {
            throw new IllegalArgumentException("Fault ref " + faultName + " is undefined on operation " + this.eor.getEndpointOperationName() + ".");
        }
        return (FaultContext)ear.createAction(this.relatesTo);
    }

    public FaultContext createSystemFaultAction(String faultReason) {
        return this.eor.getParent().createSystemFaultAction(this.relatesTo, faultReason);
    }

    public FaultContext createSystemFaultAction(QName faultCode, String faultReason) {
        return this.eor.getParent().createSystemFaultAction(this.relatesTo, faultCode, faultReason);
    }

    public FaultContext createSystemFaultAction(String faultReason, Throwable cause) {
        return this.eor.getParent().createSystemFaultAction(this.relatesTo, faultReason, cause);
    }

    public FaultContext createSystemFaultAction(Throwable cause) {
        return this.eor.getParent().createSystemFaultAction(this.relatesTo, cause);
    }

    public FaultContext createSystemFaultAction(SystemFault systemFault) {
        return this.eor.getParent().createSystemFaultAction(this.relatesTo, systemFault);
    }

    public void sendResponse(ActionContext responseAction) throws SystemFault {
        this.eor.getParent().sendAction(responseAction);
    }

    public static final String toID(MyRole myRole, QName operation) {
        if (myRole == null) {
            throw new IllegalArgumentException("myRole null");
        }
        if (operation == null) {
            throw new IllegalArgumentException("operation null");
        }
        RootComponent.ComponentName partner = ((ServiceReference)myRole).getParent().getReferencedComponentName();
        String role = ((ServiceReference)myRole).getRoleName();
        String action = null;
        Iterator itr = ((ServiceReference)myRole).getEndpointReferences();
        if (itr.hasNext()) {
            action = ((EndpointReference)itr.next()).getOperationReference(operation).getRequestAction().getAction();
        }
        if (action == null) {
            throw new IllegalStateException("Service " + ((ServiceReference)myRole).getReferencedComponentName() + " defines no endpoints.");
        }
        return partner + "%" + role + "%" + action;
    }

    public String getAction() {
        return this.eor.getRequestAction().getAction();
    }

    public String getID() {
        if (this.id == null) {
            this.id = this.getPartner() + "%" + this.getRole() + "%" + this.getAction();
        }
        return this.id;
    }

    public QName getPartner() {
        return this.eor.getParent().getParent().getParent().getReferencedComponentName();
    }

    public String getRole() {
        return this.eor.getParent().getParent().getRoleName();
    }

    private EndpointActionReference.ResponseActionReference getResponseActionReference(String action) {
        EndpointActionReference ear = this.eor.getParent().getEndpointActionReference(action);
        if (ear == null) {
            throw new IllegalArgumentException("Action '" + action + "' is undefined on interface " + this.intrface.getName() + ".");
        }
        if (!(ear instanceof EndpointActionReference.ResponseActionReference)) {
            throw new IllegalArgumentException("Action '" + action + "' defined on interface " + this.intrface.getName() + " maps to action with direction 'in'. Expected direction 'out'");
        }
        return (EndpointActionReference.ResponseActionReference)ear;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        Externalizer.writeString(out, this.relatesTo);
        Externalizer.writeQName(out, (QName)this.eor.getRootComponent().getName());
        Externalizer.writeQName(out, (QName)this.eor.getParent().getParent().getReferencedComponentName());
        Externalizer.writeString(out, this.eor.getParent().getEndpointName());
        Externalizer.writeQName(out, this.eor.getEndpointOperationName());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.relatesTo = Externalizer.readString(in);
        QName engineName = Externalizer.readQName(in);
        QName serviceName = Externalizer.readQName(in);
        String endpointName = Externalizer.readString(in);
        QName operationName = Externalizer.readQName(in);
        Engine engine = SystemContext.getContext().getSystem().getEngine(engineName);
        if (engine == null) {
            throw new IOException("Error unmarshalling MyOperation. Engine " + engineName + " is undefined.");
        }
        ServiceReference sr = engine.getRuntimeProvider().getServiceReference(serviceName);
        if (sr == null) {
            throw new IOException("Error unmarshalling MyOperation. ServiceReference " + serviceName + " is undefined on runtime Engine " + engineName + ".");
        }
        EndpointReference er = sr.getEndpointReference(endpointName);
        if (sr == null) {
            throw new IOException("Error unmarshalling MyOperation. EndpointReference '" + endpointName + " is undefined on ServiceReference " + serviceName + " defined on runtime Engine " + engineName + ".");
        }
        this.eor = er.getOperationReference(operationName);
        if (this.eor == null) {
            throw new IOException("Error unmarshalling MyOperation. EndpointOperationReference " + operationName + " is undefined on EndpointReference '" + endpointName + " is defined on ServiceReference " + serviceName + " defined on runtime Engine " + engineName + ".");
        }
        this.intrface = (Interface)this.eor.getEndpointOperation().getInterfaceOperation().getParent();
    }

    private static class Externalizer {
        private Externalizer() {
        }

        public static final void writeQName(ObjectOutput out, QName qName) throws IOException {
            Externalizer.writeString(out, qName.getNamespaceURI());
            Externalizer.writeString(out, qName.getLocalPart());
        }

        public static final QName readQName(ObjectInput in) throws IOException, ClassNotFoundException {
            String namespaceURI = Externalizer.readString(in);
            String localPart = Externalizer.readString(in);
            return new QName(namespaceURI, localPart);
        }

        public static final void writeString(ObjectOutput out, String string) throws IOException {
            if (string == null) {
                out.writeByte(0);
            } else {
                out.writeByte(1);
                out.writeObject(string);
            }
        }

        public static final String readString(ObjectInput in) throws IOException, ClassNotFoundException {
            if (in.readByte() == 0) {
                return null;
            }
            return (String)in.readObject();
        }
    }
}

