/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.specification.eoa.application.spring;

import javax.xml.namespace.QName;

import org.w3c.dom.Element;

/**
 * Models a fault thrown by a partner operation and declared on enclosing interface. Note that
 * undeclared faults thrown by a partner operation are converted to <code>SystemFault</code>.
 * <p>
 * Note that this exception is only relevant within context of a blocking partner invocation.
 * It is not used within context of the preferred, non-blocking partner invocation. See
 * examples.
 * 
 * @see PartnerOperation#sendRequest(Element)
 */
public class PartnerFault extends Exception {

    private static final long serialVersionUID = 1L;

    private QName faultName;
    private Element payload;

    public PartnerFault(QName faultName, Element payload) {
        this.faultName = faultName;
        this.payload = payload;
    }

    public QName getFaultName() {
        return faultName;
    }

    public Element getPayload() {
        return payload;
    }

}
