/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.specification.eoa.application.spring;

import javax.xml.namespace.QName;

public interface PartnerApplication {

    /**
     * Retrieves name of executable partner application, i.e. name of runtime engine instance
     * which implements application.
     * 
     * @return
     */
    public QName getName();

    /**
     * Retrieves a <code>PartnerRole</code> performed by partner application.
     * 
     * @param roleName
     * 
     * @return PartnerRole or <code>null</code> if role undefined.
     */
    public PartnerRole getPartnerRole(String roleName);

    /**
     * Convenience method for creating a partner MEP instance which can be used to
     * invoke partner operation.
     * 
     * @param roleName
     * @param operationName
     * @return
     */
    public PartnerOperation createPartnerOperation(String roleName, QName operationName);

}
