/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.specification.eoa.application.spring;

import javax.xml.namespace.QName;

import org.bluestemsoftware.specification.eoa.component.engine.rt.ServiceReference;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.transport.rt.TransportFault;

/**
 * Models 'role' performed by a partner service. Note, for access to the 'middleware' api,
 * <code>PartnerRole</code> can be cast to an instance of {@link ServiceReference}.
 */
public interface PartnerRole {

    /**
     * Gets name of partner role.
     * 
     * @return
     */
    public String getName();

    /**
     * Creates a MEP instance which can be used to invoke partner operation. Note that a
     * compliant <code>Engine</code> MUST invoke all endpoints defined on partner service
     * which implements role (in the order in which they are referenced) until request is
     * either 'accepted for processing' or until a non-transient error is encountered.
     * 
     * @param operationName
     * @return MEP instance
     * 
     * @see ServiceReference#getEndpointReferences()
     * @see TransportFault#TRANSPORT_ERROR
     */
    public PartnerOperation createOperation(QName operationName);

    /**
     * Creates a MEP instance which can be used to invoke partner operation. Note that this
     * method represents a 'leaky abstraction'. An application is an abstract component and
     * SHOULD NOT be concerned with, nor be aware of, concrete artifacts such as endpoints.
     * Specifying an 'endpointName' implies a binding preference, which effectively 'leaks'
     * binding semantics into the application layer.
     * 
     * @param operationName
     * @param endpointName
     * 
     * @return MEP instance
     */
    public PartnerOperation createOperation(String endpointName, QName operationName);

}
