/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.specification.eoa.application.spring;

import javax.xml.namespace.QName;

import org.bluestemsoftware.specification.eoa.ApplicationClassLoader;
import org.bluestemsoftware.specification.eoa.system.SystemContext;

/**
 * Models context within which 'my' application executes.
 */
public class MyApplicationContext {

    /**
     * Returns 'my' application instance.
     * 
     * @return MyApplication
     * @throws IllegalStateException
     *         if definition for engine not yet deployed.
     */
    public static MyApplication getApplication() {

        // we identify the requested engine using the thread context classloader
        // which must be application classloader (or a child of same, e.g. in
        // case we're invoked from within a web application, i.e. app classloader
        // may be parent)

        QName name = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (!(classLoader instanceof ApplicationClassLoader)) {
            while (classLoader.getParent() != null) {
                classLoader = classLoader.getParent();
                if (classLoader instanceof ApplicationClassLoader) {
                    break;
                }
            }
        }
        
        if (classLoader instanceof ApplicationClassLoader) {
            name = QName.valueOf(((ApplicationClassLoader)classLoader).getID());
        } else {
            throw new IllegalStateException("Expected context classloader (or parent of) assignable from "
                    + ApplicationClassLoader.class
                    + ", i.e. classloader for application implemented by requested engine.");
        }

        return (MyApplication)SystemContext.getContext().getSystem().getEngine(name).getRuntimeProvider();

    }

}
