/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.engine.spring;

import java.util.LinkedHashMap;

import javax.xml.namespace.QName;

import org.bluestemsoftware.open.eoa.engine.spring.SpringEngine.Provider;
import org.bluestemsoftware.specification.eoa.application.spring.MyApplication;
import org.bluestemsoftware.specification.eoa.application.spring.MyRole;
import org.bluestemsoftware.specification.eoa.application.spring.PartnerOperation;
import org.bluestemsoftware.specification.eoa.application.spring.PartnerRole;
import org.bluestemsoftware.specification.eoa.component.RootComponent.ComponentName;
import org.bluestemsoftware.specification.eoa.component.engine.rt.EndpointReference;
import org.bluestemsoftware.specification.eoa.component.engine.rt.ServiceReference;
import org.bluestemsoftware.specification.eoa.component.policy.rt.ElementPolicy;
import org.bluestemsoftware.specification.eoa.ext.ExtensionFactoryContext;

public final class SpringServiceReference extends ServiceReference implements MyRole, PartnerRole {

    public SpringServiceReference(ComponentName serviceName, boolean isMyService, ElementPolicy elementPolicy,
            LinkedHashMap<String, EndpointReference> endpointReferences) {
        super(serviceName, isMyService, elementPolicy, endpointReferences);
    }

     /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.application.spring10.api.MyRole#getMyApplication()
     */
    public MyApplication getMyApplication() {
        return (MyApplication)getRootComponent();
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.application.spring10.api.MyRole#getName()
     */
    public String getName() {
        return getRoleName();
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.application.spring.PartnerRole#createOperation(javax.xml.namespace.QName)
     */
    public PartnerOperation createOperation(QName operationName) {
        SpringEngine engine = (SpringEngine)getRootComponent();
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            ExtensionFactoryContext ctxt = engine.getExtensionFactory().getFactoryContext();
            thread.setContextClassLoader(ctxt.getClassLoader());
            return ((Provider)engine.getExtensionProvider()).spi_createOperation(this, operationName);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.application.spring.PartnerRole#createOperation(java.lang.String, javax.xml.namespace.QName)
     */
    public PartnerOperation createOperation(String endpointName, QName operationName) {
        SpringEngine engine = (SpringEngine)getRootComponent();
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            ExtensionFactoryContext ctxt = engine.getExtensionFactory().getFactoryContext();
            thread.setContextClassLoader(ctxt.getClassLoader());
            return ((Provider)engine.getExtensionProvider()).spi_createOperation(this, endpointName, operationName);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

}
