/*
 * Decompiled with CFR 0.152.
 */
package org.bluestemsoftware.open.eoa.engine.spring;

import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.bluestemsoftware.open.eoa.engine.spring.SpringEngineFactory;
import org.bluestemsoftware.open.eoa.engine.spring.SpringEngineReference;
import org.bluestemsoftware.specification.eoa.application.spring.MyApplication;
import org.bluestemsoftware.specification.eoa.application.spring.MyRole;
import org.bluestemsoftware.specification.eoa.application.spring.PartnerApplication;
import org.bluestemsoftware.specification.eoa.application.spring.PartnerOperation;
import org.bluestemsoftware.specification.eoa.component.RootComponent;
import org.bluestemsoftware.specification.eoa.component.engine.rt.EngineRT;
import org.bluestemsoftware.specification.eoa.component.engine.rt.EngineReference;
import org.bluestemsoftware.specification.eoa.component.engine.rt.ServiceReference;
import org.bluestemsoftware.specification.eoa.ext.engine.EngineFactory;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpringEngine
extends EngineRT
implements MyApplication {
    public static final String TYPE = "http://bluestemsoftware.org/open/eoa/engine/spring/1.0";
    public static final String PROVIDER_SCHEMA_LOCATION = "classpath:///schema/http.bluestemsoftware.org.open.eoa.engine.spring.1.0.xsd";
    private Set<String> requiredFeatures;

    public SpringEngine(SpringEngineFactory factory, Provider provider, RootComponent.ComponentName name, Map<QName, EngineReference> engineReferences, Set<String> requiredFeatures) {
        super((EngineFactory)factory, (EngineRT.Provider)provider, name, engineReferences);
        if (requiredFeatures == null) {
            throw new IllegalArgumentException("required features null");
        }
        this.requiredFeatures = requiredFeatures;
    }

    public Set<String> getRequiredApplicationFeatures() {
        return this.requiredFeatures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartnerApplication getPartner(QName engineName) {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader((ClassLoader)this.factory.getFactoryContext().getClassLoader());
            PartnerApplication partnerApplication = ((Provider)this.provider).spi_getPartner(engineName);
            return partnerApplication;
        }
        finally {
            thread.setContextClassLoader(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PartnerOperation createOperation(ServiceReference serviceReference, QName operationName) {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader((ClassLoader)this.factory.getFactoryContext().getClassLoader());
            PartnerOperation partnerOperation = ((Provider)this.provider).spi_createOperation(serviceReference, operationName);
            return partnerOperation;
        }
        finally {
            thread.setContextClassLoader(cl);
        }
    }

    protected EngineReference createMyEngineReference(Map<QName, ServiceReference> serviceReferences) {
        return new SpringEngineReference(this.componentName, serviceReferences, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PartnerOperation createOperation(ServiceReference serviceReference, String endpointName, QName operationName) {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader((ClassLoader)this.factory.getFactoryContext().getClassLoader());
            PartnerOperation partnerOperation = ((Provider)this.provider).spi_createOperation(serviceReference, endpointName, operationName);
            return partnerOperation;
        }
        finally {
            thread.setContextClassLoader(cl);
        }
    }

    public Object getBean(String name) {
        return this.getApplicationContext().getBean(name);
    }

    public MyRole getMyRole(String roleName) {
        return (MyRole)this.getEngineReference((QName)this.getName()).getServiceReference(roleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationContext getApplicationContext() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader((ClassLoader)this.factory.getFactoryContext().getClassLoader());
            ApplicationContext applicationContext = ((Provider)this.provider).spi_getApplicationContext();
            return applicationContext;
        }
        finally {
            thread.setContextClassLoader(cl);
        }
    }

    public static interface Provider
    extends EngineRT.Provider {
        public PartnerApplication spi_getPartner(QName var1);

        public PartnerOperation spi_createOperation(ServiceReference var1, QName var2);

        public PartnerOperation spi_createOperation(ServiceReference var1, String var2, QName var3);

        public ApplicationContext spi_getApplicationContext();
    }
}

