/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.engine.spring;

import java.util.LinkedHashMap;
import java.util.Map;

import javax.xml.namespace.QName;

import org.bluestemsoftware.specification.eoa.DeploymentException;
import org.bluestemsoftware.specification.eoa.component.RootComponent.ComponentName;
import org.bluestemsoftware.specification.eoa.component.engine.rt.EndpointReference;
import org.bluestemsoftware.specification.eoa.component.engine.rt.EngineReference;
import org.bluestemsoftware.specification.eoa.component.engine.rt.ServiceReference;
import org.bluestemsoftware.specification.eoa.component.policy.rt.ElementPolicy;

public class SpringEngineReference extends EngineReference {

    public SpringEngineReference(ComponentName arg0, Map<QName, ServiceReference> arg1, boolean arg2) {
        super(arg0, arg1, arg2);
    }
    
    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.component.engine.rt.EngineReference#createServiceReference(org.bluestemsoftware.specification.eoa.component.RootComponent.ComponentName, boolean, org.bluestemsoftware.specification.eoa.component.policy.rt.ElementPolicy, java.util.LinkedHashMap)
     */
    @Override
    protected ServiceReference createServiceReference(ComponentName arg0, boolean arg1, ElementPolicy arg2, LinkedHashMap<String, EndpointReference> arg3) throws DeploymentException {
        return new SpringServiceReference(arg0, arg1, arg2, arg3);
    }

}
