/*
 * Decompiled with CFR 0.152.
 */
package org.bluestemsoftware.open.eoa.engine.spring;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.bluestemsoftware.open.eoa.engine.spring.SpringEngine;
import org.bluestemsoftware.open.eoa.engine.spring.SpringEngineConfiguration;
import org.bluestemsoftware.open.eoa.engine.spring.SpringEngineReference;
import org.bluestemsoftware.open.eoa.engine.spring.SpringServiceReference;
import org.bluestemsoftware.specification.eoa.DeploymentException;
import org.bluestemsoftware.specification.eoa.Resource;
import org.bluestemsoftware.specification.eoa.component.ComponentContext;
import org.bluestemsoftware.specification.eoa.component.ComponentDeployment;
import org.bluestemsoftware.specification.eoa.component.RootComponent;
import org.bluestemsoftware.specification.eoa.component.engine.Engine;
import org.bluestemsoftware.specification.eoa.component.engine.rt.EndpointActionReference;
import org.bluestemsoftware.specification.eoa.component.engine.rt.EndpointOperationReference;
import org.bluestemsoftware.specification.eoa.component.engine.rt.EndpointReference;
import org.bluestemsoftware.specification.eoa.component.engine.rt.EngineRT;
import org.bluestemsoftware.specification.eoa.component.engine.rt.EngineReference;
import org.bluestemsoftware.specification.eoa.component.engine.rt.ServiceReference;
import org.bluestemsoftware.specification.eoa.component.policy.rt.ElementPolicy;
import org.bluestemsoftware.specification.eoa.ext.engine.EngineFactory;
import org.bluestemsoftware.specification.eoa.ext.policy.PolicyFactory;
import org.bluestemsoftware.specification.eoa.system.SystemContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpringEngineFactory
extends EngineFactory {
    public static final String SPRING_TNS = "http://www.springframework.org/schema/beans";
    public static final String SPRING_SCHEMA_LOC = "http://www.springframework.org/schema/beans/spring-beans-2.5.xsd";

    public String getExtensionType() {
        return "http://bluestemsoftware.org/open/eoa/engine/spring/1.0";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<EngineRT> readProviders(ComponentContext componentContext, DOMSource source) throws DeploymentException {
        if (componentContext == null) {
            throw new IllegalArgumentException("componentContext null");
        }
        if (source == null) {
            throw new IllegalArgumentException("source null");
        }
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            ComponentDeployment deployment;
            Engine engine;
            String schemaLocation;
            Document beanDefs;
            thread.setContextClassLoader((ClassLoader)this.factoryContext.getClassLoader());
            HashSet<EngineRT> providers = new HashSet<EngineRT>();
            this.validateDefinition(source);
            Element definition = (Element)source.getNode();
            RootComponent.ComponentName cname = RootComponent.ComponentName.valueOf((Node)definition, (String)definition.getAttribute("name"));
            String tns = definition.getNamespaceURI();
            QName childName = new QName(tns, "configuration");
            Element configuration = this.getChildElement(definition, childName);
            HashSet<String> requiredFeatures = new HashSet<String>();
            childName = new QName(tns, "features");
            Element featuresElement = this.getChildElement(configuration, childName);
            if (featuresElement != null) {
                childName = new QName(tns, "feature");
                List<Element> featureElements = this.getChildElements(featuresElement, childName);
                for (Element featureElement : featureElements) {
                    requiredFeatures.add(this.getText(featureElement));
                }
            }
            HashSet<SpringEngineConfiguration.ModuleInfo> moduleInfos = new HashSet<SpringEngineConfiguration.ModuleInfo>();
            childName = new QName(tns, "modules");
            Element modulesElement = this.getChildElement(configuration, childName);
            if (modulesElement != null) {
                childName = new QName(tns, "web");
                List<Element> moduleElements = this.getChildElements(modulesElement, childName);
                for (Element moduleElement : moduleElements) {
                    String ref = moduleElement.getAttribute("ref");
                    childName = new QName(tns, "rootContext");
                    Element rootContextElement = this.getChildElement(moduleElement, childName);
                    String rootContext = this.getText(rootContextElement);
                    moduleInfos.add(new SpringEngineConfiguration.WebModuleInfo(ref, rootContext));
                }
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            try {
                beanDefs = dbf.newDocumentBuilder().newDocument();
            }
            catch (ParserConfigurationException pe) {
                throw new DeploymentException("Error parsing provider definition. " + pe.getMessage());
            }
            Element child = this.getChildElement(configuration, new QName(SPRING_TNS, "beans"));
            beanDefs.appendChild(beanDefs.importNode(child, true));
            child = beanDefs.getDocumentElement();
            String xsi = "http://www.w3.org/2001/XMLSchema-instance";
            String xsiPrefix = child.lookupPrefix(xsi);
            if (xsiPrefix == null) {
                xsiPrefix = "xsi";
                child.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", xsiPrefix);
            }
            if ((schemaLocation = child.getAttributeNS(xsi, "schemaLocation")) == null) {
                child.setAttributeNS(xsi, xsiPrefix + ":schemaLocation", "http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-2.5.xsd");
            } else if (!schemaLocation.contains(SPRING_TNS)) {
                schemaLocation = schemaLocation + " " + SPRING_TNS + " " + SPRING_SCHEMA_LOC;
                child.setAttributeNS(xsi, xsiPrefix + ":schemaLocation", schemaLocation);
            }
            SpringEngineConfiguration spe = new SpringEngineConfiguration(moduleInfos, beanDefs);
            HashMap<QName, EngineReference> engineReferences = new HashMap<QName, EngineReference>();
            childName = new QName(tns, "partners");
            Element partnersElement = this.getChildElement(definition, childName);
            if (partnersElement != null) {
                childName = new QName(tns, "engineReference");
                List<Element> engineRefElements = this.getChildElements(partnersElement, childName);
                for (Element engineRefElement : engineRefElements) {
                    String prefixedName = engineRefElement.getAttribute("engineName");
                    RootComponent.ComponentName engineName = RootComponent.ComponentName.valueOf((Node)engineRefElement, (String)prefixedName);
                    boolean isMyEngine = engineName.equals((Object)cname);
                    HashMap<QName, ServiceReference> serviceReferences = new HashMap<QName, ServiceReference>();
                    childName = new QName(tns, "serviceReference");
                    List<Element> serviceRefElements = this.getChildElements(engineRefElement, childName);
                    for (Element serviceRefElement : serviceRefElements) {
                        prefixedName = serviceRefElement.getAttribute("serviceName");
                        RootComponent.ComponentName serviceName = RootComponent.ComponentName.valueOf((Node)serviceRefElement, (String)prefixedName);
                        ElementPolicy serviceEP = this.getElementPolicy(componentContext, serviceRefElement);
                        LinkedHashMap<String, EndpointReference> eprs = new LinkedHashMap<String, EndpointReference>();
                        childName = new QName(tns, "endpointReference");
                        List<Element> epElements = this.getChildElements(serviceRefElement, childName);
                        for (Element epElement : epElements) {
                            String endpointName = epElement.getAttribute("endpointName");
                            ElementPolicy endpointEP = this.getElementPolicy(componentContext, epElement);
                            HashMap<RootComponent.ComponentName, EndpointOperationReference> eors = new HashMap<RootComponent.ComponentName, EndpointOperationReference>();
                            childName = new QName(tns, "operationReference");
                            List<Element> operationElements = this.getChildElements(epElement, childName);
                            for (Element operationElement : operationElements) {
                                RootComponent.ComponentName operationName = RootComponent.ComponentName.valueOf((Node)operationElement, (String)operationElement.getAttribute("operationName"));
                                ElementPolicy operationEP = this.getElementPolicy(componentContext, operationElement);
                                HashMap<String, EndpointActionReference> ears = new HashMap<String, EndpointActionReference>();
                                childName = new QName(tns, "actionReference");
                                List<Element> actionElements = this.getChildElements(operationElement, childName);
                                for (Element actionElement : actionElements) {
                                    String action = actionElement.getAttribute("action");
                                    ElementPolicy messageEP = this.getElementPolicy(componentContext, actionElement);
                                    EndpointActionReference ear = new EndpointActionReference(action, messageEP);
                                    if (ears.containsKey(action)) {
                                        throw new DeploymentException("Failed to parse EndpointActionReference component '" + action + "' not unique within context of EndpointOperationReference '" + operationName + "'.");
                                    }
                                    ears.put(action, ear);
                                }
                                EndpointOperationReference eor = new EndpointOperationReference((QName)operationName, operationEP, ears);
                                if (eors.containsKey(operationName)) {
                                    throw new DeploymentException("Failed to parse EndpointOperationReference component. Name '" + operationName + "' not unique within context of EndpointReference '" + endpointName + "'.");
                                }
                                eors.put(operationName, eor);
                            }
                            EndpointReference epr = new EndpointReference(endpointName, endpointEP, eors);
                            if (eprs.containsKey(endpointName)) {
                                throw new DeploymentException("Failed to parse EndpointReference component. Name '" + endpointName + "' not unique within context of ServiceReference " + serviceName + "'.");
                            }
                            eprs.put(endpointName, epr);
                        }
                        boolean isMyService = isMyEngine;
                        SpringServiceReference serviceRef = new SpringServiceReference(serviceName, isMyService, serviceEP, eprs);
                        serviceReferences.put((QName)serviceName, serviceRef);
                    }
                    SpringEngineReference engineReference = new SpringEngineReference(engineName, serviceReferences, isMyEngine);
                    engineReferences.put((QName)engineName, engineReference);
                }
            }
            if ((engine = (Engine)(deployment = componentContext.getDeployment()).getComponent(RootComponent.ComponentType.ENGINE, (QName)cname)) == null) {
                throw new DeploymentException("Error loading runtime provider definition " + cname + ". Definition for corresponding RootComponent is undefined." + " Definition for instances of SingletonRT must be defined within" + " same deployment as corresponding RootComponent.");
            }
            File engineEtcDir = this.createEngineEtcDir(engine.getFragmentIdentifier());
            File engineVarDir = this.createEngineVarDir(engine.getFragmentIdentifier());
            SpringEngine.Provider p = ((Provider)this.provider).spi_createEngine(spe);
            providers.add(new SpringEngine(this, p, cname, engineReferences, requiredFeatures, engineEtcDir, engineVarDir));
            HashSet<EngineRT> hashSet = providers;
            return hashSet;
        }
        finally {
            thread.setContextClassLoader(cl);
        }
    }

    private ElementPolicy getElementPolicy(ComponentContext componentContext, Element parent) throws DeploymentException {
        Set factories = null;
        factories = SystemContext.getContext().getSystem().getPolicyFactories();
        ElementPolicy result = null;
        for (PolicyFactory factory : factories) {
            ElementPolicy temp = null;
            try {
                DOMSource source = new DOMSource(parent, parent.getOwnerDocument().getDocumentURI());
                temp = factory.readElementPolicy(componentContext, source);
            }
            catch (DeploymentException de) {
                throw new DeploymentException("Error reading element policy. " + de.getMessage());
            }
            if (result == null) {
                result = temp;
                continue;
            }
            throw new DeploymentException("Attached policy expressions MUST be identically typed.");
        }
        return result;
    }

    private Element getChildElement(Element parent, QName childName) {
        NodeList nodeList = parent.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            Element element = (Element)nodeList.item(i);
            if (!childName.getNamespaceURI().equals("") ? element.getNamespaceURI() == null || !childName.getNamespaceURI().equals("*") && !element.getNamespaceURI().equals(childName.getNamespaceURI()) : element.getNamespaceURI() != null) continue;
            if (!childName.getLocalPart().equals("*") && !element.getLocalName().equals(childName.getLocalPart())) continue;
            return element;
        }
        return null;
    }

    private List<Element> getChildElements(Element parent, QName childName) {
        ArrayList<Element> answer = new ArrayList<Element>();
        NodeList nodeList = parent.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            Element element = (Element)nodeList.item(i);
            if (!childName.getNamespaceURI().equals("") ? element.getNamespaceURI() == null || !childName.getNamespaceURI().equals("*") && !element.getNamespaceURI().equals(childName.getNamespaceURI()) : element.getNamespaceURI() != null) continue;
            if (!childName.getLocalPart().equals("*") && !element.getLocalName().equals(childName.getLocalPart())) continue;
            answer.add(element);
        }
        return answer;
    }

    private String getText(Element element) {
        if (element == null || !element.hasChildNodes()) {
            return null;
        }
        try {
            Text textNode = (Text)element.getFirstChild();
            return textNode.getData();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    private void validateDefinition(DOMSource source) throws DeploymentException {
        String validationError;
        Resource resource = null;
        try {
            resource = this.factoryContext.getResource("classpath:///schema/http.bluestemsoftware.org.open.eoa.engine.spring.1.0.xsd");
        }
        catch (DeploymentException de) {
            throw new DeploymentException("Error validating definition. " + (Object)((Object)de));
        }
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = null;
        try {
            schema = schemaFactory.newSchema(new StreamSource(resource.getInputStream()));
        }
        catch (Exception ex) {
            throw new DeploymentException("Error parsing schema. " + ex);
        }
        DOMValidator domValidator = new DOMValidator(schema);
        try {
            validationError = domValidator.validate(source);
        }
        catch (Exception ex) {
            throw new DeploymentException("Error validating definition. " + ex);
        }
        if (validationError != null) {
            throw new DeploymentException("Engine definition invalid. " + validationError);
        }
    }

    static final class DOMValidator {
        private Schema schema;

        public DOMValidator(Schema schema) {
            this.schema = schema;
        }

        public String validate(DOMSource source) throws SAXException, IOException {
            Validator validator = this.schema.newValidator();
            validator.setErrorHandler(new ErrorHandlerImpl());
            validator.validate(source);
            return ((ErrorHandlerImpl)validator.getErrorHandler()).getErrors();
        }

        static class ErrorHandlerImpl
        implements ErrorHandler {
            private ArrayList<String> errorMessages = new ArrayList();

            ErrorHandlerImpl() {
            }

            public void error(SAXParseException spe) throws SAXException {
                this.errorMessages.add(spe.getMessage());
            }

            public void warning(SAXParseException spe) throws SAXException {
                this.errorMessages.add(spe.getMessage());
            }

            public void fatalError(SAXParseException spe) throws SAXException {
                this.errorMessages.add(spe.getMessage());
            }

            public String getErrors() {
                if (this.errorMessages.size() > 0) {
                    Iterator<String> messageIterator = this.errorMessages.iterator();
                    StringBuilder errorMessage = new StringBuilder();
                    while (messageIterator.hasNext()) {
                        errorMessage.append(messageIterator.next() + "  ");
                    }
                    return errorMessage.toString();
                }
                return null;
            }
        }
    }

    public static interface Provider
    extends EngineFactory.Provider {
        public SpringEngine.Provider spi_createEngine(SpringEngineConfiguration var1);
    }
}

