/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.engine.spring;

import java.util.Set;

import org.w3c.dom.Document;

public final class SpringEngineConfiguration {

    private Set<ModuleInfo> moduleInfos;
    private Document beanDefinitions;

    public SpringEngineConfiguration(Set<ModuleInfo> moduleInfos,
            Document beanDefinitions) {
        this.moduleInfos = moduleInfos;
        this.beanDefinitions = beanDefinitions;
    }

    public Document getBeanDefinitions() {
        return beanDefinitions;
    }

    public Set<ModuleInfo> getModuleInfos() {
        return moduleInfos;
    }

    public interface ModuleInfo {
    }

    public static class WebModuleInfo implements ModuleInfo {

        private String ref;
        private String rootContext;

        public WebModuleInfo(String ref, String rootContext) {
            this.ref = ref;
            this.rootContext = rootContext;
        }

        public String getRef() {
            return ref;
        }

        public String getRootContext() {
            return rootContext;
        }

    }

}
