/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.feature.jms.server.activemq.mgmt.jmx;

import java.io.IOException;

import org.apache.activemq.broker.jmx.ManagementContext;
import org.bluestemsoftware.specification.eoa.ext.feature.jms.server.JMSServerFeature;
import org.bluestemsoftware.specification.eoa.ext.feature.jmx.server.JMXServerFeature;

public class ManagementContextImpl extends ManagementContext {

    public ManagementContextImpl(JMSServerFeature jmsServerFeature, JMXServerFeature jmxServerFeature) {
        super(new MBeanServerProxy(jmsServerFeature, jmxServerFeature));
    }

    @Override
    public void start() throws IOException {
        return;
    }

    @Override
    public void stop() throws IOException {
        return;
    }
    
    @Override
    public String getJmxDomainName() {
        return "org.bluestemsoftware.open.eoa";
    }
    
}
