/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.feature.jms.server.activemq.mgmt.jmx;

import java.util.List;
import java.util.Map;

import javax.jms.InvalidSelectorException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;

import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.bluestemsoftware.specification.eoa.ext.ExtensionFactoryContext;

public class Queue implements QueueMBean {

    private QueueViewMBean underlying;
    private ExtensionFactoryContext factoryContext;

    public Queue(ExtensionFactoryContext factoryContext, QueueViewMBean underlying) {
        this.factoryContext = factoryContext;
        this.underlying = underlying;
    }

    public int copyMatchingMessagesTo(String selector, String destinationName) throws Exception {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.copyMatchingMessagesTo(selector, destinationName);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public int copyMatchingMessagesTo(String selector, String destinationName, int maximumMessages) throws Exception {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.copyMatchingMessagesTo(selector, destinationName, maximumMessages);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public boolean copyMessageTo(String messageId, String destinationName) throws Exception {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.copyMessageTo(messageId, destinationName);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public CompositeData getMessage(String messageId) throws OpenDataException {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getMessage(messageId);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public int moveMatchingMessagesTo(String selector, String destinationName) throws Exception {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.moveMatchingMessagesTo(selector, destinationName);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public int moveMatchingMessagesTo(String selector, String destinationName, int maximumMessages) throws Exception {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.moveMatchingMessagesTo(selector, destinationName, maximumMessages);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public boolean moveMessageTo(String messageId, String destinationName) throws Exception {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.moveMessageTo(messageId, destinationName);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public void purge() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.purge();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public int removeMatchingMessages(String selector) throws Exception {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.removeMatchingMessages(selector);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public int removeMatchingMessages(String selector, int maximumMessages) throws Exception {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.removeMatchingMessages(selector, maximumMessages);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public boolean removeMessage(String messageId) throws Exception {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.removeMessage(messageId);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public CompositeData[] browse() throws OpenDataException {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.browse();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public CompositeData[] browse(String selector) throws OpenDataException, InvalidSelectorException {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.browse(selector);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public TabularData browseAsTable() throws OpenDataException {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.browseAsTable();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public TabularData browseAsTable(String selector) throws OpenDataException, InvalidSelectorException {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.browseAsTable(selector);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public List<?> browseMessages() throws InvalidSelectorException {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.browseMessages();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public List<?> browseMessages(String selector) throws InvalidSelectorException {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.browseMessages(selector);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public long getConsumerCount() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getConsumerCount();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public long getDequeueCount() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getDequeueCount();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public long getDispatchCount() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getDispatchCount();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public long getEnqueueCount() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getEnqueueCount();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public long getMemoryLimit() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getMemoryLimit();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public int getMemoryPercentageUsed() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getMemoryPercentageUsed();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public String getName() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getName();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public long getQueueSize() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getQueueSize();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public void resetStatistics() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.resetStatistics();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public String sendTextMessage(String body) throws Exception {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.sendTextMessage(body);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    @SuppressWarnings("unchecked")
    public String sendTextMessage(Map headers, String body) throws Exception {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.sendTextMessage(headers, body);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public void setMemoryLimit(long limit) {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.setMemoryLimit(limit);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

}
