/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.feature.jms.server.activemq.util;

import java.net.URI;

import javax.jms.JMSException;

import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ThreadPriorities;

public class ActiveMQConnectionFactoryImpl extends ActiveMQConnectionFactory {

    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_NAME = "ActiveMQ Session Task";
    private static final int DEFAULT_PRIORITY = ThreadPriorities.INBOUND_CLIENT_SESSION;

    public ActiveMQConnectionFactoryImpl() {
        super();
    }

    public ActiveMQConnectionFactoryImpl(String userName, String password, String brokerURL) {
        super(userName, password, brokerURL);
    }

    public ActiveMQConnectionFactoryImpl(String userName, String password, URI brokerURL) {
        super(userName, password, brokerURL);
    }

    public ActiveMQConnectionFactoryImpl(String brokerURL) {
        super(brokerURL);
    }

    public ActiveMQConnectionFactoryImpl(URI brokerURL) {
        super(brokerURL);
    }

    @Override
    protected ActiveMQConnection createActiveMQConnection(String userName, String password) throws JMSException {
        ActiveMQConnection c = super.createActiveMQConnection(userName, password);
        c.setSessionTaskRunner(new TaskRunnerFactoryImpl(DEFAULT_NAME, DEFAULT_PRIORITY, true, 1000));
        return c;
    }

}
