/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.feature.jms.server.activemq.mgmt.jmx;

import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;

import org.apache.activemq.broker.jmx.BrokerViewMBean;
import org.apache.activemq.broker.jmx.ConnectionViewMBean;
import org.apache.activemq.broker.jmx.ConnectorViewMBean;
import org.apache.activemq.broker.jmx.FTConnectorViewMBean;
import org.apache.activemq.broker.jmx.JmsConnectorViewMBean;
import org.apache.activemq.broker.jmx.NetworkConnectorViewMBean;
import org.apache.activemq.broker.jmx.ProxyConnectorViewMBean;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.broker.jmx.SubscriptionViewMBean;
import org.apache.activemq.broker.jmx.TopicViewMBean;
import org.bluestemsoftware.specification.eoa.ext.ExtensionFactoryContext;
import org.bluestemsoftware.specification.eoa.ext.feature.jms.server.JMSServerFeature;
import org.bluestemsoftware.specification.eoa.ext.feature.jmx.server.JMXServerFeature;
import org.bluestemsoftware.specification.eoa.ext.feature.jmx.server.JMXServerFeatureException;

public class MBeanServerProxy implements MBeanServer {

    private JMSServerFeature jmsServerFeature;
    private JMXServerFeature jmxServerFeature;
    private Map<ObjectName, ObjectName> transformedNames = new HashMap<ObjectName, ObjectName>();

    public MBeanServerProxy(JMSServerFeature jmsServerFeature, JMXServerFeature jmxServerFeature) {
        this.jmsServerFeature = jmsServerFeature;
        this.jmxServerFeature = jmxServerFeature;
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
    }

    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return null;
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return null;
    }

    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return null;
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return null;
    }

    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws InstanceNotFoundException, OperationsException {
        return null;
    }

    public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        return null;
    }

    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws InstanceNotFoundException, OperationsException, ReflectionException {
        return null;
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        return null;
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        return null;
    }

    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        return null;
    }

    public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        return null;
    }

    public ClassLoaderRepository getClassLoaderRepository() {
        return null;
    }

    public String getDefaultDomain() {
        return null;
    }

    public String[] getDomains() {
        return null;
    }

    public Integer getMBeanCount() {
        return null;
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        return null;
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        return null;
    }

    public Object instantiate(String className) throws ReflectionException, MBeanException {
        return null;
    }

    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return null;
    }

    public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        return null;
    }

    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return null;
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        return null;
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        return false;
    }

    public boolean isRegistered(ObjectName name) {
        return false;
    }

    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) {
        return null;
    }

    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
        return null;
    }

    public synchronized ObjectInstance registerMBean(Object mbean, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {

        ExtensionFactoryContext factoryContext = jmsServerFeature.getExtensionFactory().getFactoryContext();

        String type = null;
        String name = null;
        Object mbeanDelegate = null;
        if (mbean instanceof BrokerViewMBean) {
            name = "Broker";
            mbeanDelegate = new Broker(factoryContext, (BrokerViewMBean)mbean);
        } else if (mbean instanceof ConnectionViewMBean) {
            type = "Connection";
            name = objectName.getKeyProperty("ConnectionName");
            mbeanDelegate = new Connection(factoryContext, (ConnectionViewMBean)mbean);
        } else if (mbean instanceof ConnectorViewMBean) {
            type = "Connector";
            name = objectName.getKeyProperty("ConnectorName");
            mbeanDelegate = new Connector(factoryContext, (ConnectorViewMBean)mbean);
        } else if (mbean instanceof FTConnectorViewMBean) {
            type = "Connector";
            name = objectName.getKeyProperty("ConnectorName");
            mbeanDelegate = new FTConnector(factoryContext, (FTConnectorViewMBean)mbean);
        } else if (mbean instanceof JmsConnectorViewMBean) {
            type = "Connector";
            name = objectName.getKeyProperty("ConnectorName");
            mbeanDelegate = new JMSConnector(factoryContext, (JmsConnectorViewMBean)mbean);
        } else if (mbean instanceof NetworkConnectorViewMBean) {
            type = "NetworkConnector";
            name = objectName.getKeyProperty("NetworkConnectorName");
            mbeanDelegate = new NetworkConnector(factoryContext, (NetworkConnectorViewMBean)mbean);
        } else if (mbean instanceof ProxyConnectorViewMBean) {
            type = "Connector";
            name = objectName.getKeyProperty("ConnectorName");
            mbeanDelegate = new ProxyConnector(factoryContext, (ProxyConnectorViewMBean)mbean);
        } else if (mbean instanceof QueueViewMBean) {
            type = "Queue";
            name = objectName.getKeyProperty("Destination");
            mbeanDelegate = new Queue(factoryContext, (QueueViewMBean)mbean);
        } else if (mbean instanceof SubscriptionViewMBean) {
            type = "Subscription";
            name = objectName.getKeyProperty("destinationName");
            mbeanDelegate = new Subscription(factoryContext, (SubscriptionViewMBean)mbean);
        } else if (mbean instanceof TopicViewMBean) {
            type = "Topic";
            name = objectName.getKeyProperty("Destination");
            mbeanDelegate = new Topic(factoryContext, (TopicViewMBean)mbean);
        } else {
            throw new IllegalStateException("No proxy defined for mbean " + mbean.getClass().getName());
        }
        ObjectName transformedName = null;
        try {
            transformedName = jmxServerFeature.registerMBean(jmsServerFeature, mbeanDelegate, type, name);
        } catch (JMXServerFeatureException je) {
            throw new MBeanRegistrationException(je);
        }
        transformedNames.put(objectName, transformedName);
        return new ObjectInstance(objectName, mbean.getClass().getName());
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        return null;
    }

    public synchronized void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        ObjectName transformedName = transformedNames.get(name);
        if (transformedName != null) {
            try {
                jmxServerFeature.unRegisterMBean(transformedName);
                transformedNames.remove(name);
            } catch (JMXServerFeatureException je) {
                throw new MBeanRegistrationException(je);
            }
        }
    }

}
