/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.feature.jms.server.activemq;

import java.util.Set;

import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Queue;

import org.apache.activemq.command.ActiveMQQueue;
import org.bluestemsoftware.open.eoa.ext.feature.jms.server.activemq.mgmt.JMSServer;
import org.bluestemsoftware.open.eoa.ext.feature.jms.server.activemq.util.ActiveMQConnectionFactoryImpl;
import org.bluestemsoftware.open.eoa.ext.feature.jms.server.activemq.util.ActiveMQXAConnectionFactoryImpl;
import org.bluestemsoftware.specification.eoa.ext.Extension;
import org.bluestemsoftware.specification.eoa.ext.ExtensionFactoryContext;
import org.bluestemsoftware.specification.eoa.ext.feature.FeatureException;
import org.bluestemsoftware.specification.eoa.ext.feature.jms.server.JMSServerFeature;
import org.bluestemsoftware.specification.eoa.ext.management.jmx.JMXServerContext;
import org.bluestemsoftware.specification.eoa.system.ManagementContext;
import org.bluestemsoftware.specification.eoa.system.SystemContext;
import org.bluestemsoftware.specification.eoa.system.System.Log;

public final class JMSServerFeatureImpl implements JMSServerFeature.Provider {

    private static final Log log = SystemContext.getContext().getSystem().getLog(JMSServerFeature.class);
    private ExtensionFactoryContext factoryContext;
    private JMSServerFeature consumer;
    private JMSServer jmsServer = new JMSServer();

    public static final String IMPL = JMSServerFeatureImpl.class.getName();

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.Extension$Provider#spi_setConsumer(org.bluestemsoftware.specification.eoa.ext.Extension.Consumer)
     */
    public void spi_setConsumer(Extension consumer) {
        this.consumer = (JMSServerFeature)consumer;
        this.factoryContext = consumer.getExtensionFactory().getFactoryContext();
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.feature.jms.server.JMSServerFeature$Provider#spi_getPort()
     */
    public int spi_getPort() {
        return jmsServer.getPort();
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.feature.jms.server.JMSServerFeature$Provider#spi_getEmbeddedConnectionFactory(boolean)
     */
    public ConnectionFactory spi_getEmbeddedConnectionFactory(boolean isXA) {
        String brokerName = jmsServer.getEmbeddedBroker().getBrokerName();
        ConnectionFactory connectionFactory;
        if (isXA) {
            connectionFactory = new ActiveMQXAConnectionFactoryImpl("vm://" + brokerName);
        } else {
            connectionFactory = new ActiveMQConnectionFactoryImpl("vm://" + brokerName);
        }
        return connectionFactory;
    }
    
    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.feature.jms.server.JMSServerFeature$Provider#spi_createQueue(java.lang.String)
     */
    public Queue spi_createQueue(String name) throws JMSException {
        return new ActiveMQQueue(name);
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.system.server.Feature.Provider#spi_destroy()
     */
    public void spi_destroy() {
        log.debug("shutting down embedded server");
        jmsServer.shutdown();
        log.debug("embedded server shutdown");
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.system.server.Feature$Provider#spi_getFeatureImpl()
     */
    public String spi_getFeatureImpl() {
        return IMPL;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.system.server.Feature.Provider#spi_init(java.util.Set)
     */
    public void spi_init(Set<ManagementContext> managementContexts) throws FeatureException {
        log.debug("starting embedded activemq jms server");
        JMXServerContext jmxServerContext = null;
        for (ManagementContext managementContext : managementContexts) {
            if (managementContext instanceof JMXServerContext) {
                jmxServerContext = (JMXServerContext)jmxServerContext;
                break;
            }
        }
        jmsServer.start(factoryContext, consumer, jmxServerContext);
        log.debug("embedded server started");
    }

}
