/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.feature.jms.server.activemq.mgmt.jmx;

import org.apache.activemq.broker.jmx.JmsConnectorViewMBean;
import org.bluestemsoftware.specification.eoa.ext.ExtensionFactoryContext;

public class JMSConnector implements JMSConnectorMBean {
    
    private JmsConnectorViewMBean underlying;
    private ExtensionFactoryContext factoryContext;

    public JMSConnector(ExtensionFactoryContext factoryContext, JmsConnectorViewMBean underlying) {
        this.factoryContext = factoryContext;
        this.underlying = underlying;
    }

    public void start() throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.start();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public void stop() throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.stop();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }
    
    
    
}
