/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.feature.jms.server.activemq.mgmt.jmx;

import javax.management.ObjectName;

import org.apache.activemq.broker.jmx.BrokerViewMBean;
import org.bluestemsoftware.specification.eoa.ext.ExtensionFactoryContext;

public class Broker implements BrokerMBean {

    private BrokerViewMBean underlying;
    private ExtensionFactoryContext factoryContext;

    public Broker(ExtensionFactoryContext factoryContext, BrokerViewMBean underlying) {
        this.factoryContext = factoryContext;
        this.underlying = underlying;
    }

    public void addQueue(String name) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.addQueue(name);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public void addTopic(String name) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.addTopic(name);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public ObjectName createDurableSubscriber(String clientId, String subscriberName, String topicName, String selector) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.createDurableSubscriber(clientId, subscriberName, topicName, selector);
        } finally {
            thread.setContextClassLoader(cl);
        }

    }

    public void destroyDurableSubscriber(String clientId, String subscriberName) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.destroyDurableSubscriber(clientId, subscriberName);
        } finally {
            thread.setContextClassLoader(cl);
        }

    }

    public void gc() throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.gc();
        } finally {
            thread.setContextClassLoader(cl);
        }

    }

    public String getBrokerId() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getBrokerId();
        } finally {
            thread.setContextClassLoader(cl);
        }

    }

    public ObjectName[] getDurableTopicSubscribers() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getDurableTopicSubscribers();
        } finally {
            thread.setContextClassLoader(cl);
        }

    }

    public ObjectName[] getInactiveDurableTopicSubscribers() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getInactiveDurableTopicSubscribers();
        } finally {
            thread.setContextClassLoader(cl);
        }

    }

    public long getMemoryLimit() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getMemoryLimit();
        } finally {
            thread.setContextClassLoader(cl);
        }

    }

    public ObjectName[] getQueueSubscribers() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getQueueSubscribers();
        } finally {
            thread.setContextClassLoader(cl);
        }

    }

    public ObjectName[] getQueues() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getQueues();
        } finally {
            thread.setContextClassLoader(cl);
        }

    }

    public ObjectName[] getTemporaryQueueSubscribers() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getTemporaryQueueSubscribers();
        } finally {
            thread.setContextClassLoader(cl);
        }

    }

    public ObjectName[] getTemporaryQueues() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getTemporaryQueues();
        } finally {
            thread.setContextClassLoader(cl);
        }

    }

    public ObjectName[] getTemporaryTopicSubscribers() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getTemporaryTopicSubscribers();
        } finally {
            thread.setContextClassLoader(cl);
        }

    }

    public ObjectName[] getTemporaryTopics() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getTemporaryTopics();
        } finally {
            thread.setContextClassLoader(cl);
        }

    }

    public ObjectName[] getTopicSubscribers() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getTopicSubscribers();
        } finally {
            thread.setContextClassLoader(cl);
        }

    }

    public ObjectName[] getTopics() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getTopics();
        } finally {
            thread.setContextClassLoader(cl);
        }

    }

    public long getTotalConsumerCount() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getTotalConsumerCount();
        } finally {
            thread.setContextClassLoader(cl);
        }

    }

    public long getTotalDequeueCount() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getTotalDequeueCount();
        } finally {
            thread.setContextClassLoader(cl);
        }

    }

    public long getTotalEnqueueCount() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getTotalEnqueueCount();
        } finally {
            thread.setContextClassLoader(cl);
        }

    }

    public long getTotalMessageCount() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getTotalMessageCount();
        } finally {
            thread.setContextClassLoader(cl);
        }

    }

    public void removeQueue(String name) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.removeQueue(name);
        } finally {
            thread.setContextClassLoader(cl);
        }

    }

    public void removeTopic(String name) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.removeTopic(name);
        } finally {
            thread.setContextClassLoader(cl);
        }

    }

    public void resetStatistics() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.resetStatistics();
        } finally {
            thread.setContextClassLoader(cl);
        }

    }

    public void setMemoryLimit(long limit) {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.setMemoryLimit(limit);
        } finally {
            thread.setContextClassLoader(cl);
        }

    }

    public void stop() throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.stop();
        } finally {
            thread.setContextClassLoader(cl);
        }

    }

    public void terminateJVM(int exitCode) {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.terminateJVM(exitCode);
        } finally {
            thread.setContextClassLoader(cl);
        }

    }

    public void start() throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.start();
        } finally {
            thread.setContextClassLoader(cl);
        }

    }

    public String addConnector(String discoveryAddress) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.addConnector(discoveryAddress);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public String addNetworkConnector(String discoveryAddress) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.addNetworkConnector(discoveryAddress);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public void disableStatistics() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.disableStatistics();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public void enableStatistics() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.enableStatistics();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public String getBrokerName() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getBrokerName();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public int getMemoryPercentUsage() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getMemoryPercentUsage();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public long getStoreLimit() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getStoreLimit();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public int getStorePercentUsage() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getStorePercentUsage();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public long getTempLimit() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getTempLimit();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public int getTempPercentUsage() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getTempPercentUsage();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public boolean isPersistent() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.isPersistent();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public boolean isSlave() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.isSlave();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public boolean isStatisticsEnabled() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.isStatisticsEnabled();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public void reloadLog4jProperties() throws Throwable {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.reloadLog4jProperties();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public boolean removeConnector(String connectorName) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.removeConnector(connectorName);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public boolean removeNetworkConnector(String connectorName) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.removeNetworkConnector(connectorName);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public void setStoreLimit(long limit) {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.setStoreLimit(limit);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public void setTempLimit(long limit) {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.setTempLimit(limit);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public String getDataDirectory() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getDataDirectory();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public String getOpenWireURL() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getOpenWireURL();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public String getSslURL() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getSslURL();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public String getStompSslURL() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getStompSslURL();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public String getStompURL() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getStompURL();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public String getVMURL() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getVMURL();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public void stopGracefully(String arg0, String arg1, long arg2, long arg3) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.stopGracefully(arg0, arg1, arg2, arg3);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

}
