/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.feature.jms.server.activemq.mgmt.jmx;

import org.apache.activemq.broker.jmx.ConnectionViewMBean;
import org.bluestemsoftware.specification.eoa.ext.ExtensionFactoryContext;

public class Connection implements ConnectionMBean {

    private ConnectionViewMBean underlying;
    private ExtensionFactoryContext factoryContext;

    public Connection(ExtensionFactoryContext factoryContext, ConnectionViewMBean underlying) {
        this.factoryContext = factoryContext;
        this.underlying = underlying;
    }
    
    public String getRemoteAddress() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getRemoteAddress();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public boolean isActive() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.isActive();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public boolean isBlocked() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.isBlocked();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public boolean isConnected() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.isConnected();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public boolean isSlow() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.isSlow();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public void resetStatistics() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.resetStatistics();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public void start() throws Exception {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.start();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public void stop() throws Exception {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.stop();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

}
