/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.feature.jms.server.activemq.mgmt.jmx;

import org.apache.activemq.broker.jmx.NetworkConnectorViewMBean;
import org.bluestemsoftware.specification.eoa.ext.ExtensionFactoryContext;

public class NetworkConnector implements NetworkConnectorMBean {
    
    private NetworkConnectorViewMBean underlying;
    private ExtensionFactoryContext factoryContext;

    public NetworkConnector(ExtensionFactoryContext factoryContext, NetworkConnectorViewMBean underlying) {
        this.factoryContext = factoryContext;
        this.underlying = underlying;
    }

    public void start() throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.start();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public void stop() throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.stop();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public String getName() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getName();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public int getNetworkTTL() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getNetworkTTL();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public String getPassword() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getPassword();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public int getPrefetchSize() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getPrefetchSize();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public String getUserName() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getUserName();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public boolean isBridgeTempDestinations() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.isBridgeTempDestinations();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public boolean isConduitSubscriptions() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.isConduitSubscriptions();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public boolean isDecreaseNetworkConsumerPriority() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.isDecreaseNetworkConsumerPriority();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public boolean isDispatchAsync() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.isDispatchAsync();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public boolean isDuplex() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.isDuplex();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public boolean isDynamicOnly() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.isDynamicOnly();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public void setBridgeTempDestinations(boolean bridgeTempDestinations) {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.setBridgeTempDestinations(bridgeTempDestinations);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public void setConduitSubscriptions(boolean conduitSubscriptions) {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.setConduitSubscriptions(conduitSubscriptions);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public void setDecreaseNetworkConsumerPriority(boolean decreaseNetworkConsumerPriority) {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.setDecreaseNetworkConsumerPriority(decreaseNetworkConsumerPriority);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public void setDispatchAsync(boolean dispatchAsync) {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.setDispatchAsync(dispatchAsync);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public void setDynamicOnly(boolean dynamicOnly) {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.setDynamicOnly(dynamicOnly);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public void setNetworkTTL(int networkTTL) {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.setNetworkTTL(networkTTL);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public void setPassword(String password) {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.setPassword(password);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public void setPrefetchSize(int prefetchSize) {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.setPrefetchSize(prefetchSize);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public void setUserName(String userName) {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.setUserName(userName);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    
 
    
}
