/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.feature.jms.server.activemq.mgmt.jmx;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import javax.jms.InvalidSelectorException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;

import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.bluestemsoftware.specification.eoa.ext.ExtensionFactoryContext;

public class Queue implements QueueMBean {

    private QueueViewMBean underlying;
    private ExtensionFactoryContext factoryContext;

    public Queue(ExtensionFactoryContext factoryContext, QueueViewMBean underlying) {
        this.factoryContext = factoryContext;
        this.underlying = underlying;
    }

    public int copyMatchingMessagesTo(String selector, String destinationName) throws Exception {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.copyMatchingMessagesTo(selector, destinationName);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public int copyMatchingMessagesTo(String selector, String destinationName, int maximumMessages) throws Exception {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.copyMatchingMessagesTo(selector, destinationName, maximumMessages);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public boolean copyMessageTo(String messageId, String destinationName) throws Exception {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.copyMessageTo(messageId, destinationName);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public CompositeData getMessage(String messageId) throws OpenDataException {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getMessage(messageId);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public int moveMatchingMessagesTo(String selector, String destinationName) throws Exception {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.moveMatchingMessagesTo(selector, destinationName);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public int moveMatchingMessagesTo(String selector, String destinationName, int maximumMessages) throws Exception {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.moveMatchingMessagesTo(selector, destinationName, maximumMessages);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public boolean moveMessageTo(String messageId, String destinationName) throws Exception {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.moveMessageTo(messageId, destinationName);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public int removeMatchingMessages(String selector) throws Exception {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.removeMatchingMessages(selector);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public int removeMatchingMessages(String selector, int maximumMessages) throws Exception {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.removeMatchingMessages(selector, maximumMessages);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public boolean removeMessage(String messageId) throws Exception {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.removeMessage(messageId);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public CompositeData[] browse() throws OpenDataException {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.browse();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public CompositeData[] browse(String selector) throws OpenDataException, InvalidSelectorException {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.browse(selector);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public TabularData browseAsTable() throws OpenDataException {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.browseAsTable();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public TabularData browseAsTable(String selector) throws OpenDataException, InvalidSelectorException {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.browseAsTable(selector);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public List<?> browseMessages() throws InvalidSelectorException {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.browseMessages();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public List<?> browseMessages(String selector) throws InvalidSelectorException {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.browseMessages(selector);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public long getConsumerCount() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getConsumerCount();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public long getDequeueCount() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getDequeueCount();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public long getDispatchCount() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getDispatchCount();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public long getEnqueueCount() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getEnqueueCount();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public long getMemoryLimit() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getMemoryLimit();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public String getName() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getName();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public long getQueueSize() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getQueueSize();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public void resetStatistics() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.resetStatistics();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public String sendTextMessage(String body) throws Exception {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.sendTextMessage(body);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public void setMemoryLimit(long limit) {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.setMemoryLimit(limit);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public int cursorSize() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.cursorSize();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public boolean doesCursorHaveMessagesBuffered() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.doesCursorHaveMessagesBuffered();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public boolean doesCursorHaveSpace() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.doesCursorHaveSpace();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public long getCursorMemoryUsage() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getCursorMemoryUsage();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public int getCursorPercentUsage() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getCursorPercentUsage();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public boolean isCursorFull() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.isCursorFull();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public boolean retryMessage(String messageId) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.retryMessage(messageId);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public double getAverageEnqueueTime() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getAverageEnqueueTime();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public long getInFlightCount() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getInFlightCount();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public int getMaxAuditDepth() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getMaxAuditDepth();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public long getMaxEnqueueTime() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getMaxEnqueueTime();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public int getMaxPageSize() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getMaxPageSize();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public int getMaxProducersToAudit() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getMaxProducersToAudit();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public int getMemoryPercentUsage() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getMemoryPercentUsage();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public float getMemoryUsagePortion() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getMemoryUsagePortion();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public long getMinEnqueueTime() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getMinEnqueueTime();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public long getProducerCount() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getProducerCount();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public ObjectName[] getSubscriptions() throws IOException, MalformedObjectNameException {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getSubscriptions();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public boolean isProducerFlowControl() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.isProducerFlowControl();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public boolean isUseCache() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.isUseCache();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public String sendTextMessage(String body, String user, String password) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.sendTextMessage(body, user, password);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public void setMaxAuditDepth(int maxAuditDepth) {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.setMaxAuditDepth(maxAuditDepth);
        } finally {
            thread.setContextClassLoader(cl);
        }     
    }

    public void setMaxPageSize(int pageSize) {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.setMaxAuditDepth(pageSize);
        } finally {
            thread.setContextClassLoader(cl);
        }    
    }

    public void setMaxProducersToAudit(int maxProducersToAudit) {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.setMaxProducersToAudit(maxProducersToAudit);
        } finally {
            thread.setContextClassLoader(cl);
        }   
    }

    public void setMemoryUsagePortion(float value) {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.setMemoryUsagePortion(value);
        } finally {
            thread.setContextClassLoader(cl);
        }   
    }

    public void setProducerFlowControl(boolean producerFlowControl) {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.setProducerFlowControl(producerFlowControl);
        } finally {
            thread.setContextClassLoader(cl);
        }   
    }

    public void setUseCache(boolean value) {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.setUseCache(value);
        } finally {
            thread.setContextClassLoader(cl);
        }   
    }

    public void purge() throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.purge();
        } finally {
            thread.setContextClassLoader(cl);
        }   
    }

    public long getExpiredCount() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getExpiredCount();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public String sendTextMessage(Map<?, ?> arg0, String arg1) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.sendTextMessage(arg0, arg1);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public String sendTextMessage(Map<?, ?> arg0, String arg1, String arg2, String arg3) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.sendTextMessage(arg0, arg1, arg2, arg3);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

}
