/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.feature.jms.server.activemq.mgmt.jmx;

import javax.jms.InvalidSelectorException;

import org.apache.activemq.broker.jmx.SubscriptionViewMBean;
import org.bluestemsoftware.specification.eoa.ext.ExtensionFactoryContext;

public class Subscription implements SubscriptionMBean {

    private SubscriptionViewMBean underlying;
    private ExtensionFactoryContext factoryContext;

    public Subscription(ExtensionFactoryContext factoryContext, SubscriptionViewMBean underlying) {
        this.factoryContext = factoryContext;
        this.underlying = underlying;
    }

    public String getClientId() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getClientId();

        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public String getConnectionId() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getConnectionId();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public long getDequeueCounter() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getDequeueCounter();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public String getDestinationName() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getDestinationName();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public long getDispachedCounter() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getDispachedCounter();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public int getDispatchedQueueSize() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getDispatchedQueueSize();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public long getEnqueueCounter() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getEnqueueCounter();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public int getMaximumPendingMessageLimit() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getMaximumPendingMessageLimit();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public int getPendingQueueSize() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getPendingQueueSize();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public int getPrefetchSize() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getPrefetchSize();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public byte getPriority() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getPriority();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public String getSelector() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getSelector();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public long getSessionId() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getSessionId();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public long getSubcriptionId() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getSubcriptionId();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public String getSubcriptionName() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getSubcriptionName();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public boolean isActive() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.isActive();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public boolean isDestinationQueue() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.isDestinationQueue();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public boolean isDestinationTemporary() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.isDestinationTemporary();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public boolean isDestinationTopic() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.isDestinationTopic();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public boolean isDurable() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.isDurable();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public boolean isExclusive() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.isExclusive();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public boolean isNoLocal() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.isNoLocal();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public boolean isRetroactive() {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.isRetroactive();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public void setSelector(String selector) throws InvalidSelectorException, UnsupportedOperationException {

        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            underlying.setSelector(selector);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public int getMessageCountAwaitingAcknowledge() {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.getMessageCountAwaitingAcknowledge();
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public boolean isMatchingQueue(String queueName) {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.isMatchingQueue(queueName);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

    public boolean isMatchingTopic(String topicName) {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(factoryContext.getClassLoader());
            return underlying.isMatchingTopic(topicName);
        } finally {
            thread.setContextClassLoader(cl);
        }
    }

}
