/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.feature.jms.server.activemq.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import org.apache.activemq.thread.TaskRunnerFactory;

/**
 * Modified behavior such that thread names are unique, i.e. to facilitate debugging of
 * concurrency issues - TWW 
 */
public class TaskRunnerFactoryImpl extends TaskRunnerFactory {

    private String name;
    private int priority;
    private boolean daemon;
    public TaskRunnerFactoryImpl() {
        super();
    }

    public TaskRunnerFactoryImpl(String name, int priority, boolean daemon, int maxIterationsPerRun) {
        super(name, priority, daemon, maxIterationsPerRun);
        this.name = name;
        this.priority = priority;
        this.daemon = daemon;
    }

    /*
     * (non-Javadoc)
     * @see org.apache.activemq.thread.TaskRunnerFactory#createDefaultExecutor()
     */
    @SuppressWarnings("unchecked")
    @Override
    protected ExecutorService createDefaultExecutor() {
        ThreadPoolExecutor rc = new ThreadPoolExecutor(1, Integer.MAX_VALUE, 10, TimeUnit.SECONDS,
                new SynchronousQueue(), new ThreadFactory() {
                    public Thread newThread(Runnable runnable) {
                        Thread thread = new Thread(runnable, name + " - " + Math.round((1000 * Math.random())));
                        thread.setDaemon(daemon);
                        thread.setPriority(priority);
                        return thread;
                    }
                });
        rc.allowCoreThreadTimeOut(true);
        return rc;
    }

}
