/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.feature.jms.server.activemq.xbean;

import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.bluestemsoftware.open.eoa.ext.feature.jms.server.activemq.mgmt.jmx.ManagementContextImpl;
import org.bluestemsoftware.specification.eoa.ext.feature.jms.server.JMSServerFeature;
import org.bluestemsoftware.specification.eoa.ext.management.jmx.JMXServerContext;

public class EmbeddedBroker extends BrokerService {

    private static final long serialVersionUID = 1L;

    private JMSServerFeature jmsServerFeature;
    private JMXServerContext jmxServerContext;
    private ManagementContext mc;

    public void setJmsServerFeature(JMSServerFeature jmsServerFeature) {
        this.jmsServerFeature = jmsServerFeature;
    }
    
    public void setJmxServerContext(JMXServerContext jmxServerContext) {
        this.jmxServerContext = jmxServerContext;
    }

    @Override
    public ManagementContext getManagementContext() {
        if (mc == null) {
            mc = new ManagementContextImpl(jmsServerFeature, jmxServerContext);
            setManagementContext(mc);
        }
        return mc;
    }

    @Override
    public void start() throws Exception {
        setUseJmx(jmxServerContext != null);
        super.start();
    }

}
