/*
 * Decompiled with CFR 0.152.
 */
package org.bluestemsoftware.open.eoa.ext.message.axiom;

import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.dom.DOMMessageFormatter;
import org.apache.axiom.om.impl.dom.DocumentImpl;
import org.bluestemsoftware.open.eoa.aspect.axiom.PartAccessor;
import org.bluestemsoftware.open.eoa.aspect.axiom.util.ContextInfo;
import org.bluestemsoftware.open.eoa.aspect.axiom.util.STAXUtils;
import org.bluestemsoftware.open.eoa.commons.util.DOMHandler;
import org.bluestemsoftware.open.eoa.ext.message.axiom.util.MessageDefinition;
import org.bluestemsoftware.specification.eoa.DeploymentException;
import org.bluestemsoftware.specification.eoa.component.ComponentContext;
import org.bluestemsoftware.specification.eoa.component.ComponentDeployment;
import org.bluestemsoftware.specification.eoa.component.ComponentReference;
import org.bluestemsoftware.specification.eoa.component.FragmentIdentifier;
import org.bluestemsoftware.specification.eoa.component.RootComponent;
import org.bluestemsoftware.specification.eoa.component.intrface.rt.SystemFault;
import org.bluestemsoftware.specification.eoa.component.message.InterfaceMessage;
import org.bluestemsoftware.specification.eoa.component.message.MessageFragment;
import org.bluestemsoftware.specification.eoa.component.message.MessagePart;
import org.bluestemsoftware.specification.eoa.component.message.rt.Content;
import org.bluestemsoftware.specification.eoa.component.message.rt.Message;
import org.bluestemsoftware.specification.eoa.component.message.rt.MessageValidationException;
import org.bluestemsoftware.specification.eoa.component.types.Schema;
import org.bluestemsoftware.specification.eoa.component.types.SchemaComponent;
import org.bluestemsoftware.specification.eoa.component.types.SchemaFragment;
import org.bluestemsoftware.specification.eoa.component.types.rt.ExpressionRT;
import org.bluestemsoftware.specification.eoa.component.types.rt.SchemaDocument;
import org.bluestemsoftware.specification.eoa.component.types.rt.SchemaException;
import org.bluestemsoftware.specification.eoa.component.types.rt.SchemaValidationException;
import org.bluestemsoftware.specification.eoa.ext.Extension;
import org.bluestemsoftware.specification.eoa.ext.ExtensionFactory;
import org.bluestemsoftware.specification.eoa.ext.ExtensionFactoryContext;
import org.bluestemsoftware.specification.eoa.ext.expression.EvaluationException;
import org.bluestemsoftware.specification.eoa.ext.schema.SchemaFactory;
import org.bluestemsoftware.specification.eoa.system.SystemContext;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessage
extends DocumentImpl
implements Message.Provider {
    protected FragmentIdentifier fragmentIdentifier;
    protected ComponentContext componentContext;
    protected RootComponent.ComponentName componentName;
    protected MessageDefinition messageDefinition;
    private Map<String, SchemaDocument> partAccessorSchemas;
    protected Boolean isDeployed = Boolean.FALSE;

    public AbstractMessage(DocumentImpl ownerDocument, OMFactory factory) {
        super(ownerDocument, factory);
    }

    public AbstractMessage(OMFactory factory) {
        super(factory);
    }

    public AbstractMessage(OMXMLParserWrapper parserWrapper, OMFactory factory) {
        super(parserWrapper, factory);
    }

    public RootComponent.ComponentName getName() {
        return this.componentName;
    }

    public RootComponent.ComponentType getComponentType() {
        return RootComponent.ComponentType.MESSAGE;
    }

    public ComponentContext getComponentContext() {
        if (this.componentContext == null) {
            this.componentContext = this.getMetadata().getComponentContext();
        }
        return this.componentContext;
    }

    public InterfaceMessage getRuntimeProvidable() {
        return this.getMetadata();
    }

    public Extension.Provider getExtensionProvider() {
        return this;
    }

    public File getMessageDefinition() {
        return this.messageDefinition;
    }

    public FragmentIdentifier getFragmentIdentifier() {
        if (this.fragmentIdentifier == null) {
            this.fragmentIdentifier = new FragmentIdentifier(this.componentName.getNamespaceURI(), FragmentIdentifier.Scheme.EOA, "messageRT", this.componentName.getLocalPart());
        }
        return this.fragmentIdentifier;
    }

    public void spi_setConsumer(Extension consumer) {
    }

    public void validate() throws MessageValidationException {
        if (!this.isDeployed()) {
            throw new IllegalStateException("message not deployed");
        }
        InterfaceMessage interfaceMessage = this.getMetadata();
        if (interfaceMessage == null) {
            throw new IllegalStateException("Abstract message " + this.componentName + " is undefined");
        }
        if (this.componentName.equals((Object)InterfaceMessage.AnyMessage.NAME)) {
            return;
        }
        Element documentElement = this.getDocumentElement();
        if (!documentElement.getLocalName().equals("message")) {
            throw new MessageValidationException("Expected root element with localName 'message'.");
        }
        for (MessagePart part : interfaceMessage.getParts()) {
            String partName = part.getName();
            PartAccessor partAccessor = this.getPartAccessor(partName);
            if (partAccessor == null) {
                throw new MessageValidationException("Concrete instance of abstract message part " + part.getName() + " is undefined");
            }
            SchemaDocument schema = null;
            Content content = null;
            if (part.getSchemaComponentType() == SchemaComponent.Type.ELEMENT_DECLARATION) {
                content = (Content)partAccessor.getFirstElement();
                if (content == null) continue;
                schema = part.getReferencedComponent().getRuntimeProvider();
            } else {
                content = (Content)partAccessor;
                schema = this.getPartAccessorSchema(partName, part.getSchemaComponentQName());
            }
            try {
                schema.validate((Element)content);
            }
            catch (SchemaException se) {
                throw new MessageValidationException("Error validating message. " + se.getMessage());
            }
            catch (SchemaValidationException sve) {
                throw new MessageValidationException(sve.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateDefinition() throws MessageValidationException {
        if (this.messageDefinition == null) {
            throw new IllegalStateException("message has no definition");
        }
        InterfaceMessage interfaceMessage = this.getMetadata();
        if (interfaceMessage == null) {
            throw new MessageValidationException("Abstract message " + this.componentName + " is undefined");
        }
        Element documentElement = this.getDocumentElement();
        if (!documentElement.getLocalName().equals("message")) {
            throw new MessageValidationException("Expected root element with localName 'message'.");
        }
        NodeList nodeList = documentElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String ns;
            if (nodeList.item(i).getNodeType() != 1) continue;
            Element child = (Element)nodeList.item(i);
            String string = ns = child.getNamespaceURI() == null ? "" : child.getNamespaceURI();
            if (!ns.equals("")) {
                throw new MessageValidationException("Element " + new QName(child.getNamespaceURI(), child.getLocalName()) + " is is invalid. Part accessor element must have no namespace.");
            }
            if (interfaceMessage.getPart(child.getLocalName()) != null) continue;
            throw new MessageValidationException("Part accessor defined for part '" + child.getLocalName() + "' fails to match a part defined on abstract message");
        }
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            ExtensionFactoryContext efc = this.getExtensionFactory().getFactoryContext();
            Thread.currentThread().setContextClassLoader((ClassLoader)efc.getClassLoader());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = null;
            try {
                documentBuilder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException pe) {
                throw new MessageValidationException("Error validating message. " + pe);
            }
            Document newSourceDocument = documentBuilder.newDocument();
            String defaultMessageNS = "http://bluestemsoftware.org/specification/eoa/ext/message/default/1.0";
            Element newDocumentElement = newSourceDocument.createElementNS(defaultMessageNS, "message");
            String ns = this.componentName.getNamespaceURI();
            newDocumentElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ns", ns);
            newDocumentElement.setAttribute("name", "ns:" + this.componentName.getLocalPart());
            newSourceDocument.appendChild(newDocumentElement);
            for (MessagePart part : interfaceMessage.getParts()) {
                DOMHandler domHandler;
                String partName = part.getName();
                PartAccessor partAccessor = this.getPartAccessor(partName);
                if (partAccessor == null) {
                    throw new MessageValidationException("Concrete instance of abstract message part " + part.getName() + " is undefined");
                }
                SchemaDocument schema = null;
                Content content = null;
                if (part.getSchemaComponentType() == SchemaComponent.Type.ELEMENT_DECLARATION) {
                    content = (Content)partAccessor.getFirstElement();
                    if (content == null) {
                        Node temp = newSourceDocument.importNode((Node)partAccessor, true);
                        ((Element)temp).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
                        newDocumentElement.appendChild(temp);
                        continue;
                    }
                    RootComponent.ComponentName schemaName = part.getReferencedComponent().getName();
                    SchemaReferenceInternal cr = new SchemaReferenceInternal(schemaName);
                    try {
                        this.componentContext.findReferencedComponent((ComponentReference)cr);
                    }
                    catch (DeploymentException de) {
                        throw new MessageValidationException((Throwable)de);
                    }
                    schema = part.getReferencedComponent().getRuntimeProvider();
                } else {
                    content = (Content)partAccessor;
                    schema = this.getPartAccessorSchema(partName, part.getSchemaComponentQName());
                }
                try {
                    domHandler = new DOMHandler(true, true);
                }
                catch (ParserConfigurationException pe) {
                    throw new MessageValidationException((Throwable)pe);
                }
                final ArrayList errorMessages = new ArrayList();
                try {
                    schema.validate((Element)content, (ContentHandler)domHandler, (LexicalHandler)domHandler, new ErrorHandler(){

                        public void error(SAXParseException spe) throws SAXException {
                            errorMessages.add(spe.getMessage());
                        }

                        public void warning(SAXParseException spe) throws SAXException {
                            errorMessages.add(spe.getMessage());
                        }

                        public void fatalError(SAXParseException spe) throws SAXException {
                            errorMessages.add(spe.getMessage());
                        }
                    });
                }
                catch (SchemaException se) {
                    throw new MessageValidationException("Error validating message. " + se.getMessage());
                }
                if (errorMessages.size() > 0) {
                    Iterator messageIterator = errorMessages.iterator();
                    StringBuilder errorMessage = new StringBuilder();
                    while (messageIterator.hasNext()) {
                        errorMessage.append((String)messageIterator.next() + "  ");
                    }
                    throw new MessageValidationException(errorMessage.toString());
                }
                Document result = domHandler.getDocument();
                if (part.getSchemaComponentType() == SchemaComponent.Type.ELEMENT_DECLARATION) {
                    Element newPartAccessorElement = newSourceDocument.createElementNS(null, partName);
                    newDocumentElement.appendChild(newPartAccessorElement);
                    if (result == null) continue;
                    Element temp = result.getDocumentElement();
                    newSourceDocument.adoptNode(temp);
                    newPartAccessorElement.appendChild(temp);
                    continue;
                }
                Element temp = result.getDocumentElement();
                newSourceDocument.adoptNode(temp);
                newDocumentElement.appendChild(temp);
            }
            OutputStreamWriter writer = null;
            try {
                writer = new FileWriter((File)this.messageDefinition, false);
                DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
                DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
                LSSerializer serializer = impl.createLSSerializer();
                serializer.getDomConfig().setParameter("xml-declaration", false);
                LSOutput destination = impl.createLSOutput();
                destination.setCharacterStream(writer);
                destination.setEncoding("UTF-8");
                newSourceDocument.normalize();
                serializer.write(newSourceDocument, destination);
            }
            finally {
                if (writer == null) {
                    writer.flush();
                    writer.close();
                }
            }
            if (this.builder != null) {
                ((StAXOMBuilder)this.builder).close();
            }
            this.documentElement.detachFromDocument();
            InputStream in = this.messageDefinition.newInputStream();
            XMLStreamReader reader = STAXUtils.createXMLStreamReader((InputStream)in, (String)"UTF-8");
            this.builder = new StAXOMBuilder(this.getOMFactory(), reader);
            this.done = false;
        }
        catch (Exception ex) {
            throw new MessageValidationException("Error validating message. " + ex);
        }
        finally {
            if (current != null) {
                Thread.currentThread().setContextClassLoader(current);
            }
        }
    }

    public RootComponent.ComponentType getReferencedComponentType() {
        return RootComponent.ComponentType.MESSAGE;
    }

    public synchronized void deploy(ComponentContext componentContext) throws DeploymentException {
        if (this.isDeployed == null) {
            throw new DeploymentException("Runtime component " + this.getFragmentIdentifier() + " is circularly referenced by " + ComponentDeployment.CurrentReference.getCurrentReference());
        }
        if (this.isDeployed.booleanValue()) {
            return;
        }
        this.isDeployed = null;
        this.componentContext = componentContext;
        try {
            this.validateDefinition();
        }
        catch (MessageValidationException se) {
            throw new DeploymentException("Runtime message instance " + this.componentName + " is not valid. " + se.getMessage());
        }
        this.isDeployed = Boolean.TRUE;
    }

    public synchronized boolean isDeployed() {
        if (this.isDeployed == null) {
            return false;
        }
        return this.isDeployed;
    }

    public synchronized Content getContent() {
        if (!this.getMetadata().isWSDL20Style()) {
            throw new UnsupportedOperationException("Message " + this.componentName + " is not a WSDL 2.0 style message");
        }
        OMElement content = this.getOMDocumentElement().getFirstElement().getFirstElement();
        if (content != null) {
            content.buildNext();
        }
        return (Content)content;
    }

    public synchronized Content getContent(String partName) {
        if (this.getMetadata().isWSDL20Style()) {
            return this.getContent();
        }
        MessagePart abstractPart = this.getMetadata().getPart(partName);
        if (abstractPart == null) {
            throw new IllegalArgumentException("Message part '" + partName + "' is undefined for message " + this.componentName + ".");
        }
        PartAccessor partAccessor = this.getPartAccessor(partName);
        if (abstractPart.getSchemaComponentType() == SchemaComponent.Type.ELEMENT_DECLARATION) {
            OMElement content = partAccessor.getFirstElement();
            if (content != null) {
                content.buildNext();
            }
            return (Content)content;
        }
        return (Content)partAccessor;
    }

    public synchronized void setContent(Content content) {
        String partName = null;
        if (this.componentName.equals((Object)SystemFault.MESSAGE_NAME)) {
            partName = "payload";
        } else {
            if (!this.getMetadata().isWSDL20Style()) {
                throw new UnsupportedOperationException("Message " + this.componentName + " is not a WSDL 2.0 style message");
            }
            if (this.getMetadata().getParts().size() == 0) {
                throw new IllegalArgumentException("Abstract message " + this.componentName + " defines no parts.");
            }
            MessagePart abstractPart = (MessagePart)this.getMetadata().getParts().iterator().next();
            partName = abstractPart.getName();
        }
        PartAccessor partAccessor = this.getPartAccessor(partName);
        if (content != null) {
            if (!content.getOwnerDocument().equals((Object)this)) {
                throw new DOMException(4, DOMMessageFormatter.formatMessage((String)"http://www.w3.org/dom/DOMTR", (String)"WRONG_DOCUMENT_ERR", null));
            }
            partAccessor.discardContent();
            partAccessor.addChild((OMNode)((OMElement)content));
        } else {
            partAccessor.discardContent();
        }
    }

    public synchronized void setContent(String partName, Content content) {
        if (this.componentName.equals((Object)SystemFault.MESSAGE_NAME)) {
            this.setContent(content);
            return;
        }
        MessagePart abstractPart = this.getMetadata().getPart(partName);
        if (abstractPart == null) {
            throw new IllegalArgumentException("Message part '" + partName + "' is undefined for message " + this.componentName + ".");
        }
        if (this.getMetadata().isWSDL20Style()) {
            this.setContent(content);
            return;
        }
        PartAccessor partAccessor = this.getPartAccessor(partName);
        if (abstractPart.getSchemaComponentType() == SchemaComponent.Type.ELEMENT_DECLARATION) {
            if (content != null) {
                if (!content.getOwnerDocument().equals((Object)this)) {
                    throw new DOMException(4, DOMMessageFormatter.formatMessage((String)"http://www.w3.org/dom/DOMTR", (String)"WRONG_DOCUMENT_ERR", null));
                }
                partAccessor.discardContent();
                partAccessor.addChild((OMNode)((OMElement)content));
            } else {
                partAccessor.discardContent();
            }
        } else if (content != null) {
            if (!content.getOwnerDocument().equals((Object)this)) {
                throw new DOMException(4, DOMMessageFormatter.formatMessage((String)"http://www.w3.org/dom/DOMTR", (String)"WRONG_DOCUMENT_ERR", null));
            }
            QName expectedType = new QName("", partName);
            QName actualType = new QName(content.getNamespaceURI(), content.getLocalName());
            if (!expectedType.equals(actualType)) {
                throw new IllegalArgumentException("Content incorrectly typed for part '" + partName + "' defined on message " + this.componentName + ". Found " + actualType + ". Expected part accessor element " + expectedType + ".");
            }
            partAccessor.build();
            partAccessor.detach();
            this.getOMDocumentElement().addChild((OMNode)((OMElement)content));
        } else {
            partAccessor.discardContent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String evaluateString(QName fragmentName) throws EvaluationException {
        String string;
        block5: {
            MessageFragment fragment = this.getMetadata().getFragment(fragmentName);
            if (fragment == null) {
                throw new IllegalArgumentException("Message fragment " + fragmentName + ", is undefined for message " + this.componentName + ".");
            }
            ContextInfo contextInfo = null;
            Content partContent = null;
            try {
                partContent = this.getContent(fragment.getPartName());
                if (partContent == null) {
                    throw new IllegalArgumentException("Message part '" + fragment.getPartName() + "' upon which fragment " + fragmentName + " is defined for message " + this.componentName + ", has no content.");
                }
                contextInfo = STAXUtils.adjustContext((Content)partContent);
                SchemaFragment schemaFragment = fragment.getSchemaFragment();
                ExpressionRT expression = schemaFragment.getFragmentExpression().getRuntimeExpression();
                string = expression.evaluateString((Node)((Object)this));
                if (contextInfo == null) break block5;
            }
            catch (Throwable throwable) {
                if (contextInfo != null) {
                    STAXUtils.restoreContext(contextInfo, (Content)partContent);
                }
                throw throwable;
            }
            STAXUtils.restoreContext((ContextInfo)contextInfo, (Content)partContent);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Boolean evaluateBoolean(QName fragmentName) throws EvaluationException {
        Boolean bl;
        block5: {
            MessageFragment fragment = this.getMetadata().getFragment(fragmentName);
            if (fragment == null) {
                throw new IllegalArgumentException("Message fragment " + fragmentName + ", is undefined for message " + this.componentName + ".");
            }
            ContextInfo contextInfo = null;
            Content partContent = null;
            try {
                partContent = this.getContent(fragment.getPartName());
                if (partContent == null) {
                    throw new IllegalArgumentException("Message part '" + fragment.getPartName() + "' upon which fragment " + fragmentName + " is defined for message " + this.componentName + ", has no content.");
                }
                contextInfo = STAXUtils.adjustContext((Content)partContent);
                SchemaFragment schemaFragment = fragment.getSchemaFragment();
                ExpressionRT expression = schemaFragment.getFragmentExpression().getRuntimeExpression();
                bl = expression.evaluateBoolean((Node)((Object)this));
                if (contextInfo == null) break block5;
            }
            catch (Throwable throwable) {
                if (contextInfo != null) {
                    STAXUtils.restoreContext(contextInfo, (Content)partContent);
                }
                throw throwable;
            }
            STAXUtils.restoreContext((ContextInfo)contextInfo, (Content)partContent);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Number evaluateNumber(QName fragmentName) throws EvaluationException {
        Number number;
        block5: {
            MessageFragment fragment = this.getMetadata().getFragment(fragmentName);
            if (fragment == null) {
                throw new IllegalArgumentException("Message fragment " + fragmentName + ", is undefined for message " + this.componentName + ".");
            }
            ContextInfo contextInfo = null;
            Content partContent = null;
            try {
                partContent = this.getContent(fragment.getPartName());
                if (partContent == null) {
                    throw new IllegalArgumentException("Message part '" + fragment.getPartName() + "' upon which fragment " + fragmentName + " is defined for message " + this.componentName + ", has no content.");
                }
                contextInfo = STAXUtils.adjustContext((Content)partContent);
                SchemaFragment schemaFragment = fragment.getSchemaFragment();
                ExpressionRT expression = schemaFragment.getFragmentExpression().getRuntimeExpression();
                number = expression.evaluateNumber((Node)((Object)this));
                if (contextInfo == null) break block5;
            }
            catch (Throwable throwable) {
                if (contextInfo != null) {
                    STAXUtils.restoreContext(contextInfo, (Content)partContent);
                }
                throw throwable;
            }
            STAXUtils.restoreContext((ContextInfo)contextInfo, (Content)partContent);
        }
        return number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Node evaluateNode(QName fragmentName) throws EvaluationException {
        Node node;
        block5: {
            MessageFragment fragment = this.getMetadata().getFragment(fragmentName);
            if (fragment == null) {
                throw new IllegalArgumentException("Message fragment " + fragmentName + ", is undefined for message " + this.componentName + ".");
            }
            ContextInfo contextInfo = null;
            Content partContent = null;
            try {
                partContent = this.getContent(fragment.getPartName());
                if (partContent == null) {
                    throw new IllegalArgumentException("Message part '" + fragment.getPartName() + "' upon which fragment " + fragmentName + " is defined for message " + this.componentName + ", has no content.");
                }
                contextInfo = STAXUtils.adjustContext((Content)partContent);
                SchemaFragment schemaFragment = fragment.getSchemaFragment();
                ExpressionRT expression = schemaFragment.getFragmentExpression().getRuntimeExpression();
                node = expression.evaluateNode((Node)((Object)this));
                if (contextInfo == null) break block5;
            }
            catch (Throwable throwable) {
                if (contextInfo != null) {
                    STAXUtils.restoreContext(contextInfo, (Content)partContent);
                }
                throw throwable;
            }
            STAXUtils.restoreContext((ContextInfo)contextInfo, (Content)partContent);
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<Node> evaluateNodes(QName fragmentName) throws EvaluationException {
        List list;
        block5: {
            MessageFragment fragment = this.getMetadata().getFragment(fragmentName);
            if (fragment == null) {
                throw new IllegalArgumentException("Message fragment " + fragmentName + ", is undefined for message " + this.componentName + ".");
            }
            ContextInfo contextInfo = null;
            Content partContent = null;
            try {
                partContent = this.getContent(fragment.getPartName());
                if (partContent == null) {
                    throw new IllegalArgumentException("Message part '" + fragment.getPartName() + "' upon which fragment " + fragmentName + " is defined for message " + this.componentName + ", has no content.");
                }
                contextInfo = STAXUtils.adjustContext((Content)partContent);
                SchemaFragment schemaFragment = fragment.getSchemaFragment();
                ExpressionRT expression = schemaFragment.getFragmentExpression().getRuntimeExpression();
                list = expression.evaluateNodes((Node)((Object)this));
                if (contextInfo == null) break block5;
            }
            catch (Throwable throwable) {
                if (contextInfo != null) {
                    STAXUtils.restoreContext(contextInfo, (Content)partContent);
                }
                throw throwable;
            }
            STAXUtils.restoreContext((ContextInfo)contextInfo, (Content)partContent);
        }
        return list;
    }

    public void setComponentName(RootComponent.ComponentName componentName) {
        this.componentName = componentName;
    }

    public void setMessageDefinition(MessageDefinition messageDefinition) {
        this.messageDefinition = messageDefinition;
    }

    public InterfaceMessage getMetadata() {
        return SystemContext.getContext().getSystem().getMessage((QName)this.componentName);
    }

    public abstract ExtensionFactory getExtensionFactory();

    public String toString() {
        return this.getDocumentElement().toString();
    }

    private PartAccessor getPartAccessor(String partName) {
        OMElement messageElement = this.getOMDocumentElement();
        OMElement firstChild = messageElement.getFirstElement();
        OMElement answer = null;
        if (firstChild.getLocalName().equals(partName)) {
            answer = firstChild;
        } else {
            for (OMNode sibling = firstChild.getNextOMSibling(); sibling != null; sibling = sibling.getNextOMSibling()) {
                OMElement temp;
                if (sibling.getType() != 1 || !(temp = (OMElement)sibling).getLocalName().equals(partName)) continue;
                answer = temp;
                break;
            }
        }
        return (PartAccessor)answer;
    }

    private SchemaDocument getPartAccessorSchema(String partName, QName partType) throws MessageValidationException {
        SchemaDocument schema;
        if (this.partAccessorSchemas == null) {
            this.partAccessorSchemas = new HashMap<String, SchemaDocument>();
        }
        if ((schema = this.partAccessorSchemas.get(partName)) == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = null;
            try {
                documentBuilder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException pe) {
                throw new MessageValidationException("Error creating part accessor schema. " + pe);
            }
            Document temp = documentBuilder.newDocument();
            Element root = temp.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:schema");
            root.setAttribute("elementFormDefault", "unqualified");
            temp.appendChild(root);
            String prefix = null;
            if (partType.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                prefix = "xs";
            } else {
                root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ns", partType.getNamespaceURI());
                prefix = "ns";
                Element importElement = temp.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:import");
                importElement.setAttribute("namespace", partType.getNamespaceURI());
                root.appendChild(importElement);
            }
            Element partAccessorDecl = temp.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:element");
            partAccessorDecl.setAttribute("name", partName);
            partAccessorDecl.setAttribute("type", prefix + ":" + partType.getLocalPart());
            root.appendChild(partAccessorDecl);
            SchemaFactory sf = SystemContext.getContext().getSystem().getSchemaFactory("http://www.w3.org/2001/XMLSchema");
            if (sf == null) {
                throw new MessageValidationException("Unable to auto-gen part accessor schema. SchemaFactory of type http://www.w3.org/2001/XMLSchema is undefined.");
            }
            try {
                Set set = sf.readSchemas((EntityResolver)this.componentContext, (Source)new DOMSource(temp));
                schema = (SchemaDocument)set.iterator().next();
                this.partAccessorSchemas.put(partName, schema);
            }
            catch (SchemaException ex) {
                throw new MessageValidationException("Error creating part accessor schema. " + (Object)((Object)ex));
            }
        }
        return schema;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SchemaReferenceInternal
    implements ComponentReference<Schema> {
        private RootComponent.ComponentName schemaName;

        public SchemaReferenceInternal(RootComponent.ComponentName schemaName) {
            this.schemaName = schemaName;
        }

        public FragmentIdentifier getFragmentIdentifier() {
            return new FragmentIdentifier("foo", FragmentIdentifier.Scheme.EOA, "bar", "");
        }

        public Schema getReferencedComponent() {
            throw new UnsupportedOperationException();
        }

        public Class<Schema> getReferencedComponentClass() {
            return Schema.class;
        }

        public RootComponent.ComponentName getReferencedComponentName() {
            return this.schemaName;
        }

        public RootComponent.ComponentType getReferencedComponentType() {
            return RootComponent.ComponentType.SCHEMA;
        }
    }
}

