/*
 * Decompiled with CFR 0.152.
 */
package org.bluestemsoftware.open.eoa.ext.message.axiom.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.bluestemsoftware.specification.eoa.component.intrface.rt.SystemFault;
import org.bluestemsoftware.specification.eoa.system.System;
import org.bluestemsoftware.specification.eoa.system.SystemContext;

public class MessageDefinition
extends File {
    private static final long serialVersionUID = 1L;
    private static System.Log log = SystemContext.getContext().getSystem().getLog(MessageDefinition.class);
    private QName messageName;
    private Set<InputStream> inputStreams;

    public static MessageDefinition newFile(QName messageName) {
        String fileName = UUID.randomUUID().toString();
        File temporaryDirectory = SystemContext.getContext().getSystem().getSystemTmpDir();
        return new MessageDefinition(temporaryDirectory, fileName + ".eoa-message", messageName);
    }

    public InputStream newInputStream() {
        FileInputStream in = null;
        try {
            in = new FileInputStream(this);
        }
        catch (FileNotFoundException fe) {
            throw new IllegalStateException("Temp file containing provider definition for message " + this.messageName + " was prematurely deleted from file system.");
        }
        this.inputStreams.add(in);
        return in;
    }

    private MessageDefinition(File parent, String child, QName messageName) {
        super(parent, child);
        this.messageName = messageName;
        this.inputStreams = new HashSet<InputStream>();
        this.addShutdownHook();
    }

    protected void finalize() throws Throwable {
        this.cleanUp();
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                MessageDefinition.this.cleanUp();
            }
        });
    }

    private void cleanUp() {
        for (InputStream in : this.inputStreams) {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        if (!this.messageName.equals(SystemFault.MESSAGE_NAME) && this.exists() && !this.delete()) {
            log.debug("Failed to delete temp file " + this.getName() + " containing provider definition for message " + this.messageName + ".");
        }
    }
}

