/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.test.feature.axis.server.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;

import javax.xml.stream.XMLStreamException;

import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentErrorMsgs;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.DescriptionBuilder;
import org.apache.axis2.deployment.ServiceBuilder;
import org.apache.axis2.deployment.ServiceGroupBuilder;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.axis2.i18n.Messages;

/**
 * Provides custom deployment behavior within context of an eoa system test. Some methods were
 * overridden/copied/modified from org.apache.axis2.deployment.DeploymentEngine and are
 * commented accordingly.
 */
public class AxisConfiguratorImpl extends DeploymentEngine implements AxisConfigurator {

    private URL conf;
    private URL repo;

    public AxisConfiguratorImpl(URL conf, URL repo) {
        this.conf = conf;
        this.repo = repo;
    }

    public void engageGlobalModules() throws AxisFault {
        loadRepositoryFromURL(repo);
        engageModules();
    }

    public AxisConfiguration getAxisConfiguration() throws AxisFault {
        AxisConfiguration config = null;
        try {
            config = populateAxisConfiguration(conf.openStream());
        } catch (Exception ex) {
            throw new AxisFault("Error retrieving axis2 configuration. " + ex);
        }
        return config;
    }

    @Override
    public void loadServices() {
        loadServicesFromUrl(repo);
    }

    /*
     * (non-Javadoc)
     * @see org.apache.axis2.deployment.DeploymentEngine#populateService(org.apache.axis2.description.AxisServiceGroup,
     *      java.net.URL, java.lang.String)
     * 
     * COPIED CODE FROM SUPER AND MODIFIED TO ALLOW DEPLOYMENT OF EXPLODED .aar DEPLOYMENTS. ALSO
     * REMOVED WSDL TO JAVA FUNCTIONALITY WHICH WE WON'T SUPPORT FOR TESTS - TWW.
     */
    @Override
    protected ArrayList<?> populateService(AxisServiceGroup serviceGroup, URL servicesURL, String serviceName) throws DeploymentException {
        try {
            serviceGroup.setServiceGroupName(serviceName);
            servicesURL = new URL(servicesURL.toString() + "/"); // ADDED. url's a dir, not a file - TWW
            File systemTestClassesDir = new File(System.getProperty("testClassesDirectory")); // ADDED
            File suiteTestClassesDir = systemTestClassesDir.getParentFile().getParentFile(); // ADDED
            File clientTestClassesDir = new File(suiteTestClassesDir, "client/test-classes/"); // ADDED
            URL[] urls = new URL[]{servicesURL, clientTestClassesDir.toURI().toURL()}; // ADDED
            ClassLoader serviceClassLoader = Utils.createClassLoader(urls, axisConfig // MODIFIED. added urls
                    .getServiceClassLoader(), false, null); // MODIFIED. SET extractJars TO FALSE - TWW
            serviceGroup.setServiceGroupClassLoader(serviceClassLoader);
            HashMap<?, ?> servicesMap = new HashMap<Object, Object>();
            InputStream servicexmlStream = serviceClassLoader.getResourceAsStream("META-INF/services.xml");
            if (servicexmlStream == null) {
                servicexmlStream = serviceClassLoader.getResourceAsStream("meta-inf/services.xml");
            }
            if (servicexmlStream == null) {
                throw new DeploymentException(Messages.getMessage(DeploymentErrorMsgs.SERVICE_XML_NOT_FOUND,
                        servicesURL.toString()));
            }
            DescriptionBuilder builder = new DescriptionBuilder(servicexmlStream, configContext);
            OMElement rootElement = builder.buildOM();
            String elementName = rootElement.getLocalName();
            if (TAG_SERVICE.equals(elementName)) {
                AxisService axisService = new AxisService(serviceName);
                axisService.setParent(serviceGroup);
                axisService.setClassLoader(serviceClassLoader);
                ServiceBuilder serviceBuilder = new ServiceBuilder(configContext, axisService);
                AxisService service = serviceBuilder.populateService(rootElement);
                ArrayList<AxisService> serviceList = new ArrayList<AxisService>();
                serviceList.add(service);
                return serviceList;
            } else if (TAG_SERVICE_GROUP.equals(elementName)) {
                ServiceGroupBuilder groupBuilder = new ServiceGroupBuilder(rootElement, servicesMap, configContext);
                return groupBuilder.populateServiceGroup(serviceGroup);
            }
        } catch (IOException e) {
            throw new DeploymentException(e);
        } catch (XMLStreamException e) {
            throw new DeploymentException(e);
        }
        return null;
    }

}
