/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.test.feature.axis.server;

import org.bluestemsoftware.specification.eoa.ext.feature.FeatureFactory;
import org.bluestemsoftware.specification.eoa.system.server.Feature;

/**
 * Embeds an axis server as an EOA Feature. Probably only useful within context of a binding
 * test.
 * <p>
 * Note that currently axis service classes are loaded from the 'client' test directory of
 * currently executing test suite. This could, however, be parameterized. Context path is
 * '/axis2', authentication uses basic scheme and application realm is 'axis'.
 */
public class AxisServerFeature extends Feature {

    public static final String TYPE = AxisServerFeature.class.getName();

    public AxisServerFeature(FeatureFactory factory, Provider provider) {
        super(factory, provider);
    }

}
