/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.test.feature.axis.server;

import org.bluestemsoftware.specification.eoa.ext.feature.FeatureException;
import org.bluestemsoftware.specification.eoa.ext.feature.FeatureFactory;
import org.bluestemsoftware.specification.eoa.system.server.Feature;

public class AxisServerFeatureFactory extends FeatureFactory {
    
    public static interface Provider extends FeatureFactory.Provider {
    }

    @Override
    public Feature createFeature() throws FeatureException {
        return new AxisServerFeature(this, new AxisServerFeatureProvider());
    }

    @Override
    public String getExtensionType() {
        return AxisServerFeature.TYPE;
    }

}
