/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.test.feature.axis.server;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.axis2.transport.http.AxisServlet;
import org.bluestemsoftware.open.eoa.test.feature.axis.server.util.AxisConfiguratorImpl;
import org.bluestemsoftware.open.eoa.test.feature.axis.server.util.ServerAuthInfoImpl;
import org.bluestemsoftware.specification.eoa.ext.Extension;
import org.bluestemsoftware.specification.eoa.ext.feature.FeatureException;
import org.bluestemsoftware.specification.eoa.ext.feature.http.server.HTTPServerFeature;
import org.bluestemsoftware.specification.eoa.ext.feature.http.server.HTTPServerFeature.ServerAuthInfo;
import org.bluestemsoftware.specification.eoa.ext.feature.http.server.HTTPServerFeatureException.UniquePathException;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.transport.http.HTTPAuthenticationScheme;
import org.bluestemsoftware.specification.eoa.system.ManagementContext;
import org.bluestemsoftware.specification.eoa.system.SystemContext;
import org.bluestemsoftware.specification.eoa.system.server.Feature;
import org.bluestemsoftware.specification.eoa.system.server.Server;

public class AxisServerFeatureProvider implements Feature.Provider {
    
    public static final String NAME = "axis-server-feature";
    public static final String IMPL = AxisServerFeatureProvider.class.getName();

    private File resourcesDir;
    private static ConfigurationContext configurationContext;

    public String spi_getFeatureImpl() {
        return IMPL;
    }

    public void spi_init(Set<ManagementContext> managementContexts) throws FeatureException {
        resourcesDir = new File(java.lang.System.getProperty("testClassesDirectory"));
        try {
            URL conf = new File(resourcesDir, "axis/conf/axis2.xml").toURI().toURL();
            URL repo = new File(resourcesDir, "axis/").toURI().toURL();
            AxisConfigurator ac = new AxisConfiguratorImpl(conf, repo);
            configurationContext = ConfigurationContextFactory.createConfigurationContext(ac);
            //new ListenerManager().init(configurationContext);
        } catch (Exception ex) {
            throw new FeatureException(ex);
        }
        //configurationContext.getListenerManager().start();
        try {
            Server eoaServer = SystemContext.getContext().getSystem().getServer();
            ClassLoader temp = HTTPServerFeature.class.getClassLoader();
            HTTPServerFeature httpServer = eoaServer.getFeature(HTTPServerFeature.class);
            Map<String, String> params = new HashMap<String,String>();
            Map<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("CONFIGURATION_CONTEXT", configurationContext);
            ServerAuthInfo auth = new ServerAuthInfoImpl("axis", HTTPAuthenticationScheme.BASIC);
            httpServer.addServlet(new AxisServlet(), "/axis2", auth, params, attributes);
        } catch (UniquePathException ue) {
            throw new AxisServerFeatureException(ue.getMessage());
        } catch (Exception ex) {
            throw new AxisServerFeatureException("Failed to configure servlet. " + ex);
        }
    }

    public void spi_destroy() {
        try {
            if (configurationContext != null) {
                configurationContext.cleanupContexts();
                configurationContext.terminate();
            }
        } catch (AxisFault af) {
            System.err.println(af.getMessage());
        }
    }

    public void spi_setConsumer(Extension consumer) {
    }

    public static ConfigurationContext getConfigurationContext() {
        return configurationContext;
    }

}
