/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.test.feature.axis.server.util;

import org.bluestemsoftware.specification.eoa.ext.feature.http.server.HTTPServerFeature.ServerAuthInfo;
import org.bluestemsoftware.specification.eoa.ext.feature.ws.transport.http.HTTPAuthenticationScheme;

public class ServerAuthInfoImpl implements ServerAuthInfo {

    private String realm;
    private HTTPAuthenticationScheme scheme;
    
    public ServerAuthInfoImpl(String realm, HTTPAuthenticationScheme scheme) {
        this.realm = realm;
        this.scheme = scheme;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.feature.http.server.HTTPServerFeature$ServerAuthInfo#getRealm()
     */
    public String getRealm() {
        return realm;
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.feature.http.server.HTTPServerFeature$ServerAuthInfo#getScheme()
     */
    public HTTPAuthenticationScheme getScheme() {
        return scheme;
    }
    
}
