package org.bluestemsoftware.open.eoa.test.feature.axis.server.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Map;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.transport.http.AxisServlet;

public class AxisServletImpl extends AxisServlet {

    private static final long serialVersionUID = 1L;
    private ClassLoader featureLoader;

    public AxisServletImpl(ClassLoader featureLoader) {
        super();
        this.featureLoader = featureLoader;
    }

    @Override
    protected MessageContext createMessageContext(HttpServletRequest request, HttpServletResponse response, boolean invocationType) throws IOException {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            return super.createMessageContext(request, response, invocationType);
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    protected MessageContext createMessageContext(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            return super.createMessageContext(req, resp);
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    public void destroy() {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            super.destroy();
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            super.doDelete(request, response);
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            super.doGet(request, response);
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            super.doPost(request, response);
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            super.doPut(request, response);
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    public EndpointReference getEPRForService(String serviceName, String ip) throws AxisFault {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            return super.getEPRForService(serviceName, ip);
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            return super.getEPRsForService(serviceName, ip);
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    public SessionContext getSessionContext(MessageContext messageContext) {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            return super.getSessionContext(messageContext);
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    protected Map<?,?> getTransportHeaders(HttpServletRequest req) {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            return super.getTransportHeaders(req);
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    protected void handleFault(MessageContext msgContext, OutputStream out, AxisFault e) throws AxisFault {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            super.handleFault(msgContext, out, e);
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    public void init() throws ServletException {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            super.init();
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    public void init(ConfigurationContext axisConf, TransportInDescription transprtIn) throws AxisFault {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            super.init(axisConf, transprtIn);
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    public void init(ServletConfig config) throws ServletException {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            super.init(config);
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    protected ConfigurationContext initConfigContext(ServletConfig config) throws ServletException {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            return super.initConfigContext(config);
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    public void initContextRoot(HttpServletRequest req) {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            super.initContextRoot(req);
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    protected void initParams() {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            super.initParams();
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    protected void showRestDisabledErrorMessage(HttpServletResponse response) throws IOException {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            super.showRestDisabledErrorMessage(response);
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    public void start() throws AxisFault {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            super.start();
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    public void stop() throws AxisFault {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            super.stop();
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            super.doHead(req, resp);
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            super.doOptions(req, resp);
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            super.doTrace(req, resp);
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    protected long getLastModified(HttpServletRequest req) {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            return super.getLastModified(req);
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            super.service(req, resp);
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            super.service(req, res);
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    public String getInitParameter(String name) {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            return super.getInitParameter(name);
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    public Enumeration<?> getInitParameterNames() {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            return super.getInitParameterNames();
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    public ServletConfig getServletConfig() {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            return super.getServletConfig();
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    public ServletContext getServletContext() {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            return super.getServletContext();
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    public String getServletInfo() {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            return super.getServletInfo();
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    public String getServletName() {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            return super.getServletName();
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    public void log(String msg) {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            super.log(msg);
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    public void log(String message, Throwable t) {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            super.log(message, t);
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            return super.clone();
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    public boolean equals(Object obj) {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            return super.equals(obj);
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    protected void finalize() throws Throwable {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            super.finalize();
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    public int hashCode() {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            return super.hashCode();
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    @Override
    public String toString() {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(featureLoader);
            return super.toString();
        } finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

}
