/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.feature.http.client.commons.mgmt.jmx;

import java.io.IOException;
import java.util.Map;

import javax.management.JMException;


/**
 * Management interface exposed via JMX. Note that jmx attribute model is read only, i.e. no
 * attribute setters. just attribute getters and operations
 */
public interface HTTPClientMXBean {

    public Map<String,String> getClientConfiguration() throws JMException, IOException;
    
    public Map<String, Map<String,String>> getHostConfiguration() throws JMException, IOException;

}
