/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.feature.http.client.commons.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import org.bluestemsoftware.specification.eoa.ext.feature.http.client.HTTPClientRequest.RequestEntity;
import org.bluestemsoftware.specification.eoa.system.SystemContext;
import org.bluestemsoftware.specification.eoa.system.System.Log;

public class RequestEntityImpl implements org.apache.commons.httpclient.methods.RequestEntity {

    private static final Log log = SystemContext.getContext().getSystem().getLog(RequestEntity.class);

    private RequestEntity underlying;
    private byte[] buffer = null;

    public RequestEntityImpl(RequestEntity requestEntity) {
        this.underlying = requestEntity;
    }

    /*
     * (non-Javadoc)
     * @see org.apache.commons.httpclient.methods.RequestEntity#getContentLength()
     */
    public long getContentLength() {
        
        // note that this is only invoked when transfer encoding is not chunked,
        // i.e. if http 1.0 or caller specifies an encoding other than chunked.
        // otherwise the request is streamed rather than buffered to memory
        
        if (buffer == null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                underlying.writeRequest(out);
                buffer = out.toByteArray();
            } catch (IOException ie) {
                log.error("error buffering request. " + ie);
                return -1;
            }
        }
        
        return buffer.length;
        
    }

    /*
     * (non-Javadoc)
     * @see org.apache.commons.httpclient.methods.RequestEntity#getContentType()
     */
    public String getContentType() {
        return null; // content type header is set via a request header
    }

    public boolean isRepeatable() {
        return true;
    }

    public void writeRequest(OutputStream out) throws IOException {
        if (buffer == null) {
            underlying.writeRequest(out);
        } else {
            out.write(buffer);
        }
    }

}
