/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.feature.http.client.commons;

import org.bluestemsoftware.specification.eoa.ext.feature.http.client.HTTPClientFeature;
import org.bluestemsoftware.specification.eoa.ext.feature.http.client.HTTPClientFeatureFactory;

public final class HTTPClientFeatureFactoryImpl implements HTTPClientFeatureFactory.Provider {

    public static final String NAME = "commons-http-client";

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.ExtensionFactory$Provider#spi_getName()
     */
    public String spi_getName() {
        return NAME;
    }
    
    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.feature.FeatureFactory$Provider#spi_createFeature()
     */
    public HTTPClientFeature.Provider spi_createFeature() {
        return new HTTPClientFeatureImpl();
    }

    /*
     * (non-Javadoc)
     * @see org.bluestemsoftware.specification.eoa.ext.feature.FeatureFactory$Provider#spi_getFeatureImpl()
     */
    public String spi_getFeatureImpl() {
        return HTTPClientFeatureImpl.IMPL;
    }

}
