/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.ext.feature.http.client.commons.xbean;

import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.params.HttpMethodParams;

public class PropertyValue {
    private Object untypedValue;

    public PropertyValue() {
    }

    public PropertyValue(Object untypedValue) {
        this.untypedValue = untypedValue;
    }

    public void setValue(Object untypedValue) {
        this.untypedValue = untypedValue;
    }

    public String getUntypedValue() {
        if (untypedValue instanceof String) {
            return (String)untypedValue;
        } else {
            return "unavailable";
        }
    }

    public Object getValue(String propertyName) {

        // this method is invoked exactly once, so no need to save off
        // typed value

        // HTTP Method properties

        if (HttpMethodParams.UNAMBIGUOUS_STATUS_LINE.equals(propertyName)) {
            if (!(untypedValue instanceof String)) {
                throw new IllegalArgumentException("Param '"
                        + propertyName
                        + "' cannot be converted from "
                        + untypedValue.getClass()
                        + " to Boolean.");
            } else {
                return Boolean.parseBoolean((String)untypedValue);
            }
        }

        if (HttpMethodParams.SINGLE_COOKIE_HEADER.equals(propertyName)) {
            if (!(untypedValue instanceof String)) {
                throw new IllegalArgumentException("Param '"
                        + propertyName
                        + "' cannot be converted from "
                        + untypedValue.getClass()
                        + " to Boolean.");
            } else {
                return Boolean.parseBoolean((String)untypedValue);
            }
        }

        if (HttpMethodParams.STRICT_TRANSFER_ENCODING.equals(propertyName)) {
            if (!(untypedValue instanceof String)) {
                throw new IllegalArgumentException("Param '"
                        + propertyName
                        + "' cannot be converted from "
                        + untypedValue.getClass()
                        + " to Boolean.");
            } else {
                return Boolean.parseBoolean((String)untypedValue);
            }
        }

        if (HttpMethodParams.REJECT_HEAD_BODY.equals(propertyName)) {
            if (!(untypedValue instanceof String)) {
                throw new IllegalArgumentException("Param '"
                        + propertyName
                        + "' cannot be converted from "
                        + untypedValue.getClass()
                        + " to Boolean.");
            } else {
                return Boolean.parseBoolean((String)untypedValue);
            }
        }

        if (HttpMethodParams.HEAD_BODY_CHECK_TIMEOUT.equals(propertyName)) {
            if (!(untypedValue instanceof String)) {
                throw new IllegalArgumentException("Param '"
                        + propertyName
                        + "' cannot be converted from "
                        + untypedValue.getClass()
                        + " to Integer.");
            } else {
                return Integer.parseInt((String)untypedValue);
            }
        }

        if (HttpMethodParams.USE_EXPECT_CONTINUE.equals(propertyName)) {
            if (!(untypedValue instanceof String)) {
                throw new IllegalArgumentException("Param '"
                        + propertyName
                        + "' cannot be converted from "
                        + untypedValue.getClass()
                        + " to Boolean.");
            } else {
                return Boolean.parseBoolean((String)untypedValue);
            }
        }

        if (HttpMethodParams.WARN_EXTRA_INPUT.equals(propertyName)) {
            if (!(untypedValue instanceof String)) {
                throw new IllegalArgumentException("Param '"
                        + propertyName
                        + "' cannot be converted from "
                        + untypedValue.getClass()
                        + " to Boolean.");
            } else {
                return Boolean.parseBoolean((String)untypedValue);
            }
        }

        if (HttpMethodParams.STATUS_LINE_GARBAGE_LIMIT.equals(propertyName)) {
            if (!(untypedValue instanceof String)) {
                throw new IllegalArgumentException("Param '"
                        + propertyName
                        + "' cannot be converted from "
                        + untypedValue.getClass()
                        + " to Integer.");
            } else {
                return Integer.parseInt((String)untypedValue);
            }
        }

        if (HttpMethodParams.SO_TIMEOUT.equals(propertyName)) {
            if (!(untypedValue instanceof String)) {
                throw new IllegalArgumentException("Param '"
                        + propertyName
                        + "' cannot be converted from "
                        + untypedValue.getClass()
                        + " to Integer.");
            } else {
                return Integer.parseInt((String)untypedValue);
            }
        }

        if (HttpMethodParams.BUFFER_WARN_TRIGGER_LIMIT.equals(propertyName)) {
            if (!(untypedValue instanceof String)) {
                throw new IllegalArgumentException("Param '"
                        + propertyName
                        + "' cannot be converted from "
                        + untypedValue.getClass()
                        + " to Integer.");
            } else {
                return Integer.parseInt((String)untypedValue);
            }
        }

        // HTTP Client properties

        if (HttpClientParams.CONNECTION_MANAGER_TIMEOUT.equals(propertyName)) {
            if (!(untypedValue instanceof String)) {
                throw new IllegalArgumentException("Param '"
                        + propertyName
                        + "' cannot be converted from "
                        + untypedValue.getClass()
                        + " to Long.");
            } else {
                return Long.parseLong((String)untypedValue);
            }
        }

        if (HttpClientParams.PREEMPTIVE_AUTHENTICATION.equals(propertyName)) {
            if (!(untypedValue instanceof String)) {
                throw new IllegalArgumentException("Param '"
                        + propertyName
                        + "' cannot be converted from "
                        + untypedValue.getClass()
                        + " to Boolean.");
            } else {
                return Boolean.parseBoolean((String)untypedValue);
            }
        }

        if (HttpClientParams.REJECT_RELATIVE_REDIRECT.equals(propertyName)) {
            if (!(untypedValue instanceof String)) {
                throw new IllegalArgumentException("Param '"
                        + propertyName
                        + "' cannot be converted from "
                        + untypedValue.getClass()
                        + " to Boolean.");
            } else {
                return Boolean.parseBoolean((String)untypedValue);
            }
        }

        if (HttpClientParams.MAX_REDIRECTS.equals(propertyName)) {
            if (!(untypedValue instanceof String)) {
                throw new IllegalArgumentException("Param '"
                        + propertyName
                        + "' cannot be converted from "
                        + untypedValue.getClass()
                        + " to Integer.");
            } else {
                return Integer.parseInt((String)untypedValue);
            }
        }

        if (HttpClientParams.ALLOW_CIRCULAR_REDIRECTS.equals(propertyName)) {
            if (!(untypedValue instanceof String)) {
                throw new IllegalArgumentException("Param '"
                        + propertyName
                        + "' cannot be converted from "
                        + untypedValue.getClass()
                        + " to Boolean.");
            } else {
                return Boolean.parseBoolean((String)untypedValue);
            }
        }

        // HTTP Connection properties

        if (HttpConnectionParams.SO_TIMEOUT.equals(propertyName)) {
            if (!(untypedValue instanceof String)) {
                throw new IllegalArgumentException("Param '"
                        + propertyName
                        + "' cannot be converted from "
                        + untypedValue.getClass()
                        + " to Integer.");
            } else {
                return Integer.parseInt((String)untypedValue);
            }
        }

        if (HttpConnectionParams.TCP_NODELAY.equals(propertyName)) {
            if (!(untypedValue instanceof String)) {
                throw new IllegalArgumentException("Param '"
                        + propertyName
                        + "' cannot be converted from "
                        + untypedValue.getClass()
                        + " to Boolean.");
            } else {
                return Boolean.parseBoolean((String)untypedValue);
            }
        }

        if (HttpConnectionParams.SO_SNDBUF.equals(propertyName)) {
            if (!(untypedValue instanceof String)) {
                throw new IllegalArgumentException("Param '"
                        + propertyName
                        + "' cannot be converted from "
                        + untypedValue.getClass()
                        + " to Integer.");
            } else {
                return Integer.parseInt((String)untypedValue);
            }
        }

        if (HttpConnectionParams.SO_RCVBUF.equals(propertyName)) {
            if (!(untypedValue instanceof String)) {
                throw new IllegalArgumentException("Param '"
                        + propertyName
                        + "' cannot be converted from "
                        + untypedValue.getClass()
                        + " to Integer.");
            } else {
                return Integer.parseInt((String)untypedValue);
            }
        }

        if (HttpConnectionParams.SO_LINGER.equals(propertyName)) {
            if (!(untypedValue instanceof String)) {
                throw new IllegalArgumentException("Param '"
                        + propertyName
                        + "' cannot be converted from "
                        + untypedValue.getClass()
                        + " to Integer.");
            } else {
                return Integer.parseInt((String)untypedValue);
            }
        }

        if (HttpConnectionParams.CONNECTION_TIMEOUT.equals(propertyName)) {
            if (!(untypedValue instanceof String)) {
                throw new IllegalArgumentException("Param '"
                        + propertyName
                        + "' cannot be converted from "
                        + untypedValue.getClass()
                        + " to Integer.");
            } else {
                return Integer.parseInt((String)untypedValue);
            }
        }

        if (HttpConnectionParams.STALE_CONNECTION_CHECK.equals(propertyName)) {
            if (!(untypedValue instanceof String)) {
                throw new IllegalArgumentException("Param '"
                        + propertyName
                        + "' cannot be converted from "
                        + untypedValue.getClass()
                        + " to Boolean.");
            } else {
                return Boolean.parseBoolean((String)untypedValue);
            }
        }

        // HTTP Connection manager properties

        if (HttpConnectionManagerParams.MAX_HOST_CONNECTIONS.equals(propertyName)) {
            if (!(untypedValue instanceof Map)) {
                throw new IllegalArgumentException("Param '"
                        + propertyName
                        + "' cannot be converted from "
                        + untypedValue.getClass()
                        + " to Map.");
            } else {
                Map<HostConfiguration, Integer> temp = new HashMap<HostConfiguration, Integer>();
                Iterator<?> itr = ((Map<?,?>)untypedValue).entrySet().iterator();
                while (itr.hasNext()) {
                    try {
                        Map.Entry<?,?> entry = (Map.Entry<?,?>)itr.next();
                        String key = (String)entry.getKey();
                        Integer value = Integer.valueOf((String)entry.getValue());
                        URI uri = new URI(key);
                        HostConfiguration config = new HostConfiguration();
                        config.setHost(uri.getHost(), uri.getPort(), uri.getScheme());
                        temp.put(config, value);
                    } catch (Exception ex) {
                        throw new IllegalArgumentException("Error setting param '"
                                + propertyName
                                + "'. Error converting Map<String,String> to Map<HostConfiguration,Integer>. "
                                + ex);
                    }
                }
                return temp;
            }
        }

        if (HttpConnectionManagerParams.MAX_TOTAL_CONNECTIONS.equals(propertyName)) {
            if (!(untypedValue instanceof String)) {
                throw new IllegalArgumentException("Param '"
                        + propertyName
                        + "' cannot be converted from "
                        + untypedValue.getClass()
                        + " to Integer.");
            } else {
                return Integer.parseInt((String)untypedValue);
            }
        }

        // non-primitive property values are left as is. if not appropriate type,
        // then class cast exception will be thrown within appropriate parms
        // collection

        return untypedValue;

    }
}
